import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resetComponent } from '../../style';
import { genPanelStyle, initPickerPanelToken } from '../../date-picker/style';
import { initInputToken } from '../../input/style';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
export var genCalendarStyles = function genCalendarStyles(token) {
  var _$concat, _$concat$concat, _$concat2, _$concat4, _$concat$concat3, _$concat5, _ref;
  var calendarCls = token.calendarCls,
    componentCls = token.componentCls,
    calendarFullBg = token.calendarFullBg,
    calendarFullPanelBg = token.calendarFullPanelBg,
    calendarItemActiveBg = token.calendarItemActiveBg;
  return _ref = {}, _defineProperty(_ref, calendarCls, _extends(_extends(_extends({}, genPanelStyle(token)), resetComponent(token)), _defineProperty({
    background: calendarFullBg,
    '&-rtl': {
      direction: 'rtl'
    }
  }, "".concat(calendarCls, "-header"), (_$concat = {
    display: 'flex',
    justifyContent: 'flex-end',
    padding: "".concat(token.paddingSM, "px 0")
  }, _defineProperty(_$concat, "".concat(calendarCls, "-year-select"), {
    minWidth: token.yearControlWidth
  }), _defineProperty(_$concat, "".concat(calendarCls, "-month-select"), {
    minWidth: token.monthControlWidth,
    marginInlineStart: token.marginXS
  }), _defineProperty(_$concat, "".concat(calendarCls, "-mode-switch"), {
    marginInlineStart: token.marginXS
  }), _$concat)))), _defineProperty(_ref, "".concat(calendarCls, " ").concat(componentCls, "-panel"), (_$concat$concat = {
    background: calendarFullPanelBg,
    border: 0,
    borderTop: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit),
    borderRadius: 0
  }, _defineProperty(_$concat$concat, "".concat(componentCls, "-month-panel, ").concat(componentCls, "-date-panel"), {
    width: 'auto'
  }), _defineProperty(_$concat$concat, "".concat(componentCls, "-body"), {
    padding: "".concat(token.paddingXS, "px 0")
  }), _defineProperty(_$concat$concat, "".concat(componentCls, "-content"), {
    width: '100%'
  }), _$concat$concat)), _defineProperty(_ref, "".concat(calendarCls, "-mini"), (_$concat2 = {
    borderRadius: token.borderRadiusLG
  }, _defineProperty(_$concat2, "".concat(calendarCls, "-header"), {
    paddingInlineEnd: token.paddingXS,
    paddingInlineStart: token.paddingXS
  }), _defineProperty(_$concat2, "".concat(componentCls, "-panel"), {
    borderRadius: "0 0 ".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px")
  }), _defineProperty(_$concat2, "".concat(componentCls, "-content"), {
    height: token.miniContentHeight,
    th: {
      height: 'auto',
      padding: 0,
      lineHeight: "".concat(token.weekHeight, "px")
    }
  }), _defineProperty(_$concat2, "".concat(componentCls, "-cell::before"), {
    pointerEvents: 'none'
  }), _$concat2)), _defineProperty(_ref, "".concat(calendarCls).concat(calendarCls, "-full"), (_$concat$concat3 = {}, _defineProperty(_$concat$concat3, "".concat(componentCls, "-panel"), _defineProperty({
    display: 'block',
    width: '100%',
    textAlign: 'end',
    background: calendarFullBg,
    border: 0
  }, "".concat(componentCls, "-body"), {
    'th, td': {
      padding: 0
    },
    th: {
      height: 'auto',
      paddingInlineEnd: token.paddingSM,
      paddingBottom: token.paddingXXS,
      lineHeight: "".concat(token.weekHeight, "px")
    }
  })), _defineProperty(_$concat$concat3, "".concat(componentCls, "-cell"), (_$concat4 = {
    '&::before': {
      display: 'none'
    },
    '&:hover': _defineProperty({}, "".concat(calendarCls, "-date"), {
      background: token.controlItemBgHover
    })
  }, _defineProperty(_$concat4, "".concat(calendarCls, "-date-today::before"), {
    display: 'none'
  }), _defineProperty(_$concat4, "&-in-view".concat(componentCls, "-cell-selected"), _defineProperty({}, "".concat(calendarCls, "-date, ").concat(calendarCls, "-date-today"), {
    background: calendarItemActiveBg
  })), _defineProperty(_$concat4, '&-selected, &-selected:hover', _defineProperty({}, "".concat(calendarCls, "-date, ").concat(calendarCls, "-date-today"), _defineProperty({}, "".concat(calendarCls, "-date-value"), {
    color: token.colorPrimary
  }))), _$concat4)), _defineProperty(_$concat$concat3, "".concat(calendarCls, "-date"), {
    display: 'block',
    width: 'auto',
    height: 'auto',
    margin: "0 ".concat(token.marginXS / 2, "px"),
    padding: "".concat(token.paddingXS / 2, "px ").concat(token.paddingXS, "px 0"),
    border: 0,
    borderTop: "".concat(token.lineWidthBold, "px ").concat(token.lineType, " ").concat(token.colorSplit),
    borderRadius: 0,
    transition: "background ".concat(token.motionDurationSlow),
    '&-value': {
      lineHeight: "".concat(token.dateValueHeight, "px"),
      transition: "color ".concat(token.motionDurationSlow)
    },
    '&-content': {
      position: 'static',
      width: 'auto',
      height: token.dateContentHeight,
      overflowY: 'auto',
      color: token.colorText,
      lineHeight: token.lineHeight,
      textAlign: 'start'
    },
    '&-today': _defineProperty({
      borderColor: token.colorPrimary
    }, "".concat(calendarCls, "-date-value"), {
      color: token.colorText
    })
  }), _$concat$concat3)), _defineProperty(_ref, "@media only screen and (max-width: ".concat(token.screenXS, "px) "), _defineProperty({}, "".concat(calendarCls), _defineProperty({}, "".concat(calendarCls, "-header"), (_$concat5 = {
    display: 'block'
  }, _defineProperty(_$concat5, "".concat(calendarCls, "-year-select"), {
    width: '50%'
  }), _defineProperty(_$concat5, "".concat(calendarCls, "-month-select"), {
    width: "calc(50% - ".concat(token.paddingXS, "px)")
  }), _defineProperty(_$concat5, "".concat(calendarCls, "-mode-switch"), {
    width: '100%',
    marginTop: token.marginXS,
    marginInlineStart: 0,
    '> label': {
      width: '50%',
      textAlign: 'center'
    }
  }), _$concat5)))), _ref;
};
export default genComponentStyleHook('Calendar', function (token) {
  var calendarCls = "".concat(token.componentCls, "-calendar");
  var calendarToken = mergeToken(initInputToken(token), initPickerPanelToken(token), {
    calendarCls: calendarCls,
    pickerCellInnerCls: "".concat(token.componentCls, "-cell-inner"),
    calendarFullBg: token.colorBgContainer,
    calendarFullPanelBg: token.colorBgContainer,
    calendarItemActiveBg: token.controlItemBgActive,
    dateValueHeight: token.controlHeightSM,
    weekHeight: token.controlHeightSM * 0.75,
    dateContentHeight: (token.fontSizeSM * token.lineHeightSM + token.marginXS) * 3 + token.lineWidth * 2
  });
  return [genCalendarStyles(calendarToken)];
}, {
  yearControlWidth: 80,
  monthControlWidth: 70,
  miniContentHeight: 256
});