import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { isVNode, defineComponent, renderSlot } from 'vue';
import Tabs from '../tabs';
import PropTypes from '../_util/vue-types';
import { flattenChildren, isEmptyElement, filterEmptyWithUndefined } from '../_util/props-util';
import isPlainObject from 'lodash-es/isPlainObject';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import devWarning from '../vc-util/devWarning';
import useStyle from './style';
import Skeleton from '../skeleton';
var TabPane = Tabs.TabPane;
export var cardProps = function cardProps() {
  return {
    prefixCls: String,
    title: PropTypes.any,
    extra: PropTypes.any,
    bordered: {
      type: Boolean,
      default: true
    },
    bodyStyle: {
      type: Object,
      default: undefined
    },
    headStyle: {
      type: Object,
      default: undefined
    },
    loading: {
      type: Boolean,
      default: false
    },
    hoverable: {
      type: Boolean,
      default: false
    },
    type: {
      type: String
    },
    size: {
      type: String
    },
    actions: PropTypes.any,
    tabList: {
      type: Array
    },
    tabBarExtraContent: PropTypes.any,
    activeTabKey: String,
    defaultActiveTabKey: String,
    cover: PropTypes.any,
    onTabChange: {
      type: Function
    }
  };
};
var Card = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ACard',
  inheritAttrs: false,
  props: cardProps(),
  slots: ['title', 'extra', 'tabBarExtraContent', 'actions', 'cover', 'customTab'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('card', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var getAction = function getAction(actions) {
      var actionList = actions.map(function (action, index) {
        return isVNode(action) && !isEmptyElement(action) || !isVNode(action) ? _createVNode("li", {
          "style": {
            width: "".concat(100 / actions.length, "%")
          },
          "key": "action-".concat(index)
        }, [_createVNode("span", null, [action])]) : null;
      });
      return actionList;
    };
    var triggerTabChange = function triggerTabChange(key) {
      var _a;
      (_a = props.onTabChange) === null || _a === void 0 ? void 0 : _a.call(props, key);
    };
    var isContainGrid = function isContainGrid() {
      var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var containGrid;
      obj.forEach(function (element) {
        if (element && isPlainObject(element.type) && element.type.__ANT_CARD_GRID) {
          containGrid = true;
        }
      });
      return containGrid;
    };
    return function () {
      var _classString, _tabsProps;
      var _a, _b, _c, _d, _e, _f;
      var _props$headStyle = props.headStyle,
        headStyle = _props$headStyle === void 0 ? {} : _props$headStyle,
        _props$bodyStyle = props.bodyStyle,
        bodyStyle = _props$bodyStyle === void 0 ? {} : _props$bodyStyle,
        loading = props.loading,
        _props$bordered = props.bordered,
        bordered = _props$bordered === void 0 ? true : _props$bordered,
        type = props.type,
        tabList = props.tabList,
        hoverable = props.hoverable,
        activeTabKey = props.activeTabKey,
        defaultActiveTabKey = props.defaultActiveTabKey,
        _props$tabBarExtraCon = props.tabBarExtraContent,
        tabBarExtraContent = _props$tabBarExtraCon === void 0 ? filterEmptyWithUndefined((_a = slots.tabBarExtraContent) === null || _a === void 0 ? void 0 : _a.call(slots)) : _props$tabBarExtraCon,
        _props$title = props.title,
        title = _props$title === void 0 ? filterEmptyWithUndefined((_b = slots.title) === null || _b === void 0 ? void 0 : _b.call(slots)) : _props$title,
        _props$extra = props.extra,
        extra = _props$extra === void 0 ? filterEmptyWithUndefined((_c = slots.extra) === null || _c === void 0 ? void 0 : _c.call(slots)) : _props$extra,
        _props$actions = props.actions,
        actions = _props$actions === void 0 ? filterEmptyWithUndefined((_d = slots.actions) === null || _d === void 0 ? void 0 : _d.call(slots)) : _props$actions,
        _props$cover = props.cover,
        cover = _props$cover === void 0 ? filterEmptyWithUndefined((_e = slots.cover) === null || _e === void 0 ? void 0 : _e.call(slots)) : _props$cover;
      var children = flattenChildren((_f = slots.default) === null || _f === void 0 ? void 0 : _f.call(slots));
      var pre = prefixCls.value;
      var classString = (_classString = {}, _defineProperty(_classString, "".concat(pre), true), _defineProperty(_classString, hashId.value, true), _defineProperty(_classString, "".concat(pre, "-loading"), loading), _defineProperty(_classString, "".concat(pre, "-bordered"), bordered), _defineProperty(_classString, "".concat(pre, "-hoverable"), !!hoverable), _defineProperty(_classString, "".concat(pre, "-contain-grid"), isContainGrid(children)), _defineProperty(_classString, "".concat(pre, "-contain-tabs"), tabList && tabList.length), _defineProperty(_classString, "".concat(pre, "-").concat(size.value), size.value), _defineProperty(_classString, "".concat(pre, "-type-").concat(type), !!type), _defineProperty(_classString, "".concat(pre, "-rtl"), direction.value === 'rtl'), _classString);
      var loadingBlock = _createVNode(Skeleton, {
        "loading": true,
        "active": true,
        "paragraph": {
          rows: 4
        },
        "title": false
      }, {
        default: function _default() {
          return [children];
        }
      });
      var hasActiveTabKey = activeTabKey !== undefined;
      var tabsProps = (_tabsProps = {
        size: 'large'
      }, _defineProperty(_tabsProps, hasActiveTabKey ? 'activeKey' : 'defaultActiveKey', hasActiveTabKey ? activeTabKey : defaultActiveTabKey), _defineProperty(_tabsProps, "onChange", triggerTabChange), _defineProperty(_tabsProps, "class", "".concat(pre, "-head-tabs")), _tabsProps);
      var head;
      var tabs = tabList && tabList.length ? _createVNode(Tabs, tabsProps, {
        default: function _default() {
          return [tabList.map(function (item) {
            var temp = item.tab,
              itemSlots = item.slots;
            var name = itemSlots === null || itemSlots === void 0 ? void 0 : itemSlots.tab;
            devWarning(!itemSlots, 'Card', "tabList slots is deprecated, Please use `customTab` instead.");
            var tab = temp !== undefined ? temp : slots[name] ? slots[name](item) : null;
            tab = renderSlot(slots, 'customTab', item, function () {
              return [tab];
            });
            return _createVNode(TabPane, {
              "tab": tab,
              "key": item.key,
              "disabled": item.disabled
            }, null);
          })];
        },
        rightExtra: tabBarExtraContent ? function () {
          return tabBarExtraContent;
        } : null
      }) : null;
      if (title || extra || tabs) {
        head = _createVNode("div", {
          "class": "".concat(pre, "-head"),
          "style": headStyle
        }, [_createVNode("div", {
          "class": "".concat(pre, "-head-wrapper")
        }, [title && _createVNode("div", {
          "class": "".concat(pre, "-head-title")
        }, [title]), extra && _createVNode("div", {
          "class": "".concat(pre, "-extra")
        }, [extra])]), tabs]);
      }
      var coverDom = cover ? _createVNode("div", {
        "class": "".concat(pre, "-cover")
      }, [cover]) : null;
      var body = _createVNode("div", {
        "class": "".concat(pre, "-body"),
        "style": bodyStyle
      }, [loading ? loadingBlock : children]);
      var actionDom = actions && actions.length ? _createVNode("ul", {
        "class": "".concat(pre, "-actions")
      }, [getAction(actions)]) : null;
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({
        "ref": "cardContainerRef"
      }, attrs), {}, {
        "class": [classString, attrs.class]
      }), [head, coverDom, children && children.length ? body : null, actionDom]));
    };
  }
});
export default Card;