import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { clearFix, resetComponent, textEllipsis } from '../../style';
// ============================== Styles ==============================
// ============================== Head ==============================
var genCardHeadStyle = function genCardHeadStyle(token) {
  var antCls = token.antCls,
    componentCls = token.componentCls,
    cardHeadHeight = token.cardHeadHeight,
    cardPaddingBase = token.cardPaddingBase,
    cardHeadTabsMarginBottom = token.cardHeadTabsMarginBottom;
  return _extends(_extends({
    display: 'flex',
    justifyContent: 'center',
    flexDirection: 'column',
    minHeight: cardHeadHeight,
    marginBottom: -1,
    padding: "0 ".concat(cardPaddingBase, "px"),
    color: token.colorTextHeading,
    fontWeight: token.fontWeightStrong,
    fontSize: token.fontSizeLG,
    background: 'transparent',
    borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorderSecondary),
    borderRadius: "".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px 0 0")
  }, clearFix()), _defineProperty({
    '&-wrapper': {
      width: '100%',
      display: 'flex',
      alignItems: 'center'
    },
    '&-title': _extends(_extends({
      display: 'inline-block',
      flex: 1
    }, textEllipsis), _defineProperty({}, "\n          > ".concat(componentCls, "-typography,\n          > ").concat(componentCls, "-typography-edit-content\n        "), {
      insetInlineStart: 0,
      marginTop: 0,
      marginBottom: 0
    }))
  }, "".concat(antCls, "-tabs-top"), {
    clear: 'both',
    marginBottom: cardHeadTabsMarginBottom,
    color: token.colorText,
    fontWeight: 'normal',
    fontSize: token.fontSize,
    '&-bar': {
      borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorderSecondary)
    }
  }));
};
// ============================== Grid ==============================
var genCardGridStyle = function genCardGridStyle(token) {
  var cardPaddingBase = token.cardPaddingBase,
    colorBorderSecondary = token.colorBorderSecondary,
    cardShadow = token.cardShadow,
    lineWidth = token.lineWidth;
  return {
    width: '33.33%',
    padding: cardPaddingBase,
    border: 0,
    borderRadius: 0,
    boxShadow: "\n      ".concat(lineWidth, "px 0 0 0 ").concat(colorBorderSecondary, ",\n      0 ").concat(lineWidth, "px 0 0 ").concat(colorBorderSecondary, ",\n      ").concat(lineWidth, "px ").concat(lineWidth, "px 0 0 ").concat(colorBorderSecondary, ",\n      ").concat(lineWidth, "px 0 0 0 ").concat(colorBorderSecondary, " inset,\n      0 ").concat(lineWidth, "px 0 0 ").concat(colorBorderSecondary, " inset;\n    "),
    transition: "all ".concat(token.motionDurationMid),
    '&-hoverable:hover': {
      position: 'relative',
      zIndex: 1,
      boxShadow: cardShadow
    }
  };
};
// ============================== Actions ==============================
var genCardActionsStyle = function genCardActionsStyle(token) {
  var _span;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    cardActionsLiMargin = token.cardActionsLiMargin,
    cardActionsIconSize = token.cardActionsIconSize,
    colorBorderSecondary = token.colorBorderSecondary;
  return _extends(_extends({
    margin: 0,
    padding: 0,
    listStyle: 'none',
    background: token.colorBgContainer,
    borderTop: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(colorBorderSecondary),
    display: 'flex',
    borderRadius: "0 0 ".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px ")
  }, clearFix()), {
    '& > li': {
      margin: cardActionsLiMargin,
      color: token.colorTextDescription,
      textAlign: 'center',
      '> span': (_span = {
        position: 'relative',
        display: 'block',
        minWidth: token.cardActionsIconSize * 2,
        fontSize: token.fontSize,
        lineHeight: token.lineHeight,
        cursor: 'pointer',
        '&:hover': {
          color: token.colorPrimary,
          transition: "color ".concat(token.motionDurationMid)
        }
      }, _defineProperty(_span, "a:not(".concat(componentCls, "-btn), > ").concat(iconCls), {
        display: 'inline-block',
        width: '100%',
        color: token.colorTextDescription,
        lineHeight: "".concat(token.fontSize * token.lineHeight, "px"),
        transition: "color ".concat(token.motionDurationMid),
        '&:hover': {
          color: token.colorPrimary
        }
      }), _defineProperty(_span, "> ".concat(iconCls), {
        fontSize: cardActionsIconSize,
        lineHeight: "".concat(cardActionsIconSize * token.lineHeight, "px")
      }), _span),
      '&:not(:last-child)': {
        borderInlineEnd: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(colorBorderSecondary)
      }
    }
  });
};
// ============================== Meta ==============================
var genCardMetaStyle = function genCardMetaStyle(token) {
  return _extends(_extends({
    margin: "-".concat(token.marginXXS, "px 0"),
    display: 'flex'
  }, clearFix()), {
    '&-avatar': {
      paddingInlineEnd: token.padding
    },
    '&-detail': {
      overflow: 'hidden',
      flex: 1,
      '> div:not(:last-child)': {
        marginBottom: token.marginXS
      }
    },
    '&-title': _extends({
      color: token.colorTextHeading,
      fontWeight: token.fontWeightStrong,
      fontSize: token.fontSizeLG
    }, textEllipsis),
    '&-description': {
      color: token.colorTextDescription
    }
  });
};
// ============================== Inner ==============================
var genCardTypeInnerStyle = function genCardTypeInnerStyle(token) {
  var _ref;
  var componentCls = token.componentCls,
    cardPaddingBase = token.cardPaddingBase,
    colorFillAlter = token.colorFillAlter;
  return _ref = {}, _defineProperty(_ref, "".concat(componentCls, "-head"), {
    padding: "0 ".concat(cardPaddingBase, "px"),
    background: colorFillAlter,
    '&-title': {
      fontSize: token.fontSize
    }
  }), _defineProperty(_ref, "".concat(componentCls, "-body"), {
    padding: "".concat(token.padding, "px ").concat(cardPaddingBase, "px")
  }), _ref;
};
// ============================== Loading ==============================
var genCardLoadingStyle = function genCardLoadingStyle(token) {
  var componentCls = token.componentCls;
  return _defineProperty({
    overflow: 'hidden'
  }, "".concat(componentCls, "-body"), {
    userSelect: 'none'
  });
};
// ============================== Basic ==============================
var genCardStyle = function genCardStyle(token) {
  var _extends4, _$concat2, _ref3;
  var componentCls = token.componentCls,
    cardShadow = token.cardShadow,
    cardHeadPadding = token.cardHeadPadding,
    colorBorderSecondary = token.colorBorderSecondary,
    boxShadow = token.boxShadow,
    cardPaddingBase = token.cardPaddingBase;
  return _ref3 = {}, _defineProperty(_ref3, componentCls, _extends(_extends({}, resetComponent(token)), (_extends4 = {
    position: 'relative',
    background: token.colorBgContainer,
    borderRadius: token.borderRadiusLG
  }, _defineProperty(_extends4, "&:not(".concat(componentCls, "-bordered)"), {
    boxShadow: boxShadow
  }), _defineProperty(_extends4, "".concat(componentCls, "-head"), genCardHeadStyle(token)), _defineProperty(_extends4, "".concat(componentCls, "-extra"), {
    // https://stackoverflow.com/a/22429853/3040605
    marginInlineStart: 'auto',
    color: '',
    fontWeight: 'normal',
    fontSize: token.fontSize
  }), _defineProperty(_extends4, "".concat(componentCls, "-body"), _extends({
    padding: cardPaddingBase,
    borderRadius: " 0 0 ".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px")
  }, clearFix())), _defineProperty(_extends4, "".concat(componentCls, "-grid"), genCardGridStyle(token)), _defineProperty(_extends4, "".concat(componentCls, "-cover"), {
    '> *': {
      display: 'block',
      width: '100%'
    },
    img: {
      borderRadius: "".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px 0 0")
    }
  }), _defineProperty(_extends4, "".concat(componentCls, "-actions"), genCardActionsStyle(token)), _defineProperty(_extends4, "".concat(componentCls, "-meta"), genCardMetaStyle(token)), _extends4))), _defineProperty(_ref3, "".concat(componentCls, "-bordered"), _defineProperty({
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(colorBorderSecondary)
  }, "".concat(componentCls, "-cover"), {
    marginTop: -1,
    marginInlineStart: -1,
    marginInlineEnd: -1
  })), _defineProperty(_ref3, "".concat(componentCls, "-hoverable"), {
    cursor: 'pointer',
    transition: "box-shadow ".concat(token.motionDurationMid, ", border-color ").concat(token.motionDurationMid),
    '&:hover': {
      borderColor: 'transparent',
      boxShadow: cardShadow
    }
  }), _defineProperty(_ref3, "".concat(componentCls, "-contain-grid"), (_$concat2 = {}, _defineProperty(_$concat2, "".concat(componentCls, "-body"), {
    display: 'flex',
    flexWrap: 'wrap'
  }), _defineProperty(_$concat2, "&:not(".concat(componentCls, "-loading) ").concat(componentCls, "-body"), {
    marginBlockStart: -token.lineWidth,
    marginInlineStart: -token.lineWidth,
    padding: 0
  }), _$concat2)), _defineProperty(_ref3, "".concat(componentCls, "-contain-tabs"), _defineProperty({}, "> ".concat(componentCls, "-head"), _defineProperty({}, "".concat(componentCls, "-head-title, ").concat(componentCls, "-extra"), {
    paddingTop: cardHeadPadding
  }))), _defineProperty(_ref3, "".concat(componentCls, "-type-inner"), genCardTypeInnerStyle(token)), _defineProperty(_ref3, "".concat(componentCls, "-loading"), genCardLoadingStyle(token)), _defineProperty(_ref3, "".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }), _ref3;
};
// ============================== Size ==============================
var genCardSizeStyle = function genCardSizeStyle(token) {
  var _$concat7, _ref4;
  var componentCls = token.componentCls,
    cardPaddingSM = token.cardPaddingSM,
    cardHeadHeightSM = token.cardHeadHeightSM;
  return _ref4 = {}, _defineProperty(_ref4, "".concat(componentCls, "-small"), (_$concat7 = {}, _defineProperty(_$concat7, "> ".concat(componentCls, "-head"), _defineProperty({
    minHeight: cardHeadHeightSM,
    padding: "0 ".concat(cardPaddingSM, "px"),
    fontSize: token.fontSize
  }, "> ".concat(componentCls, "-head-wrapper"), _defineProperty({}, "> ".concat(componentCls, "-extra"), {
    fontSize: token.fontSize
  }))), _defineProperty(_$concat7, "> ".concat(componentCls, "-body"), {
    padding: cardPaddingSM
  }), _$concat7)), _defineProperty(_ref4, "".concat(componentCls, "-small").concat(componentCls, "-contain-tabs"), _defineProperty({}, "> ".concat(componentCls, "-head"), _defineProperty({}, "".concat(componentCls, "-head-title, ").concat(componentCls, "-extra"), {
    minHeight: cardHeadHeightSM,
    paddingTop: 0,
    display: 'flex',
    alignItems: 'center'
  }))), _ref4;
};
// ============================== Export ==============================
export default genComponentStyleHook('Card', function (token) {
  var cardToken = mergeToken(token, {
    cardShadow: token.boxShadowCard,
    cardHeadHeight: token.fontSizeLG * token.lineHeightLG + token.padding * 2,
    cardHeadHeightSM: token.fontSize * token.lineHeight + token.paddingXS * 2,
    cardHeadPadding: token.padding,
    cardPaddingBase: token.paddingLG,
    cardHeadTabsMarginBottom: -token.padding - token.lineWidth,
    cardActionsLiMargin: "".concat(token.paddingSM, "px 0"),
    cardActionsIconSize: token.fontSize,
    cardPaddingSM: 12 // Fixed padding.
  });

  return [
  // Style
  genCardStyle(cardToken),
  // Size
  genCardSizeStyle(cardToken)];
});