import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { getStyle as getCheckboxStyle } from '../../checkbox/style';
import { genComponentStyleHook } from '../../theme/internal';
import { textEllipsis } from '../../style';
import { genCompactItemStyle } from '../../style/compact-item';
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _extends2;
  var prefixCls = token.prefixCls,
    componentCls = token.componentCls,
    antCls = token.antCls;
  var cascaderMenuItemCls = "".concat(componentCls, "-menu-item");
  var iconCls = "\n    &".concat(cascaderMenuItemCls, "-expand ").concat(cascaderMenuItemCls, "-expand-icon,\n    ").concat(cascaderMenuItemCls, "-loading-icon\n  ");
  var itemPaddingVertical = Math.round((token.controlHeight - token.fontSize * token.lineHeight) / 2);
  return [// =====================================================
  // ==                     Control                     ==
  // =====================================================
  _defineProperty({}, componentCls, {
    width: token.controlWidth
  }), // =====================================================
  // ==                      Popup                      ==
  // =====================================================
  _defineProperty({}, "".concat(componentCls, "-dropdown"), [
  // ==================== Checkbox ====================
  getCheckboxStyle("".concat(prefixCls, "-checkbox"), token), _defineProperty({}, "&".concat(antCls, "-select-dropdown"), {
    padding: 0
  }), _defineProperty({}, componentCls, {
    // ================== Checkbox ==================
    '&-checkbox': {
      top: 0,
      marginInlineEnd: token.paddingXS
    },
    // ==================== Menu ====================
    // >>> Menus
    '&-menus': _defineProperty({
      display: 'flex',
      flexWrap: 'nowrap',
      alignItems: 'flex-start'
    }, "&".concat(componentCls, "-menu-empty"), _defineProperty({}, "".concat(componentCls, "-menu"), _defineProperty({
      width: '100%',
      height: 'auto'
    }, cascaderMenuItemCls, {
      color: token.colorTextDisabled
    }))),
    // >>> Menu
    '&-menu': {
      flexGrow: 1,
      minWidth: token.controlItemWidth,
      height: token.dropdownHeight,
      margin: 0,
      padding: token.paddingXXS,
      overflow: 'auto',
      verticalAlign: 'top',
      listStyle: 'none',
      '-ms-overflow-style': '-ms-autohiding-scrollbar',
      '&:not(:last-child)': {
        borderInlineEnd: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
      },
      '&-item': _extends(_extends({}, textEllipsis), (_extends2 = {
        display: 'flex',
        flexWrap: 'nowrap',
        alignItems: 'center',
        padding: "".concat(itemPaddingVertical, "px ").concat(token.paddingSM, "px"),
        lineHeight: token.lineHeight,
        cursor: 'pointer',
        transition: "all ".concat(token.motionDurationMid),
        borderRadius: token.borderRadiusSM,
        '&:hover': {
          background: token.controlItemBgHover
        },
        '&-disabled': _defineProperty({
          color: token.colorTextDisabled,
          cursor: 'not-allowed',
          '&:hover': {
            background: 'transparent'
          }
        }, iconCls, {
          color: token.colorTextDisabled
        })
      }, _defineProperty(_extends2, "&-active:not(".concat(cascaderMenuItemCls, "-disabled)"), _defineProperty({}, "&, &:hover", {
        fontWeight: token.fontWeightStrong,
        backgroundColor: token.controlItemBgActive
      })), _defineProperty(_extends2, '&-content', {
        flex: 'auto'
      }), _defineProperty(_extends2, iconCls, {
        marginInlineStart: token.paddingXXS,
        color: token.colorTextDescription,
        fontSize: token.fontSizeIcon
      }), _defineProperty(_extends2, '&-keyword', {
        color: token.colorHighlight
      }), _extends2))
    }
  })]), // =====================================================
  // ==                       RTL                       ==
  // =====================================================
  _defineProperty({}, "".concat(componentCls, "-dropdown-rtl"), {
    direction: 'rtl'
  }),
  // =====================================================
  // ==             Space Compact                       ==
  // =====================================================
  genCompactItemStyle(token)];
};
// ============================== Export ==============================
export default genComponentStyleHook('Cascader', function (token) {
  return [genBaseStyle(token)];
}, {
  controlWidth: 184,
  controlItemWidth: 111,
  dropdownHeight: 180
});