import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
var genBaseStyle = function genBaseStyle(token) {
  var _author, _$concat2, _componentCls;
  var componentCls = token.componentCls,
    commentBg = token.commentBg,
    commentPaddingBase = token.commentPaddingBase,
    commentNestIndent = token.commentNestIndent,
    commentFontSizeBase = token.commentFontSizeBase,
    commentFontSizeSm = token.commentFontSizeSm,
    commentAuthorNameColor = token.commentAuthorNameColor,
    commentAuthorTimeColor = token.commentAuthorTimeColor,
    commentActionColor = token.commentActionColor,
    commentActionHoverColor = token.commentActionHoverColor,
    commentActionsMarginBottom = token.commentActionsMarginBottom,
    commentActionsMarginTop = token.commentActionsMarginTop,
    commentContentDetailPMarginBottom = token.commentContentDetailPMarginBottom;
  return _defineProperty({}, componentCls, (_componentCls = {
    position: 'relative',
    backgroundColor: commentBg
  }, _defineProperty(_componentCls, "".concat(componentCls, "-inner"), {
    display: 'flex',
    padding: commentPaddingBase
  }), _defineProperty(_componentCls, "".concat(componentCls, "-avatar"), _defineProperty({
    position: 'relative',
    flexShrink: 0,
    marginRight: token.marginSM,
    cursor: 'pointer'
  }, "img", {
    width: '32px',
    height: '32px',
    borderRadius: '50%'
  })), _defineProperty(_componentCls, "".concat(componentCls, "-content"), (_$concat2 = {
    position: 'relative',
    flex: "1 1 auto",
    minWidth: "1px",
    fontSize: commentFontSizeBase,
    wordWrap: 'break-word'
  }, _defineProperty(_$concat2, "&-author", (_author = {
    display: 'flex',
    flexWrap: 'wrap',
    justifyContent: 'flex-start',
    marginBottom: token.marginXXS,
    fontSize: commentFontSizeBase
  }, _defineProperty(_author, "& > a,& > span", {
    paddingRight: token.paddingXS,
    fontSize: commentFontSizeSm,
    lineHeight: "18px"
  }), _defineProperty(_author, "&-name", _defineProperty({
    color: commentAuthorNameColor,
    fontSize: commentFontSizeBase,
    transition: "color ".concat(token.motionDurationSlow)
  }, "> *", _defineProperty({
    color: commentAuthorNameColor
  }, "&:hover", {
    color: commentAuthorNameColor
  }))), _defineProperty(_author, "&-time", {
    color: commentAuthorTimeColor,
    whiteSpace: 'nowrap',
    cursor: 'auto'
  }), _author)), _defineProperty(_$concat2, "&-detail p", {
    marginBottom: commentContentDetailPMarginBottom,
    whiteSpace: 'pre-wrap'
  }), _$concat2)), _defineProperty(_componentCls, "".concat(componentCls, "-actions"), _defineProperty({
    marginTop: commentActionsMarginTop,
    marginBottom: commentActionsMarginBottom,
    paddingLeft: 0
  }, "> li", _defineProperty({
    display: 'inline-block',
    color: commentActionColor
  }, "> span", _defineProperty({
    marginRight: '10px',
    color: commentActionColor,
    fontSize: commentFontSizeSm,
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationSlow),
    userSelect: 'none'
  }, "&:hover", {
    color: commentActionHoverColor
  })))), _defineProperty(_componentCls, "".concat(componentCls, "-nested"), {
    marginLeft: commentNestIndent
  }), _defineProperty(_componentCls, '&-rtl', {
    direction: 'rtl'
  }), _componentCls));
};
export default genComponentStyleHook('Comment', function (token) {
  var commentToken = mergeToken(token, {
    commentBg: 'inherit',
    commentPaddingBase: "".concat(token.paddingMD, "px 0"),
    commentNestIndent: "44px",
    commentFontSizeBase: token.fontSize,
    commentFontSizeSm: token.fontSizeSM,
    commentAuthorNameColor: token.colorTextTertiary,
    commentAuthorTimeColor: token.colorTextPlaceholder,
    commentActionColor: token.colorTextTertiary,
    commentActionHoverColor: token.colorTextSecondary,
    commentActionsMarginBottom: 'inherit',
    commentActionsMarginTop: token.marginSM,
    commentContentDetailPMarginBottom: 'inherit'
  });
  return [genBaseStyle(commentToken)];
});