import _extends from "@babel/runtime/helpers/esm/extends";
import { computed, h, inject } from 'vue';
import { defaultConfigProvider, configProviderKey } from '../context';
import { useInjectDisabled } from '../DisabledContext';
import { DefaultRenderEmpty } from '../renderEmpty';
import { useInjectSize } from '../SizeContext';
export default (function (name, props) {
  var sizeContext = useInjectSize();
  var disabledContext = useInjectDisabled();
  var configProvider = inject(configProviderKey, _extends(_extends({}, defaultConfigProvider), {
    renderEmpty: function renderEmpty(name) {
      return h(DefaultRenderEmpty, {
        componentName: name
      });
    }
  }));
  var prefixCls = computed(function () {
    return configProvider.getPrefixCls(name, props.prefixCls);
  });
  var direction = computed(function () {
    var _a, _b;
    return (_a = props.direction) !== null && _a !== void 0 ? _a : (_b = configProvider.direction) === null || _b === void 0 ? void 0 : _b.value;
  });
  var iconPrefixCls = computed(function () {
    var _a;
    return (_a = props.iconPrefixCls) !== null && _a !== void 0 ? _a : configProvider.iconPrefixCls.value;
  });
  var rootPrefixCls = computed(function () {
    return configProvider.getPrefixCls();
  });
  var autoInsertSpaceInButton = computed(function () {
    var _a;
    return (_a = configProvider.autoInsertSpaceInButton) === null || _a === void 0 ? void 0 : _a.value;
  });
  var renderEmpty = configProvider.renderEmpty;
  var space = configProvider.space;
  var pageHeader = configProvider.pageHeader;
  var form = configProvider.form;
  var getTargetContainer = configProvider.getTargetContainer;
  var getPopupContainer = configProvider.getPopupContainer;
  var dropdownMatchSelectWidth = computed(function () {
    var _a, _b;
    return (_a = props.dropdownMatchSelectWidth) !== null && _a !== void 0 ? _a : (_b = configProvider.dropdownMatchSelectWidth) === null || _b === void 0 ? void 0 : _b.value;
  });
  var virtual = computed(function () {
    var _a;
    return (props.virtual === undefined ? ((_a = configProvider.virtual) === null || _a === void 0 ? void 0 : _a.value) !== false : props.virtual !== false) && dropdownMatchSelectWidth.value !== false;
  });
  var size = computed(function () {
    return props.size || sizeContext.value;
  });
  var autocomplete = computed(function () {
    var _a, _b, _c;
    return (_a = props.autocomplete) !== null && _a !== void 0 ? _a : (_c = (_b = configProvider.input) === null || _b === void 0 ? void 0 : _b.value) === null || _c === void 0 ? void 0 : _c.autocomplete;
  });
  var disabled = computed(function () {
    var _a;
    return (_a = props.disabled) !== null && _a !== void 0 ? _a : disabledContext.value;
  });
  var csp = computed(function () {
    var _a;
    return (_a = props.csp) !== null && _a !== void 0 ? _a : configProvider.csp;
  });
  return {
    configProvider: configProvider,
    prefixCls: prefixCls,
    direction: direction,
    size: size,
    getTargetContainer: getTargetContainer,
    getPopupContainer: getPopupContainer,
    space: space,
    pageHeader: pageHeader,
    form: form,
    autoInsertSpaceInButton: autoInsertSpaceInButton,
    renderEmpty: renderEmpty,
    virtual: virtual,
    dropdownMatchSelectWidth: dropdownMatchSelectWidth,
    rootPrefixCls: rootPrefixCls,
    getPrefixCls: configProvider.getPrefixCls,
    autocomplete: autocomplete,
    csp: csp,
    iconPrefixCls: iconPrefixCls,
    disabled: disabled,
    select: configProvider.select
  };
});