import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { getArrowOffset } from '../../style/placementArrow';
import { initMoveMotion, initSlideMotion, initZoomMotion, slideDownIn, slideDownOut, slideUpIn, slideUpOut } from '../../style/motion';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import genButtonStyle from './button';
import genStatusStyle from './status';
import { genFocusStyle, resetComponent, roundedArrow } from '../../style';
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _$concat, _extends2, _extends5, _ref2;
  var componentCls = token.componentCls,
    menuCls = token.menuCls,
    zIndexPopup = token.zIndexPopup,
    dropdownArrowDistance = token.dropdownArrowDistance,
    dropdownArrowOffset = token.dropdownArrowOffset,
    sizePopupArrow = token.sizePopupArrow,
    antCls = token.antCls,
    iconCls = token.iconCls,
    motionDurationMid = token.motionDurationMid,
    dropdownPaddingVertical = token.dropdownPaddingVertical,
    fontSize = token.fontSize,
    dropdownEdgeChildPadding = token.dropdownEdgeChildPadding,
    colorTextDisabled = token.colorTextDisabled,
    fontSizeIcon = token.fontSizeIcon,
    controlPaddingHorizontal = token.controlPaddingHorizontal,
    colorBgElevated = token.colorBgElevated,
    boxShadowPopoverArrow = token.boxShadowPopoverArrow;
  return [_defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    position: 'absolute',
    top: -9999,
    left: {
      _skip_check_: true,
      value: -9999
    },
    zIndex: zIndexPopup,
    display: 'block',
    // A placeholder out of dropdown visible range to avoid close when user moving
    '&::before': {
      position: 'absolute',
      insetBlock: -dropdownArrowDistance + sizePopupArrow / 2,
      // insetInlineStart: -7, // FIXME: Seems not work for hidden element
      zIndex: -9999,
      opacity: 0.0001,
      content: '""'
    }
  }, _defineProperty(_extends2, "".concat(componentCls, "-wrap"), (_$concat = {
    position: 'relative'
  }, _defineProperty(_$concat, "".concat(antCls, "-btn > ").concat(iconCls, "-down"), {
    fontSize: fontSizeIcon
  }), _defineProperty(_$concat, "".concat(iconCls, "-down::before"), {
    transition: "transform ".concat(motionDurationMid)
  }), _$concat)), _defineProperty(_extends2, "".concat(componentCls, "-wrap-open"), _defineProperty({}, "".concat(iconCls, "-down::before"), {
    transform: "rotate(180deg)"
  })), _defineProperty(_extends2, "\n        &-hidden,\n        &-menu-hidden,\n        &-menu-submenu-hidden\n      ", {
    display: 'none'
  }), _defineProperty(_extends2, "\n        &-show-arrow".concat(componentCls, "-placement-topLeft,\n        &-show-arrow").concat(componentCls, "-placement-top,\n        &-show-arrow").concat(componentCls, "-placement-topRight\n      "), {
    paddingBottom: dropdownArrowDistance
  }), _defineProperty(_extends2, "\n        &-show-arrow".concat(componentCls, "-placement-bottomLeft,\n        &-show-arrow").concat(componentCls, "-placement-bottom,\n        &-show-arrow").concat(componentCls, "-placement-bottomRight\n      "), {
    paddingTop: dropdownArrowDistance
  }), _defineProperty(_extends2, "".concat(componentCls, "-arrow"), _extends({
    position: 'absolute',
    zIndex: 1,
    display: 'block'
  }, roundedArrow(sizePopupArrow, token.borderRadiusXS, token.borderRadiusOuter, colorBgElevated, boxShadowPopoverArrow))), _defineProperty(_extends2, "\n        &-placement-top > ".concat(componentCls, "-arrow,\n        &-placement-topLeft > ").concat(componentCls, "-arrow,\n        &-placement-topRight > ").concat(componentCls, "-arrow\n      "), {
    bottom: dropdownArrowDistance,
    transform: 'translateY(100%) rotate(180deg)'
  }), _defineProperty(_extends2, "&-placement-top > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: '50%'
    },
    transform: 'translateX(-50%) translateY(100%) rotate(180deg)'
  }), _defineProperty(_extends2, "&-placement-topLeft > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), _defineProperty(_extends2, "&-placement-topRight > ".concat(componentCls, "-arrow"), {
    right: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), _defineProperty(_extends2, "\n          &-placement-bottom > ".concat(componentCls, "-arrow,\n          &-placement-bottomLeft > ").concat(componentCls, "-arrow,\n          &-placement-bottomRight > ").concat(componentCls, "-arrow\n        "), {
    top: dropdownArrowDistance,
    transform: "translateY(-100%)"
  }), _defineProperty(_extends2, "&-placement-bottom > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: '50%'
    },
    transform: "translateY(-100%) translateX(-50%)"
  }), _defineProperty(_extends2, "&-placement-bottomLeft > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), _defineProperty(_extends2, "&-placement-bottomRight > ".concat(componentCls, "-arrow"), {
    right: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), _defineProperty(_extends2, "&".concat(antCls, "-slide-down-enter").concat(antCls, "-slide-down-enter-active").concat(componentCls, "-placement-bottomLeft,\n          &").concat(antCls, "-slide-down-appear").concat(antCls, "-slide-down-appear-active").concat(componentCls, "-placement-bottomLeft,\n          &").concat(antCls, "-slide-down-enter").concat(antCls, "-slide-down-enter-active").concat(componentCls, "-placement-bottom,\n          &").concat(antCls, "-slide-down-appear").concat(antCls, "-slide-down-appear-active").concat(componentCls, "-placement-bottom,\n          &").concat(antCls, "-slide-down-enter").concat(antCls, "-slide-down-enter-active").concat(componentCls, "-placement-bottomRight,\n          &").concat(antCls, "-slide-down-appear").concat(antCls, "-slide-down-appear-active").concat(componentCls, "-placement-bottomRight"), {
    animationName: slideUpIn
  }), _defineProperty(_extends2, "&".concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-placement-topLeft,\n          &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-placement-topLeft,\n          &").concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-placement-top,\n          &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-placement-top,\n          &").concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-placement-topRight,\n          &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-placement-topRight"), {
    animationName: slideDownIn
  }), _defineProperty(_extends2, "&".concat(antCls, "-slide-down-leave").concat(antCls, "-slide-down-leave-active").concat(componentCls, "-placement-bottomLeft,\n          &").concat(antCls, "-slide-down-leave").concat(antCls, "-slide-down-leave-active").concat(componentCls, "-placement-bottom,\n          &").concat(antCls, "-slide-down-leave").concat(antCls, "-slide-down-leave-active").concat(componentCls, "-placement-bottomRight"), {
    animationName: slideUpOut
  }), _defineProperty(_extends2, "&".concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-placement-topLeft,\n          &").concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-placement-top,\n          &").concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-placement-topRight"), {
    animationName: slideDownOut
  }), _extends2))), (_ref2 = {}, _defineProperty(_ref2, "".concat(componentCls, " ").concat(menuCls), {
    position: 'relative',
    margin: 0
  }), _defineProperty(_ref2, "".concat(menuCls, "-submenu-popup"), {
    position: 'absolute',
    zIndex: zIndexPopup,
    background: 'transparent',
    boxShadow: 'none',
    transformOrigin: '0 0',
    'ul,li': {
      listStyle: 'none'
    },
    ul: {
      marginInline: '0.3em'
    }
  }), _defineProperty(_ref2, "".concat(componentCls, ", ").concat(componentCls, "-menu-submenu"), _defineProperty({}, menuCls, _extends(_extends({
    padding: dropdownEdgeChildPadding,
    listStyleType: 'none',
    backgroundColor: colorBgElevated,
    backgroundClip: 'padding-box',
    borderRadius: token.borderRadiusLG,
    outline: 'none',
    boxShadow: token.boxShadowSecondary
  }, genFocusStyle(token)), (_extends5 = {}, _defineProperty(_extends5, "".concat(menuCls, "-item-group-title"), {
    padding: "".concat(dropdownPaddingVertical, "px ").concat(controlPaddingHorizontal, "px"),
    color: token.colorTextDescription,
    transition: "all ".concat(motionDurationMid)
  }), _defineProperty(_extends5, "".concat(menuCls, "-item"), {
    position: 'relative',
    display: 'flex',
    alignItems: 'center',
    borderRadius: token.borderRadiusSM
  }), _defineProperty(_extends5, "".concat(menuCls, "-item-icon"), {
    minWidth: fontSize,
    marginInlineEnd: token.marginXS,
    fontSize: token.fontSizeSM
  }), _defineProperty(_extends5, "".concat(menuCls, "-title-content"), {
    flex: 'auto',
    '> a': {
      color: 'inherit',
      transition: "all ".concat(motionDurationMid),
      '&:hover': {
        color: 'inherit'
      },
      '&::after': {
        position: 'absolute',
        inset: 0,
        content: '""'
      }
    }
  }), _defineProperty(_extends5, "".concat(menuCls, "-item, ").concat(menuCls, "-submenu-title"), _extends(_extends(_defineProperty({
    clear: 'both',
    margin: 0,
    padding: "".concat(dropdownPaddingVertical, "px ").concat(controlPaddingHorizontal, "px"),
    color: token.colorText,
    fontWeight: 'normal',
    fontSize: fontSize,
    lineHeight: token.lineHeight,
    cursor: 'pointer',
    transition: "all ".concat(motionDurationMid)
  }, "&:hover, &-active", {
    backgroundColor: token.controlItemBgHover
  }), genFocusStyle(token)), _defineProperty({
    '&-selected': {
      color: token.colorPrimary,
      backgroundColor: token.controlItemBgActive,
      '&:hover, &-active': {
        backgroundColor: token.controlItemBgActiveHover
      }
    },
    '&-disabled': {
      color: colorTextDisabled,
      cursor: 'not-allowed',
      '&:hover': {
        color: colorTextDisabled,
        backgroundColor: colorBgElevated,
        cursor: 'not-allowed'
      },
      a: {
        pointerEvents: 'none'
      }
    },
    '&-divider': {
      height: 1,
      margin: "".concat(token.marginXXS, "px 0"),
      overflow: 'hidden',
      lineHeight: 0,
      backgroundColor: token.colorSplit
    }
  }, "".concat(componentCls, "-menu-submenu-expand-icon"), _defineProperty({
    position: 'absolute',
    insetInlineEnd: token.paddingXS
  }, "".concat(componentCls, "-menu-submenu-arrow-icon"), {
    marginInlineEnd: '0 !important',
    color: token.colorTextDescription,
    fontSize: fontSizeIcon,
    fontStyle: 'normal'
  })))), _defineProperty(_extends5, "".concat(menuCls, "-item-group-list"), {
    margin: "0 ".concat(token.marginXS, "px"),
    padding: 0,
    listStyle: 'none'
  }), _defineProperty(_extends5, "".concat(menuCls, "-submenu-title"), {
    paddingInlineEnd: controlPaddingHorizontal + token.fontSizeSM
  }), _defineProperty(_extends5, "".concat(menuCls, "-submenu-vertical"), {
    position: 'relative'
  }), _defineProperty(_extends5, "".concat(menuCls, "-submenu").concat(menuCls, "-submenu-disabled ").concat(componentCls, "-menu-submenu-title"), _defineProperty({}, "&, ".concat(componentCls, "-menu-submenu-arrow-icon"), {
    color: colorTextDisabled,
    backgroundColor: colorBgElevated,
    cursor: 'not-allowed'
  })), _defineProperty(_extends5, "".concat(menuCls, "-submenu-selected ").concat(componentCls, "-menu-submenu-title"), {
    color: token.colorPrimary
  }), _extends5)))), _ref2),
  // Follow code may reuse in other components
  [initSlideMotion(token, 'slide-up'), initSlideMotion(token, 'slide-down'), initMoveMotion(token, 'move-up'), initMoveMotion(token, 'move-down'), initZoomMotion(token, 'zoom-big')]];
};
// ============================== Export ==============================
export default genComponentStyleHook('Dropdown', function (token, _ref3) {
  var rootPrefixCls = _ref3.rootPrefixCls;
  var marginXXS = token.marginXXS,
    sizePopupArrow = token.sizePopupArrow,
    controlHeight = token.controlHeight,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    paddingXXS = token.paddingXXS,
    componentCls = token.componentCls,
    borderRadiusOuter = token.borderRadiusOuter,
    borderRadiusLG = token.borderRadiusLG;
  var dropdownPaddingVertical = (controlHeight - fontSize * lineHeight) / 2;
  var _getArrowOffset = getArrowOffset({
      sizePopupArrow: sizePopupArrow,
      contentRadius: borderRadiusLG,
      borderRadiusOuter: borderRadiusOuter
    }),
    dropdownArrowOffset = _getArrowOffset.dropdownArrowOffset;
  var dropdownToken = mergeToken(token, {
    menuCls: "".concat(componentCls, "-menu"),
    rootPrefixCls: rootPrefixCls,
    dropdownArrowDistance: sizePopupArrow / 2 + marginXXS,
    dropdownArrowOffset: dropdownArrowOffset,
    dropdownPaddingVertical: dropdownPaddingVertical,
    dropdownEdgeChildPadding: paddingXXS
  });
  return [genBaseStyle(dropdownToken), genButtonStyle(dropdownToken), genStatusStyle(dropdownToken)];
}, function (token) {
  return {
    zIndexPopup: token.zIndexPopupBase + 50
  };
});