import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode, resolveDirective as _resolveDirective } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import classNames from '../_util/classNames';
import { defineComponent, computed, ref } from 'vue';
import Tooltip from '../tooltip';
import Content from './FloatButtonContent';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { useInjectFloatButtonGroupContext } from './context';
import warning from '../_util/warning';
import { initDefaultProps } from '../_util/props-util';
import { floatButtonProps } from './interface';
// import { useCompactItemContext } from '../space/Compact';
// CSSINJS
import useStyle from './style';
export var floatButtonPrefixCls = 'float-btn';
var FloatButton = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AFloatButton',
  inheritAttrs: false,
  props: initDefaultProps(floatButtonProps(), {
    type: 'default',
    shape: 'circle'
  }),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    var _useConfigInject = useConfigInject(floatButtonPrefixCls, props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var _useInjectFloatButton = useInjectFloatButtonGroupContext(),
      groupShape = _useInjectFloatButton.shape;
    var floatButtonRef = ref(null);
    var mergeShape = computed(function () {
      return (groupShape === null || groupShape === void 0 ? void 0 : groupShape.value) || props.shape;
    });
    return function () {
      var _a;
      var customPrefixCls = props.prefixCls,
        _props$type = props.type,
        type = _props$type === void 0 ? 'default' : _props$type,
        _props$shape = props.shape,
        shape = _props$shape === void 0 ? 'circle' : _props$shape,
        _props$description = props.description,
        _description = _props$description === void 0 ? (_a = slots.description) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$description,
        tooltip = props.tooltip,
        restProps = __rest(props, ["prefixCls", "type", "shape", "description", "tooltip"]);
      var classString = classNames(prefixCls.value, "".concat(prefixCls.value, "-").concat(type), "".concat(prefixCls.value, "-").concat(mergeShape.value), _defineProperty({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), attrs.class, hashId.value);
      var buttonNode = _createVNode(Tooltip, {
        "placement": "left"
      }, {
        title: slots.tooltip || tooltip ? function () {
          return slots.tooltip && slots.tooltip() || tooltip;
        } : undefined,
        default: function _default() {
          return _createVNode("div", {
            "class": "".concat(prefixCls.value, "-body")
          }, [_createVNode(Content, {
            "prefixCls": prefixCls.value
          }, {
            icon: slots.icon,
            description: function description() {
              return _description;
            }
          })]);
        }
      });
      if (process.env.NODE_ENV !== 'production') {
        warning(!(shape === 'circle' && _description), 'FloatButton', 'supported only when `shape` is `square`. Due to narrow space for text, short sentence is recommended.');
      }
      return wrapSSR(props.href ? _createVNode("a", _objectSpread(_objectSpread(_objectSpread({
        "ref": floatButtonRef
      }, attrs), restProps), {}, {
        "class": classString
      }), [buttonNode]) : _createVNode("button", _objectSpread(_objectSpread(_objectSpread({
        "ref": floatButtonRef
      }, attrs), restProps), {}, {
        "class": classString,
        "type": "button"
      }), [buttonNode]));
    };
  }
});
export default FloatButton;