import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { Keyframes } from '../../_util/cssinjs';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { initFadeMotion } from '../../style/motion/fade';
import { resetComponent } from '../../style';
import { initMotion } from '../../style/motion/motion';
var initFloatButtonGroupMotion = function initFloatButtonGroupMotion(token) {
  var _$concat;
  var componentCls = token.componentCls,
    floatButtonSize = token.floatButtonSize,
    motionDurationSlow = token.motionDurationSlow,
    motionEaseInOutCirc = token.motionEaseInOutCirc;
  var groupPrefixCls = "".concat(componentCls, "-group");
  var moveDownIn = new Keyframes('antFloatButtonMoveDownIn', {
    '0%': {
      transform: "translate3d(0, ".concat(floatButtonSize, "px, 0)"),
      transformOrigin: '0 0',
      opacity: 0
    },
    '100%': {
      transform: 'translate3d(0, 0, 0)',
      transformOrigin: '0 0',
      opacity: 1
    }
  });
  var moveDownOut = new Keyframes('antFloatButtonMoveDownOut', {
    '0%': {
      transform: 'translate3d(0, 0, 0)',
      transformOrigin: '0 0',
      opacity: 1
    },
    '100%': {
      transform: "translate3d(0, ".concat(floatButtonSize, "px, 0)"),
      transformOrigin: '0 0',
      opacity: 0
    }
  });
  return [_defineProperty({}, "".concat(groupPrefixCls, "-wrap"), _extends({}, initMotion("".concat(groupPrefixCls, "-wrap"), moveDownIn, moveDownOut, motionDurationSlow, true))), _defineProperty({}, "".concat(groupPrefixCls, "-wrap"), (_$concat = {}, _defineProperty(_$concat, "\n          &".concat(groupPrefixCls, "-wrap-enter,\n          &").concat(groupPrefixCls, "-wrap-appear\n        "), {
    opacity: 0,
    animationTimingFunction: motionEaseInOutCirc
  }), _defineProperty(_$concat, "&".concat(groupPrefixCls, "-wrap-leave"), {
    animationTimingFunction: motionEaseInOutCirc
  }), _$concat))];
};
// ============================== Group ==============================
var floatButtonGroupStyle = function floatButtonGroupStyle(token) {
  var _extends2, _$concat6, _ref3;
  var componentCls = token.componentCls,
    floatButtonSize = token.floatButtonSize,
    margin = token.margin,
    borderRadiusLG = token.borderRadiusLG;
  var groupPrefixCls = "".concat(componentCls, "-group");
  return _ref3 = {}, _defineProperty(_ref3, groupPrefixCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    zIndex: 99,
    display: 'block',
    border: 'none',
    position: 'fixed',
    width: floatButtonSize,
    height: 'auto',
    boxShadow: 'none',
    minHeight: floatButtonSize,
    insetInlineEnd: token.floatButtonInsetInlineEnd,
    insetBlockEnd: token.floatButtonInsetBlockEnd,
    borderRadius: borderRadiusLG
  }, _defineProperty(_extends2, "".concat(groupPrefixCls, "-wrap"), {
    zIndex: -1,
    display: 'block',
    position: 'relative',
    marginBottom: margin
  }), _defineProperty(_extends2, "&".concat(groupPrefixCls, "-rtl"), {
    direction: 'rtl'
  }), _defineProperty(_extends2, componentCls, {
    position: 'static'
  }), _extends2))), _defineProperty(_ref3, "".concat(groupPrefixCls, "-circle"), _defineProperty({}, "".concat(componentCls, "-circle:not(:last-child)"), _defineProperty({
    marginBottom: token.margin
  }, "".concat(componentCls, "-body"), {
    width: floatButtonSize,
    height: floatButtonSize
  }))), _defineProperty(_ref3, "".concat(groupPrefixCls, "-square"), (_$concat6 = {}, _defineProperty(_$concat6, "".concat(componentCls, "-square"), {
    borderRadius: 0,
    padding: 0,
    '&:first-child': {
      borderStartStartRadius: borderRadiusLG,
      borderStartEndRadius: borderRadiusLG
    },
    '&:last-child': {
      borderEndStartRadius: borderRadiusLG,
      borderEndEndRadius: borderRadiusLG
    },
    '&:not(:last-child)': {
      borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
    }
  }), _defineProperty(_$concat6, "".concat(groupPrefixCls, "-wrap"), _defineProperty({
    display: 'block',
    borderRadius: borderRadiusLG,
    boxShadow: token.boxShadowSecondary,
    overflow: 'hidden'
  }, "".concat(componentCls, "-square"), _defineProperty({
    boxShadow: 'none',
    marginTop: 0,
    borderRadius: 0,
    padding: token.paddingXXS,
    '&:first-child': {
      borderStartStartRadius: borderRadiusLG,
      borderStartEndRadius: borderRadiusLG
    },
    '&:last-child': {
      borderEndStartRadius: borderRadiusLG,
      borderEndEndRadius: borderRadiusLG
    },
    '&:not(:last-child)': {
      borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
    }
  }, "".concat(componentCls, "-body"), {
    width: floatButtonSize - token.paddingXXS * 2,
    height: floatButtonSize - token.paddingXXS * 2
  }))), _$concat6)), _defineProperty(_ref3, "".concat(groupPrefixCls, "-circle-shadow"), {
    boxShadow: 'none'
  }), _defineProperty(_ref3, "".concat(groupPrefixCls, "-square-shadow"), _defineProperty({
    boxShadow: token.boxShadowSecondary
  }, "".concat(componentCls, "-square"), _defineProperty({
    boxShadow: 'none',
    padding: token.paddingXXS
  }, "".concat(componentCls, "-body"), {
    width: floatButtonSize - token.paddingXXS * 2,
    height: floatButtonSize - token.paddingXXS * 2
  }))), _ref3;
};
// ============================== Shared ==============================
var sharedFloatButtonStyle = function sharedFloatButtonStyle(token) {
  var _$concat13, _$concat16, _ref4;
  var componentCls = token.componentCls,
    floatButtonIconSize = token.floatButtonIconSize,
    floatButtonSize = token.floatButtonSize,
    borderRadiusLG = token.borderRadiusLG;
  return _ref4 = {}, _defineProperty(_ref4, componentCls, _extends(_extends({}, resetComponent(token)), _defineProperty({
    border: 'none',
    position: 'fixed',
    cursor: 'pointer',
    overflow: 'hidden',
    zIndex: 99,
    display: 'block',
    justifyContent: 'center',
    alignItems: 'center',
    width: floatButtonSize,
    height: floatButtonSize,
    insetInlineEnd: token.floatButtonInsetInlineEnd,
    insetBlockEnd: token.floatButtonInsetBlockEnd,
    boxShadow: token.boxShadowSecondary,
    // Pure Panel
    '&-pure': {
      position: 'relative',
      inset: 'auto'
    },
    '&:empty': {
      display: 'none'
    }
  }, "".concat(componentCls, "-body"), _defineProperty({
    width: '100%',
    height: '100%',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    transition: "all ".concat(token.motionDurationMid)
  }, "".concat(componentCls, "-content"), _defineProperty({
    overflow: 'hidden',
    textAlign: 'center',
    minHeight: floatButtonSize,
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    padding: "2px 4px"
  }, "".concat(componentCls, "-icon"), {
    textAlign: 'center',
    margin: 'auto',
    width: floatButtonIconSize,
    fontSize: floatButtonIconSize,
    lineHeight: 1
  }))))), _defineProperty(_ref4, "".concat(componentCls, "-circle"), _defineProperty({
    height: floatButtonSize,
    borderRadius: '50%'
  }, "".concat(componentCls, "-body"), {
    borderRadius: '50%'
  })), _defineProperty(_ref4, "".concat(componentCls, "-square"), _defineProperty({
    height: 'auto',
    minHeight: floatButtonSize,
    borderRadius: borderRadiusLG
  }, "".concat(componentCls, "-body"), {
    height: 'auto',
    borderRadius: token.borderRadiusSM
  })), _defineProperty(_ref4, "".concat(componentCls, "-default"), _defineProperty({
    backgroundColor: token.floatButtonBackgroundColor,
    transition: "background-color ".concat(token.motionDurationMid)
  }, "".concat(componentCls, "-body"), _defineProperty({
    backgroundColor: token.floatButtonBackgroundColor,
    transition: "background-color ".concat(token.motionDurationMid),
    '&:hover': {
      backgroundColor: token.colorFillContent
    }
  }, "".concat(componentCls, "-content"), (_$concat13 = {}, _defineProperty(_$concat13, "".concat(componentCls, "-icon"), {
    color: token.colorText
  }), _defineProperty(_$concat13, "".concat(componentCls, "-description"), {
    display: 'flex',
    alignItems: 'center',
    lineHeight: "".concat(token.fontSizeLG, "px"),
    color: token.colorText,
    fontSize: token.fontSizeSM
  }), _$concat13)))), _defineProperty(_ref4, "".concat(componentCls, "-primary"), _defineProperty({
    backgroundColor: token.colorPrimary
  }, "".concat(componentCls, "-body"), _defineProperty({
    backgroundColor: token.colorPrimary,
    transition: "background-color ".concat(token.motionDurationMid),
    '&:hover': {
      backgroundColor: token.colorPrimaryHover
    }
  }, "".concat(componentCls, "-content"), (_$concat16 = {}, _defineProperty(_$concat16, "".concat(componentCls, "-icon"), {
    color: token.colorTextLightSolid
  }), _defineProperty(_$concat16, "".concat(componentCls, "-description"), {
    display: 'flex',
    alignItems: 'center',
    lineHeight: "".concat(token.fontSizeLG, "px"),
    color: token.colorTextLightSolid,
    fontSize: token.fontSizeSM
  }), _$concat16)))), _ref4;
};
// ============================== Export ==============================
export default genComponentStyleHook('FloatButton', function (token) {
  var colorTextLightSolid = token.colorTextLightSolid,
    colorBgElevated = token.colorBgElevated,
    controlHeightLG = token.controlHeightLG,
    marginXXL = token.marginXXL,
    marginLG = token.marginLG,
    fontSize = token.fontSize,
    fontSizeIcon = token.fontSizeIcon,
    controlItemBgHover = token.controlItemBgHover;
  var floatButtonToken = mergeToken(token, {
    floatButtonBackgroundColor: colorBgElevated,
    floatButtonColor: colorTextLightSolid,
    floatButtonHoverBackgroundColor: controlItemBgHover,
    floatButtonFontSize: fontSize,
    floatButtonIconSize: fontSizeIcon * 1.5,
    floatButtonSize: controlHeightLG,
    floatButtonInsetBlockEnd: marginXXL,
    floatButtonInsetInlineEnd: marginLG
  });
  return [floatButtonGroupStyle(floatButtonToken), sharedFloatButtonStyle(floatButtonToken), initFadeMotion(token), initFloatButtonGroupMotion(floatButtonToken)];
});