import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { defineComponent, ref, onMounted, onBeforeUnmount, computed } from 'vue';
import classNames from '../_util/classNames';
import useResponsiveObserve, { responsiveArray } from '../_util/responsiveObserve';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useFlexGapSupport from '../_util/hooks/useFlexGapSupport';
import useProvideRow from './context';
import { useRowStyle } from './style';
import { someType } from '../_util/type';
var RowAligns = ['top', 'middle', 'bottom', 'stretch'];
var RowJustify = ['start', 'end', 'center', 'space-around', 'space-between', 'space-evenly'];
export var rowProps = function rowProps() {
  return {
    align: someType([String, Object]),
    justify: someType([String, Object]),
    prefixCls: String,
    gutter: someType([Number, Array, Object], 0),
    wrap: {
      type: Boolean,
      default: undefined
    }
  };
};
var ARow = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ARow',
  inheritAttrs: false,
  props: rowProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('row', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useRowStyle = useRowStyle(prefixCls),
      _useRowStyle2 = _slicedToArray(_useRowStyle, 2),
      wrapSSR = _useRowStyle2[0],
      hashId = _useRowStyle2[1];
    var token;
    var responsiveObserve = useResponsiveObserve();
    var screens = ref({
      xs: true,
      sm: true,
      md: true,
      lg: true,
      xl: true,
      xxl: true,
      xxxl: true
    });
    var curScreens = ref({
      xs: false,
      sm: false,
      md: false,
      lg: false,
      xl: false,
      xxl: false,
      xxxl: false
    });
    var mergePropsByScreen = function mergePropsByScreen(oriProp) {
      return computed(function () {
        if (typeof props[oriProp] === 'string') {
          return props[oriProp];
        }
        if (_typeof(props[oriProp]) !== 'object') {
          return '';
        }
        for (var i = 0; i < responsiveArray.length; i++) {
          var breakpoint = responsiveArray[i];
          // if do not match, do nothing
          if (!curScreens.value[breakpoint]) continue;
          var curVal = props[oriProp][breakpoint];
          if (curVal !== undefined) {
            return curVal;
          }
        }
        return '';
      });
    };
    var mergeAlign = mergePropsByScreen('align');
    var mergeJustify = mergePropsByScreen('justify');
    var supportFlexGap = useFlexGapSupport();
    onMounted(function () {
      token = responsiveObserve.value.subscribe(function (screen) {
        curScreens.value = screen;
        var currentGutter = props.gutter || 0;
        if (!Array.isArray(currentGutter) && _typeof(currentGutter) === 'object' || Array.isArray(currentGutter) && (_typeof(currentGutter[0]) === 'object' || _typeof(currentGutter[1]) === 'object')) {
          screens.value = screen;
        }
      });
    });
    onBeforeUnmount(function () {
      responsiveObserve.value.unsubscribe(token);
    });
    var gutter = computed(function () {
      var results = [undefined, undefined];
      var _props$gutter = props.gutter,
        gutter = _props$gutter === void 0 ? 0 : _props$gutter;
      var normalizedGutter = Array.isArray(gutter) ? gutter : [gutter, undefined];
      normalizedGutter.forEach(function (g, index) {
        if (_typeof(g) === 'object') {
          for (var i = 0; i < responsiveArray.length; i++) {
            var breakpoint = responsiveArray[i];
            if (screens.value[breakpoint] && g[breakpoint] !== undefined) {
              results[index] = g[breakpoint];
              break;
            }
          }
        } else {
          results[index] = g;
        }
      });
      return results;
    });
    useProvideRow({
      gutter: gutter,
      supportFlexGap: supportFlexGap,
      wrap: computed(function () {
        return props.wrap;
      })
    });
    var classes = computed(function () {
      var _classNames;
      return classNames(prefixCls.value, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-no-wrap"), props.wrap === false), _defineProperty(_classNames, "".concat(prefixCls.value, "-").concat(mergeJustify.value), mergeJustify.value), _defineProperty(_classNames, "".concat(prefixCls.value, "-").concat(mergeAlign.value), mergeAlign.value), _defineProperty(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _classNames), attrs.class, hashId.value);
    });
    var rowStyle = computed(function () {
      var gt = gutter.value;
      // Add gutter related style
      var style = {};
      var horizontalGutter = gt[0] != null && gt[0] > 0 ? "".concat(gt[0] / -2, "px") : undefined;
      var verticalGutter = gt[1] != null && gt[1] > 0 ? "".concat(gt[1] / -2, "px") : undefined;
      if (horizontalGutter) {
        style.marginLeft = horizontalGutter;
        style.marginRight = horizontalGutter;
      }
      if (supportFlexGap.value) {
        // Set gap direct if flex gap support
        style.rowGap = "".concat(gt[1], "px");
      } else if (verticalGutter) {
        style.marginTop = verticalGutter;
        style.marginBottom = verticalGutter;
      }
      return style;
    });
    return function () {
      var _a;
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": classes.value,
        "style": _extends(_extends({}, rowStyle.value), attrs.style)
      }), [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]));
    };
  }
});
export default ARow;