import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { createVNode as _createVNode } from "vue";
import classNames from '../_util/classNames';
import CloseCircleFilled from "@ant-design/icons-vue/es/icons/CloseCircleFilled";
import PropTypes from '../_util/vue-types';
import { cloneElement } from '../_util/vnode';
import { defineComponent } from 'vue';
import { anyType, tuple } from '../_util/type';
import { hasAddon } from './util';
import { FormItemInputContext } from '../form/FormItemContext';
import { getMergedStatus, getStatusClassNames } from '../_util/statusUtils';
var ClearableInputType = ['text', 'input'];
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ClearableLabeledInput',
  inheritAttrs: false,
  props: {
    prefixCls: String,
    inputType: PropTypes.oneOf(tuple('text', 'input')),
    value: anyType(),
    defaultValue: anyType(),
    allowClear: {
      type: Boolean,
      default: undefined
    },
    element: anyType(),
    handleReset: Function,
    disabled: {
      type: Boolean,
      default: undefined
    },
    direction: {
      type: String
    },
    size: {
      type: String
    },
    suffix: anyType(),
    prefix: anyType(),
    addonBefore: anyType(),
    addonAfter: anyType(),
    readonly: {
      type: Boolean,
      default: undefined
    },
    focused: {
      type: Boolean,
      default: undefined
    },
    bordered: {
      type: Boolean,
      default: true
    },
    triggerFocus: {
      type: Function
    },
    hidden: Boolean,
    status: String,
    hashId: String
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var statusContext = FormItemInputContext.useInject();
    var renderClearIcon = function renderClearIcon(prefixCls) {
      var _classNames;
      var value = props.value,
        disabled = props.disabled,
        readonly = props.readonly,
        handleReset = props.handleReset,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? slots.suffix : _props$suffix;
      var needClear = !disabled && !readonly && value;
      var className = "".concat(prefixCls, "-clear-icon");
      return _createVNode(CloseCircleFilled, {
        "onClick": handleReset,
        "onMousedown": function onMousedown(e) {
          return e.preventDefault();
        },
        "class": classNames((_classNames = {}, _defineProperty(_classNames, "".concat(className, "-hidden"), !needClear), _defineProperty(_classNames, "".concat(className, "-has-suffix"), !!suffix), _classNames), className),
        "role": "button"
      }, null);
    };
    var renderTextAreaWithClearIcon = function renderTextAreaWithClearIcon(prefixCls, element) {
      var _classNames2;
      var value = props.value,
        allowClear = props.allowClear,
        direction = props.direction,
        bordered = props.bordered,
        hidden = props.hidden,
        customStatus = props.status,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? slots.addonAfter : _props$addonAfter,
        _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? slots.addonBefore : _props$addonBefore,
        hashId = props.hashId;
      var contextStatus = statusContext.status,
        hasFeedback = statusContext.hasFeedback;
      if (!allowClear) {
        return cloneElement(element, {
          value: value
        });
      }
      var affixWrapperCls = classNames("".concat(prefixCls, "-affix-wrapper"), "".concat(prefixCls, "-affix-wrapper-textarea-with-clear-btn"), getStatusClassNames("".concat(prefixCls, "-affix-wrapper"), getMergedStatus(contextStatus, customStatus), hasFeedback), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls, "-affix-wrapper-rtl"), direction === 'rtl'), _defineProperty(_classNames2, "".concat(prefixCls, "-affix-wrapper-borderless"), !bordered), _defineProperty(_classNames2, "".concat(attrs.class), !hasAddon({
        addonAfter: addonAfter,
        addonBefore: addonBefore
      }) && attrs.class), _classNames2), hashId);
      return _createVNode("span", {
        "class": affixWrapperCls,
        "style": attrs.style,
        "hidden": hidden
      }, [cloneElement(element, {
        style: null,
        value: value
      }), renderClearIcon(prefixCls)]);
    };
    return function () {
      var _a;
      var prefixCls = props.prefixCls,
        inputType = props.inputType,
        _props$element = props.element,
        element = _props$element === void 0 ? (_a = slots.element) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$element;
      if (inputType === ClearableInputType[0]) {
        return renderTextAreaWithClearIcon(prefixCls, element);
      }
      return null;
    };
  }
});