import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { clearFix, resetComponent } from '../../style';
import { genCompactItemStyle } from '../../style/compact-item';
export var genPlaceholderStyle = function genPlaceholderStyle(color) {
  return {
    // Firefox
    '&::-moz-placeholder': {
      opacity: 1
    },
    '&::placeholder': {
      color: color,
      userSelect: 'none' // https://github.com/ant-design/ant-design/pull/32639
    },

    '&:placeholder-shown': {
      textOverflow: 'ellipsis'
    }
  };
};
export var genHoverStyle = function genHoverStyle(token) {
  return {
    borderColor: token.inputBorderHoverColor,
    borderInlineEndWidth: token.lineWidth
  };
};
export var genActiveStyle = function genActiveStyle(token) {
  return {
    borderColor: token.inputBorderHoverColor,
    boxShadow: "0 0 0 ".concat(token.controlOutlineWidth, "px ").concat(token.controlOutline),
    borderInlineEndWidth: token.lineWidth,
    outline: 0
  };
};
export var genDisabledStyle = function genDisabledStyle(token) {
  return {
    color: token.colorTextDisabled,
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder,
    boxShadow: 'none',
    cursor: 'not-allowed',
    opacity: 1,
    '&:hover': _extends({}, genHoverStyle(mergeToken(token, {
      inputBorderHoverColor: token.colorBorder
    })))
  };
};
var genInputLargeStyle = function genInputLargeStyle(token) {
  var inputPaddingVerticalLG = token.inputPaddingVerticalLG,
    fontSizeLG = token.fontSizeLG,
    lineHeightLG = token.lineHeightLG,
    borderRadiusLG = token.borderRadiusLG,
    inputPaddingHorizontalLG = token.inputPaddingHorizontalLG;
  return {
    padding: "".concat(inputPaddingVerticalLG, "px ").concat(inputPaddingHorizontalLG, "px"),
    fontSize: fontSizeLG,
    lineHeight: lineHeightLG,
    borderRadius: borderRadiusLG
  };
};
export var genInputSmallStyle = function genInputSmallStyle(token) {
  return {
    padding: "".concat(token.inputPaddingVerticalSM, "px ").concat(token.controlPaddingHorizontalSM - 1, "px"),
    borderRadius: token.borderRadiusSM
  };
};
export var genStatusStyle = function genStatusStyle(token, parentCls) {
  var _ref;
  var componentCls = token.componentCls,
    colorError = token.colorError,
    colorWarning = token.colorWarning,
    colorErrorOutline = token.colorErrorOutline,
    colorWarningOutline = token.colorWarningOutline,
    colorErrorBorderHover = token.colorErrorBorderHover,
    colorWarningBorderHover = token.colorWarningBorderHover;
  return _ref = {}, _defineProperty(_ref, "&-status-error:not(".concat(parentCls, "-disabled):not(").concat(parentCls, "-borderless)").concat(parentCls), _defineProperty({
    borderColor: colorError,
    '&:hover': {
      borderColor: colorErrorBorderHover
    },
    '&:focus, &-focused': _extends({}, genActiveStyle(mergeToken(token, {
      inputBorderActiveColor: colorError,
      inputBorderHoverColor: colorError,
      controlOutline: colorErrorOutline
    })))
  }, "".concat(componentCls, "-prefix"), {
    color: colorError
  })), _defineProperty(_ref, "&-status-warning:not(".concat(parentCls, "-disabled):not(").concat(parentCls, "-borderless)").concat(parentCls), _defineProperty({
    borderColor: colorWarning,
    '&:hover': {
      borderColor: colorWarningBorderHover
    },
    '&:focus, &-focused': _extends({}, genActiveStyle(mergeToken(token, {
      inputBorderActiveColor: colorWarning,
      inputBorderHoverColor: colorWarning,
      controlOutline: colorWarningOutline
    })))
  }, "".concat(componentCls, "-prefix"), {
    color: colorWarning
  })), _ref;
};
export var genBasicInputStyle = function genBasicInputStyle(token) {
  return _extends(_extends({
    position: 'relative',
    display: 'inline-block',
    width: '100%',
    minWidth: 0,
    padding: "".concat(token.inputPaddingVertical, "px ").concat(token.inputPaddingHorizontal, "px"),
    color: token.colorText,
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    backgroundColor: token.colorBgContainer,
    backgroundImage: 'none',
    borderWidth: token.lineWidth,
    borderStyle: token.lineType,
    borderColor: token.colorBorder,
    borderRadius: token.borderRadius,
    transition: "all ".concat(token.motionDurationMid)
  }, genPlaceholderStyle(token.colorTextPlaceholder)), {
    '&:hover': _extends({}, genHoverStyle(token)),
    '&:focus, &-focused': _extends({}, genActiveStyle(token)),
    '&-disabled, &[disabled]': _extends({}, genDisabledStyle(token)),
    '&-borderless': {
      '&, &:hover, &:focus, &-focused, &-disabled, &[disabled]': {
        backgroundColor: 'transparent',
        border: 'none',
        boxShadow: 'none'
      }
    },
    // Reset height for `textarea`s
    'textarea&': {
      maxWidth: '100%',
      height: 'auto',
      minHeight: token.controlHeight,
      lineHeight: token.lineHeight,
      verticalAlign: 'bottom',
      transition: "all ".concat(token.motionDurationSlow, ", height 0s"),
      resize: 'vertical'
    },
    // Size
    '&-lg': _extends({}, genInputLargeStyle(token)),
    '&-sm': _extends({}, genInputSmallStyle(token)),
    // RTL
    '&-rtl': {
      direction: 'rtl'
    },
    '&-textarea-rtl': {
      direction: 'rtl'
    }
  });
};
export var genInputGroupStyle = function genInputGroupStyle(token) {
  var _$concat, _addon, _$concat3, _$concat4, _$concat$concat5, _extends2, _ref2;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  return _ref2 = {
    position: 'relative',
    display: 'table',
    width: '100%',
    borderCollapse: 'separate',
    borderSpacing: 0
  }, _defineProperty(_ref2, "&[class*='col-']", {
    paddingInlineEnd: token.paddingXS,
    '&:last-child': {
      paddingInlineEnd: 0
    }
  }), _defineProperty(_ref2, "&-lg ".concat(componentCls, ", &-lg > ").concat(componentCls, "-group-addon"), _extends({}, genInputLargeStyle(token))), _defineProperty(_ref2, "&-sm ".concat(componentCls, ", &-sm > ").concat(componentCls, "-group-addon"), _extends({}, genInputSmallStyle(token))), _defineProperty(_ref2, "&-lg ".concat(antCls, "-select-single ").concat(antCls, "-select-selector"), {
    height: token.controlHeightLG
  }), _defineProperty(_ref2, "&-sm ".concat(antCls, "-select-single ").concat(antCls, "-select-selector"), {
    height: token.controlHeightSM
  }), _defineProperty(_ref2, "> ".concat(componentCls), {
    display: 'table-cell',
    '&:not(:first-child):not(:last-child)': {
      borderRadius: 0
    }
  }), _defineProperty(_ref2, "".concat(componentCls, "-group"), (_$concat3 = {}, _defineProperty(_$concat3, "&-addon, &-wrap", {
    display: 'table-cell',
    width: 1,
    whiteSpace: 'nowrap',
    verticalAlign: 'middle',
    '&:not(:first-child):not(:last-child)': {
      borderRadius: 0
    }
  }), _defineProperty(_$concat3, '&-wrap > *', {
    display: 'block !important'
  }), _defineProperty(_$concat3, '&-addon', (_addon = {
    position: 'relative',
    padding: "0 ".concat(token.inputPaddingHorizontal, "px"),
    color: token.colorText,
    fontWeight: 'normal',
    fontSize: token.fontSize,
    textAlign: 'center',
    backgroundColor: token.colorFillAlter,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    borderRadius: token.borderRadius,
    transition: "all ".concat(token.motionDurationSlow),
    lineHeight: 1
  }, _defineProperty(_addon, "".concat(antCls, "-select"), (_$concat = {
    margin: "-".concat(token.inputPaddingVertical + 1, "px -").concat(token.inputPaddingHorizontal, "px")
  }, _defineProperty(_$concat, "&".concat(antCls, "-select-single:not(").concat(antCls, "-select-customize-input)"), _defineProperty({}, "".concat(antCls, "-select-selector"), {
    backgroundColor: 'inherit',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    boxShadow: 'none'
  })), _defineProperty(_$concat, '&-open, &-focused', _defineProperty({}, "".concat(antCls, "-select-selector"), {
    color: token.colorPrimary
  })), _$concat)), _defineProperty(_addon, "".concat(antCls, "-cascader-picker"), _defineProperty({
    margin: "-9px -".concat(token.inputPaddingHorizontal, "px"),
    backgroundColor: 'transparent'
  }, "".concat(antCls, "-cascader-input"), {
    textAlign: 'start',
    border: 0,
    boxShadow: 'none'
  })), _addon)), _defineProperty(_$concat3, '&-addon:first-child', {
    borderInlineEnd: 0
  }), _defineProperty(_$concat3, '&-addon:last-child', {
    borderInlineStart: 0
  }), _$concat3)), _defineProperty(_ref2, "".concat(componentCls), {
    float: 'inline-start',
    width: '100%',
    marginBottom: 0,
    textAlign: 'inherit',
    '&:focus': {
      zIndex: 1,
      borderInlineEndWidth: 1
    },
    '&:hover': _defineProperty({
      zIndex: 1,
      borderInlineEndWidth: 1
    }, "".concat(componentCls, "-search-with-button &"), {
      zIndex: 0
    })
  }), _defineProperty(_ref2, "> ".concat(componentCls, ":first-child, ").concat(componentCls, "-group-addon:first-child"), _defineProperty({
    borderStartEndRadius: 0,
    borderEndEndRadius: 0
  }, "".concat(antCls, "-select ").concat(antCls, "-select-selector"), {
    borderStartEndRadius: 0,
    borderEndEndRadius: 0
  })), _defineProperty(_ref2, "> ".concat(componentCls, "-affix-wrapper"), (_$concat4 = {}, _defineProperty(_$concat4, "&:not(:first-child) ".concat(componentCls), {
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  }), _defineProperty(_$concat4, "&:not(:last-child) ".concat(componentCls), {
    borderStartEndRadius: 0,
    borderEndEndRadius: 0
  }), _$concat4)), _defineProperty(_ref2, "> ".concat(componentCls, ":last-child, ").concat(componentCls, "-group-addon:last-child"), _defineProperty({
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  }, "".concat(antCls, "-select ").concat(antCls, "-select-selector"), {
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  })), _defineProperty(_ref2, "".concat(componentCls, "-affix-wrapper"), _defineProperty({
    '&:not(:last-child)': _defineProperty({
      borderStartEndRadius: 0,
      borderEndEndRadius: 0
    }, "".concat(componentCls, "-search &"), {
      borderStartStartRadius: token.borderRadius,
      borderEndStartRadius: token.borderRadius
    })
  }, "&:not(:first-child), ".concat(componentCls, "-search &:not(:first-child)"), {
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  })), _defineProperty(_ref2, "&".concat(componentCls, "-group-compact"), _extends(_extends({
    display: 'block'
  }, clearFix()), (_extends2 = {}, _defineProperty(_extends2, "".concat(componentCls, "-group-addon, ").concat(componentCls, "-group-wrap, > ").concat(componentCls), {
    '&:not(:first-child):not(:last-child)': {
      borderInlineEndWidth: token.lineWidth,
      '&:hover': {
        zIndex: 1
      },
      '&:focus': {
        zIndex: 1
      }
    }
  }), _defineProperty(_extends2, '& > *', {
    display: 'inline-block',
    float: 'none',
    verticalAlign: 'top',
    borderRadius: 0
  }), _defineProperty(_extends2, "& > ".concat(componentCls, "-affix-wrapper"), {
    display: 'inline-flex'
  }), _defineProperty(_extends2, "& > ".concat(antCls, "-picker-range"), {
    display: 'inline-flex'
  }), _defineProperty(_extends2, '& > *:not(:last-child)', {
    marginInlineEnd: -token.lineWidth,
    borderInlineEndWidth: token.lineWidth
  }), _defineProperty(_extends2, "".concat(componentCls), {
    float: 'none'
  }), _defineProperty(_extends2, "& > ".concat(antCls, "-select > ").concat(antCls, "-select-selector,\n      & > ").concat(antCls, "-select-auto-complete ").concat(componentCls, ",\n      & > ").concat(antCls, "-cascader-picker ").concat(componentCls, ",\n      & > ").concat(componentCls, "-group-wrapper ").concat(componentCls), {
    borderInlineEndWidth: token.lineWidth,
    borderRadius: 0,
    '&:hover': {
      zIndex: 1
    },
    '&:focus': {
      zIndex: 1
    }
  }), _defineProperty(_extends2, "& > ".concat(antCls, "-select-focused"), {
    zIndex: 1
  }), _defineProperty(_extends2, "& > ".concat(antCls, "-select > ").concat(antCls, "-select-arrow"), {
    zIndex: 1 // https://github.com/ant-design/ant-design/issues/20371
  }), _defineProperty(_extends2, "& > *:first-child,\n      & > ".concat(antCls, "-select:first-child > ").concat(antCls, "-select-selector,\n      & > ").concat(antCls, "-select-auto-complete:first-child ").concat(componentCls, ",\n      & > ").concat(antCls, "-cascader-picker:first-child ").concat(componentCls), {
    borderStartStartRadius: token.borderRadius,
    borderEndStartRadius: token.borderRadius
  }), _defineProperty(_extends2, "& > *:last-child,\n      & > ".concat(antCls, "-select:last-child > ").concat(antCls, "-select-selector,\n      & > ").concat(antCls, "-cascader-picker:last-child ").concat(componentCls, ",\n      & > ").concat(antCls, "-cascader-picker-focused:last-child ").concat(componentCls), {
    borderInlineEndWidth: token.lineWidth,
    borderStartEndRadius: token.borderRadius,
    borderEndEndRadius: token.borderRadius
  }), _defineProperty(_extends2, "& > ".concat(antCls, "-select-auto-complete ").concat(componentCls), {
    verticalAlign: 'top'
  }), _defineProperty(_extends2, "".concat(componentCls, "-group-wrapper + ").concat(componentCls, "-group-wrapper"), _defineProperty({
    marginInlineStart: -token.lineWidth
  }, "".concat(componentCls, "-affix-wrapper"), {
    borderRadius: 0
  })), _defineProperty(_extends2, "".concat(componentCls, "-group-wrapper:not(:last-child)"), _defineProperty({}, "&".concat(componentCls, "-search > ").concat(componentCls, "-group"), (_$concat$concat5 = {}, _defineProperty(_$concat$concat5, "& > ".concat(componentCls, "-group-addon > ").concat(componentCls, "-search-button"), {
    borderRadius: 0
  }), _defineProperty(_$concat$concat5, "& > ".concat(componentCls), {
    borderStartStartRadius: token.borderRadius,
    borderStartEndRadius: 0,
    borderEndEndRadius: 0,
    borderEndStartRadius: token.borderRadius
  }), _$concat$concat5))), _extends2))), _ref2;
};
var genInputStyle = function genInputStyle(token) {
  var _typeColor;
  var componentCls = token.componentCls,
    controlHeightSM = token.controlHeightSM,
    lineWidth = token.lineWidth;
  var FIXED_CHROME_COLOR_HEIGHT = 16;
  var colorSmallPadding = (controlHeightSM - lineWidth * 2 - FIXED_CHROME_COLOR_HEIGHT) / 2;
  return _defineProperty({}, componentCls, _extends(_extends(_extends(_extends({}, resetComponent(token)), genBasicInputStyle(token)), genStatusStyle(token, componentCls)), {
    '&[type="color"]': (_typeColor = {
      height: token.controlHeight
    }, _defineProperty(_typeColor, "&".concat(componentCls, "-lg"), {
      height: token.controlHeightLG
    }), _defineProperty(_typeColor, "&".concat(componentCls, "-sm"), {
      height: controlHeightSM,
      paddingTop: colorSmallPadding,
      paddingBottom: colorSmallPadding
    }), _typeColor)
  }));
};
var genAllowClearStyle = function genAllowClearStyle(token) {
  var _ref4;
  var componentCls = token.componentCls;
  return _ref4 = {}, _defineProperty(_ref4, "".concat(componentCls, "-clear-icon"), {
    margin: 0,
    color: token.colorTextQuaternary,
    fontSize: token.fontSizeIcon,
    verticalAlign: -1,
    // https://github.com/ant-design/ant-design/pull/18151
    // https://codesandbox.io/s/wizardly-sun-u10br
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationSlow),
    '&:hover': {
      color: token.colorTextTertiary
    },
    '&:active': {
      color: token.colorText
    },
    '&-hidden': {
      visibility: 'hidden'
    },
    '&-has-suffix': {
      margin: "0 ".concat(token.inputAffixPadding, "px")
    }
  }), _defineProperty(_ref4, '&-textarea-with-clear-btn', _defineProperty({
    padding: '0 !important',
    border: '0 !important'
  }, "".concat(componentCls, "-clear-icon"), {
    position: 'absolute',
    insetBlockStart: token.paddingXS,
    insetInlineEnd: token.paddingXS,
    zIndex: 1
  })), _ref4;
};
var genAffixStyle = function genAffixStyle(token) {
  var _extends4;
  var componentCls = token.componentCls,
    inputAffixPadding = token.inputAffixPadding,
    colorTextDescription = token.colorTextDescription,
    motionDurationSlow = token.motionDurationSlow,
    colorIcon = token.colorIcon,
    colorIconHover = token.colorIconHover,
    iconCls = token.iconCls;
  return _defineProperty({}, "".concat(componentCls, "-affix-wrapper"), _extends(_extends(_extends(_extends(_extends({}, genBasicInputStyle(token)), (_extends4 = {
    display: 'inline-flex'
  }, _defineProperty(_extends4, "&:not(".concat(componentCls, "-affix-wrapper-disabled):hover"), _extends(_extends({}, genHoverStyle(token)), _defineProperty({
    zIndex: 1
  }, "".concat(componentCls, "-search-with-button &"), {
    zIndex: 0
  }))), _defineProperty(_extends4, '&-focused, &:focus', {
    zIndex: 1
  }), _defineProperty(_extends4, '&-disabled', _defineProperty({}, "".concat(componentCls, "[disabled]"), {
    background: 'transparent'
  })), _defineProperty(_extends4, "> input".concat(componentCls), {
    padding: 0,
    fontSize: 'inherit',
    border: 'none',
    borderRadius: 0,
    outline: 'none',
    '&:focus': {
      boxShadow: 'none !important'
    }
  }), _defineProperty(_extends4, '&::before', {
    width: 0,
    visibility: 'hidden',
    content: '"\\a0"'
  }), _defineProperty(_extends4, "".concat(componentCls), {
    '&-prefix, &-suffix': {
      display: 'flex',
      flex: 'none',
      alignItems: 'center',
      '> *:not(:last-child)': {
        marginInlineEnd: token.paddingXS
      }
    },
    '&-show-count-suffix': {
      color: colorTextDescription
    },
    '&-show-count-has-suffix': {
      marginInlineEnd: token.paddingXXS
    },
    '&-prefix': {
      marginInlineEnd: inputAffixPadding
    },
    '&-suffix': {
      marginInlineStart: inputAffixPadding
    }
  }), _extends4)), genAllowClearStyle(token)), _defineProperty({}, "".concat(iconCls).concat(componentCls, "-password-icon"), {
    color: colorIcon,
    cursor: 'pointer',
    transition: "all ".concat(motionDurationSlow),
    '&:hover': {
      color: colorIconHover
    }
  })), genStatusStyle(token, "".concat(componentCls, "-affix-wrapper"))));
};
var genGroupStyle = function genGroupStyle(token) {
  var componentCls = token.componentCls,
    colorError = token.colorError,
    colorSuccess = token.colorSuccess,
    borderRadiusLG = token.borderRadiusLG,
    borderRadiusSM = token.borderRadiusSM;
  return _defineProperty({}, "".concat(componentCls, "-group"), _extends(_extends(_extends({}, resetComponent(token)), genInputGroupStyle(token)), {
    '&-rtl': {
      direction: 'rtl'
    },
    '&-wrapper': {
      display: 'inline-block',
      width: '100%',
      textAlign: 'start',
      verticalAlign: 'top',
      '&-rtl': {
        direction: 'rtl'
      },
      // Size
      '&-lg': _defineProperty({}, "".concat(componentCls, "-group-addon"), {
        borderRadius: borderRadiusLG
      }),
      '&-sm': _defineProperty({}, "".concat(componentCls, "-group-addon"), {
        borderRadius: borderRadiusSM
      }),
      // Status
      '&-status-error': _defineProperty({}, "".concat(componentCls, "-group-addon"), {
        color: colorError,
        borderColor: colorError
      }),
      '&-status-warning': _defineProperty({}, "".concat(componentCls, "-group-addon:last-child"), {
        color: colorSuccess,
        borderColor: colorSuccess
      })
    }
  }));
};
var genSearchInputStyle = function genSearchInputStyle(token) {
  var _$concat7, _$concat10, _searchPrefixCls;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  var searchPrefixCls = "".concat(componentCls, "-search");
  return _defineProperty({}, searchPrefixCls, (_searchPrefixCls = {}, _defineProperty(_searchPrefixCls, "".concat(componentCls), {
    '&:hover, &:focus': _defineProperty({
      borderColor: token.colorPrimaryHover
    }, "+ ".concat(componentCls, "-group-addon ").concat(searchPrefixCls, "-button:not(").concat(antCls, "-btn-primary)"), {
      borderInlineStartColor: token.colorPrimaryHover
    })
  }), _defineProperty(_searchPrefixCls, "".concat(componentCls, "-affix-wrapper"), {
    borderRadius: 0
  }), _defineProperty(_searchPrefixCls, "".concat(componentCls, "-lg"), {
    lineHeight: token.lineHeightLG - 0.0002
  }), _defineProperty(_searchPrefixCls, "> ".concat(componentCls, "-group"), _defineProperty({}, "> ".concat(componentCls, "-group-addon:last-child"), (_$concat7 = {
    insetInlineStart: -1,
    padding: 0,
    border: 0
  }, _defineProperty(_$concat7, "".concat(searchPrefixCls, "-button"), {
    paddingTop: 0,
    paddingBottom: 0,
    borderStartStartRadius: 0,
    borderStartEndRadius: token.borderRadius,
    borderEndEndRadius: token.borderRadius,
    borderEndStartRadius: 0
  }), _defineProperty(_$concat7, "".concat(searchPrefixCls, "-button:not(").concat(antCls, "-btn-primary)"), _defineProperty({
    color: token.colorTextDescription,
    '&:hover': {
      color: token.colorPrimaryHover
    },
    '&:active': {
      color: token.colorPrimaryActive
    }
  }, "&".concat(antCls, "-btn-loading::before"), {
    insetInlineStart: 0,
    insetInlineEnd: 0,
    insetBlockStart: 0,
    insetBlockEnd: 0
  })), _$concat7))), _defineProperty(_searchPrefixCls, "".concat(searchPrefixCls, "-button"), {
    height: token.controlHeight,
    '&:hover, &:focus': {
      zIndex: 1
    }
  }), _defineProperty(_searchPrefixCls, "&-large ".concat(searchPrefixCls, "-button"), {
    height: token.controlHeightLG
  }), _defineProperty(_searchPrefixCls, "&-small ".concat(searchPrefixCls, "-button"), {
    height: token.controlHeightSM
  }), _defineProperty(_searchPrefixCls, '&-rtl', {
    direction: 'rtl'
  }), _defineProperty(_searchPrefixCls, "&".concat(componentCls, "-compact-item"), (_$concat10 = {}, _defineProperty(_$concat10, "&:not(".concat(componentCls, "-compact-last-item)"), _defineProperty({}, "".concat(componentCls, "-group-addon"), _defineProperty({}, "".concat(componentCls, "-search-button"), {
    marginInlineEnd: -token.lineWidth,
    borderRadius: 0
  }))), _defineProperty(_$concat10, "&:not(".concat(componentCls, "-compact-first-item)"), _defineProperty({}, "".concat(componentCls, ",").concat(componentCls, "-affix-wrapper"), {
    borderRadius: 0
  })), _defineProperty(_$concat10, "> ".concat(componentCls, "-group-addon ").concat(componentCls, "-search-button,\n        > ").concat(componentCls, ",\n        ").concat(componentCls, "-affix-wrapper"), {
    '&:hover,&:focus,&:active': {
      zIndex: 2
    }
  }), _defineProperty(_$concat10, "> ".concat(componentCls, "-affix-wrapper-focused"), {
    zIndex: 2
  }), _$concat10)), _searchPrefixCls));
};
export function initInputToken(token) {
  // @ts-ignore
  return mergeToken(token, {
    inputAffixPadding: token.paddingXXS,
    inputPaddingVertical: Math.max(Math.round((token.controlHeight - token.fontSize * token.lineHeight) / 2 * 10) / 10 - token.lineWidth, 3),
    inputPaddingVerticalLG: Math.ceil((token.controlHeightLG - token.fontSizeLG * token.lineHeightLG) / 2 * 10) / 10 - token.lineWidth,
    inputPaddingVerticalSM: Math.max(Math.round((token.controlHeightSM - token.fontSize * token.lineHeight) / 2 * 10) / 10 - token.lineWidth, 0),
    inputPaddingHorizontal: token.paddingSM - token.lineWidth,
    inputPaddingHorizontalSM: token.paddingXS - token.lineWidth,
    inputPaddingHorizontalLG: token.controlPaddingHorizontal - token.lineWidth,
    inputBorderHoverColor: token.colorPrimaryHover,
    inputBorderActiveColor: token.colorPrimaryHover
  });
}
var genTextAreaStyle = function genTextAreaStyle(token) {
  var _showCount, _textareaPrefixCls;
  var componentCls = token.componentCls,
    inputPaddingHorizontal = token.inputPaddingHorizontal,
    paddingLG = token.paddingLG;
  var textareaPrefixCls = "".concat(componentCls, "-textarea");
  return _defineProperty({}, textareaPrefixCls, (_textareaPrefixCls = {
    position: 'relative'
  }, _defineProperty(_textareaPrefixCls, "".concat(textareaPrefixCls, "-suffix"), {
    position: 'absolute',
    top: 0,
    insetInlineEnd: inputPaddingHorizontal,
    bottom: 0,
    zIndex: 1,
    display: 'inline-flex',
    alignItems: 'center',
    margin: 'auto'
  }), _defineProperty(_textareaPrefixCls, "&-status-error,\n        &-status-warning,\n        &-status-success,\n        &-status-validating", _defineProperty({}, "&".concat(textareaPrefixCls, "-has-feedback"), _defineProperty({}, "".concat(componentCls), {
    paddingInlineEnd: paddingLG
  }))), _defineProperty(_textareaPrefixCls, '&-show-count', (_showCount = {}, _defineProperty(_showCount, "> ".concat(componentCls), {
    height: '100%'
  }), _defineProperty(_showCount, '&::after', {
    color: token.colorTextDescription,
    whiteSpace: 'nowrap',
    content: 'attr(data-count)',
    pointerEvents: 'none',
    float: 'right'
  }), _showCount)), _defineProperty(_textareaPrefixCls, '&-rtl', {
    '&::after': {
      float: 'left'
    }
  }), _textareaPrefixCls));
};
// ============================== Export ==============================
export default genComponentStyleHook('Input', function (token) {
  var inputToken = initInputToken(token);
  return [genInputStyle(inputToken), genTextAreaStyle(inputToken), genAffixStyle(inputToken), genGroupStyle(inputToken), genSearchInputStyle(inputToken),
  // =====================================================
  // ==             Space Compact                       ==
  // =====================================================
  genCompactItemStyle(inputToken)];
});