import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { resetComponent } from '../../style';
var genBorderedStyle = function genBorderedStyle(token) {
  var _$concat, _ref;
  var listBorderedCls = token.listBorderedCls,
    componentCls = token.componentCls,
    paddingLG = token.paddingLG,
    margin = token.margin,
    padding = token.padding,
    listItemPaddingSM = token.listItemPaddingSM,
    marginLG = token.marginLG,
    borderRadiusLG = token.borderRadiusLG;
  return _ref = {}, _defineProperty(_ref, "".concat(listBorderedCls), (_$concat = {
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    borderRadius: borderRadiusLG
  }, _defineProperty(_$concat, "".concat(componentCls, "-header,").concat(componentCls, "-footer,").concat(componentCls, "-item"), {
    paddingInline: paddingLG
  }), _defineProperty(_$concat, "".concat(componentCls, "-pagination"), {
    margin: "".concat(margin, "px ").concat(marginLG, "px")
  }), _$concat)), _defineProperty(_ref, "".concat(listBorderedCls).concat(componentCls, "-sm"), _defineProperty({}, "".concat(componentCls, "-item,").concat(componentCls, "-header,").concat(componentCls, "-footer"), {
    padding: listItemPaddingSM
  })), _defineProperty(_ref, "".concat(listBorderedCls).concat(componentCls, "-lg"), _defineProperty({}, "".concat(componentCls, "-item,").concat(componentCls, "-header,").concat(componentCls, "-footer"), {
    padding: "".concat(padding, "px ").concat(paddingLG, "px")
  })), _ref;
};
var genResponsiveStyle = function genResponsiveStyle(token) {
  var _mediaScreenAndM, _$concat8, _mediaScreenAndM2, _ref2;
  var componentCls = token.componentCls,
    screenSM = token.screenSM,
    screenMD = token.screenMD,
    marginLG = token.marginLG,
    marginSM = token.marginSM,
    margin = token.margin;
  return _ref2 = {}, _defineProperty(_ref2, "@media screen and (max-width:".concat(screenMD, ")"), (_mediaScreenAndM = {}, _defineProperty(_mediaScreenAndM, "".concat(componentCls), _defineProperty({}, "".concat(componentCls, "-item"), _defineProperty({}, "".concat(componentCls, "-item-action"), {
    marginInlineStart: marginLG
  }))), _defineProperty(_mediaScreenAndM, "".concat(componentCls, "-vertical"), _defineProperty({}, "".concat(componentCls, "-item"), _defineProperty({}, "".concat(componentCls, "-item-extra"), {
    marginInlineStart: marginLG
  }))), _mediaScreenAndM)), _defineProperty(_ref2, "@media screen and (max-width: ".concat(screenSM, ")"), (_mediaScreenAndM2 = {}, _defineProperty(_mediaScreenAndM2, "".concat(componentCls), _defineProperty({}, "".concat(componentCls, "-item"), _defineProperty({
    flexWrap: 'wrap'
  }, "".concat(componentCls, "-action"), {
    marginInlineStart: marginSM
  }))), _defineProperty(_mediaScreenAndM2, "".concat(componentCls, "-vertical"), _defineProperty({}, "".concat(componentCls, "-item"), (_$concat8 = {
    flexWrap: 'wrap-reverse'
  }, _defineProperty(_$concat8, "".concat(componentCls, "-item-main"), {
    minWidth: token.contentWidth
  }), _defineProperty(_$concat8, "".concat(componentCls, "-item-extra"), {
    margin: "auto auto ".concat(margin, "px")
  }), _$concat8))), _mediaScreenAndM2)), _ref2;
};
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _$concat11, _$concat12, _$concat13, _extends2, _$concat$concat3, _ref3;
  var componentCls = token.componentCls,
    antCls = token.antCls,
    controlHeight = token.controlHeight,
    minHeight = token.minHeight,
    paddingSM = token.paddingSM,
    marginLG = token.marginLG,
    padding = token.padding,
    listItemPadding = token.listItemPadding,
    colorPrimary = token.colorPrimary,
    listItemPaddingSM = token.listItemPaddingSM,
    listItemPaddingLG = token.listItemPaddingLG,
    paddingXS = token.paddingXS,
    margin = token.margin,
    colorText = token.colorText,
    colorTextDescription = token.colorTextDescription,
    motionDurationSlow = token.motionDurationSlow,
    lineWidth = token.lineWidth;
  return _ref3 = {}, _defineProperty(_ref3, "".concat(componentCls), _extends(_extends({}, resetComponent(token)), (_extends2 = {
    position: 'relative',
    '*': {
      outline: 'none'
    }
  }, _defineProperty(_extends2, "".concat(componentCls, "-header, ").concat(componentCls, "-footer"), {
    background: 'transparent',
    paddingBlock: paddingSM
  }), _defineProperty(_extends2, "".concat(componentCls, "-pagination"), _defineProperty({
    marginBlockStart: marginLG,
    textAlign: 'end'
  }, "".concat(antCls, "-pagination-options"), {
    textAlign: 'start'
  })), _defineProperty(_extends2, "".concat(componentCls, "-spin"), {
    minHeight: minHeight,
    textAlign: 'center'
  }), _defineProperty(_extends2, "".concat(componentCls, "-items"), {
    margin: 0,
    padding: 0,
    listStyle: 'none'
  }), _defineProperty(_extends2, "".concat(componentCls, "-item"), (_$concat13 = {
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'space-between',
    padding: listItemPadding,
    color: colorText
  }, _defineProperty(_$concat13, "".concat(componentCls, "-item-meta"), (_$concat11 = {
    display: 'flex',
    flex: 1,
    alignItems: 'flex-start',
    maxWidth: '100%'
  }, _defineProperty(_$concat11, "".concat(componentCls, "-item-meta-avatar"), {
    marginInlineEnd: padding
  }), _defineProperty(_$concat11, "".concat(componentCls, "-item-meta-content"), {
    flex: '1 0',
    width: 0,
    color: colorText
  }), _defineProperty(_$concat11, "".concat(componentCls, "-item-meta-title"), {
    marginBottom: token.marginXXS,
    color: colorText,
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    '> a': _defineProperty({
      color: colorText,
      transition: "all ".concat(motionDurationSlow)
    }, "&:hover", {
      color: colorPrimary
    })
  }), _defineProperty(_$concat11, "".concat(componentCls, "-item-meta-description"), {
    color: colorTextDescription,
    fontSize: token.fontSize,
    lineHeight: token.lineHeight
  }), _$concat11)), _defineProperty(_$concat13, "".concat(componentCls, "-item-action"), (_$concat12 = {
    flex: '0 0 auto',
    marginInlineStart: token.marginXXL,
    padding: 0,
    fontSize: 0,
    listStyle: 'none'
  }, _defineProperty(_$concat12, "& > li", _defineProperty({
    position: 'relative',
    display: 'inline-block',
    padding: "0 ".concat(paddingXS, "px"),
    color: colorTextDescription,
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    textAlign: 'center'
  }, "&:first-child", {
    paddingInlineStart: 0
  })), _defineProperty(_$concat12, "".concat(componentCls, "-item-action-split"), {
    position: 'absolute',
    insetBlockStart: '50%',
    insetInlineEnd: 0,
    width: lineWidth,
    height: Math.ceil(token.fontSize * token.lineHeight) - token.marginXXS * 2,
    transform: 'translateY(-50%)',
    backgroundColor: token.colorSplit
  }), _$concat12)), _$concat13)), _defineProperty(_extends2, "".concat(componentCls, "-empty"), {
    padding: "".concat(padding, "px 0"),
    color: colorTextDescription,
    fontSize: token.fontSizeSM,
    textAlign: 'center'
  }), _defineProperty(_extends2, "".concat(componentCls, "-empty-text"), {
    padding: padding,
    color: token.colorTextDisabled,
    fontSize: token.fontSize,
    textAlign: 'center'
  }), _defineProperty(_extends2, "".concat(componentCls, "-item-no-flex"), {
    display: 'block'
  }), _extends2))), _defineProperty(_ref3, "".concat(componentCls, "-grid ").concat(antCls, "-col > ").concat(componentCls, "-item"), {
    display: 'block',
    maxWidth: '100%',
    marginBlockEnd: margin,
    paddingBlock: 0,
    borderBlockEnd: 'none'
  }), _defineProperty(_ref3, "".concat(componentCls, "-vertical ").concat(componentCls, "-item"), (_$concat$concat3 = {
    alignItems: 'initial'
  }, _defineProperty(_$concat$concat3, "".concat(componentCls, "-item-main"), {
    display: 'block',
    flex: 1
  }), _defineProperty(_$concat$concat3, "".concat(componentCls, "-item-extra"), {
    marginInlineStart: marginLG
  }), _defineProperty(_$concat$concat3, "".concat(componentCls, "-item-meta"), _defineProperty({
    marginBlockEnd: padding
  }, "".concat(componentCls, "-item-meta-title"), {
    marginBlockEnd: paddingSM,
    color: colorText,
    fontSize: token.fontSizeLG,
    lineHeight: token.lineHeightLG
  })), _defineProperty(_$concat$concat3, "".concat(componentCls, "-item-action"), {
    marginBlockStart: padding,
    marginInlineStart: 'auto',
    '> li': _defineProperty({
      padding: "0 ".concat(padding, "px")
    }, "&:first-child", {
      paddingInlineStart: 0
    })
  }), _$concat$concat3)), _defineProperty(_ref3, "".concat(componentCls, "-split ").concat(componentCls, "-item"), _defineProperty({
    borderBlockEnd: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
  }, "&:last-child", {
    borderBlockEnd: 'none'
  })), _defineProperty(_ref3, "".concat(componentCls, "-split ").concat(componentCls, "-header"), {
    borderBlockEnd: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
  }), _defineProperty(_ref3, "".concat(componentCls, "-split").concat(componentCls, "-empty ").concat(componentCls, "-footer"), {
    borderTop: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
  }), _defineProperty(_ref3, "".concat(componentCls, "-loading ").concat(componentCls, "-spin-nested-loading"), {
    minHeight: controlHeight
  }), _defineProperty(_ref3, "".concat(componentCls, "-split").concat(componentCls, "-something-after-last-item ").concat(antCls, "-spin-container > ").concat(componentCls, "-items > ").concat(componentCls, "-item:last-child"), {
    borderBlockEnd: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
  }), _defineProperty(_ref3, "".concat(componentCls, "-lg ").concat(componentCls, "-item"), {
    padding: listItemPaddingLG
  }), _defineProperty(_ref3, "".concat(componentCls, "-sm ").concat(componentCls, "-item"), {
    padding: listItemPaddingSM
  }), _defineProperty(_ref3, "".concat(componentCls, ":not(").concat(componentCls, "-vertical)"), _defineProperty({}, "".concat(componentCls, "-item-no-flex"), _defineProperty({}, "".concat(componentCls, "-item-action"), {
    float: 'right'
  }))), _ref3;
};
// ============================== Export ==============================
export default genComponentStyleHook('List', function (token) {
  var listToken = mergeToken(token, {
    listBorderedCls: "".concat(token.componentCls, "-bordered"),
    minHeight: token.controlHeightLG,
    listItemPadding: "".concat(token.paddingContentVertical, "px ").concat(token.paddingContentHorizontalLG, "px"),
    listItemPaddingSM: "".concat(token.paddingContentVerticalSM, "px ").concat(token.paddingContentHorizontal, "px"),
    listItemPaddingLG: "".concat(token.paddingContentVerticalLG, "px ").concat(token.paddingContentHorizontalLG, "px")
  });
  return [genBaseStyle(listToken), genBorderedStyle(listToken), genResponsiveStyle(listToken)];
}, {
  contentWidth: 220
});