import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import { createVNode as _createVNode } from "vue";
import { getPropsSlot } from '../../_util/props-util';
import { computed, defineComponent } from 'vue';
import PropTypes from '../../_util/vue-types';
import { useInjectMenu } from './hooks/useMenuContext';
import { useMeasure } from './hooks/useKeyPath';
import { objectType } from '../../_util/type';
export var menuItemGroupProps = function menuItemGroupProps() {
  return {
    title: PropTypes.any,
    // Internal user prop
    originItemValue: objectType()
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AMenuItemGroup',
  inheritAttrs: false,
  props: menuItemGroupProps(),
  slots: ['title'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useInjectMenu = useInjectMenu(),
      prefixCls = _useInjectMenu.prefixCls;
    var groupPrefixCls = computed(function () {
      return "".concat(prefixCls.value, "-item-group");
    });
    var isMeasure = useMeasure();
    return function () {
      var _a, _b;
      if (isMeasure) return (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
      return _createVNode("li", _objectSpread(_objectSpread({}, attrs), {}, {
        "onClick": function onClick(e) {
          return e.stopPropagation();
        },
        "class": groupPrefixCls.value
      }), [_createVNode("div", {
        "title": typeof props.title === 'string' ? props.title : undefined,
        "class": "".concat(groupPrefixCls.value, "-title")
      }, [getPropsSlot(slots, props, 'title')]), _createVNode("ul", {
        "class": "".concat(groupPrefixCls.value, "-list")
      }, [(_b = slots.default) === null || _b === void 0 ? void 0 : _b.call(slots)])]);
    };
  }
});