import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { resetComponent, textEllipsis } from '../../style';
import { operationUnit } from '../../style';
var genPageHeaderStyle = function genPageHeaderStyle(token) {
  var _extra, _$concat2, _$concat4, _extends2;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  return _defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    position: 'relative',
    padding: "".concat(token.pageHeaderPaddingVertical, "px ").concat(token.pageHeaderPadding, "px"),
    backgroundColor: token.colorBgContainer
  }, _defineProperty(_extends2, "".concat(componentCls, "-ghost"), {
    backgroundColor: token.pageHeaderGhostBg
  }), _defineProperty(_extends2, "&.has-footer", {
    paddingBottom: 0
  }), _defineProperty(_extends2, "".concat(componentCls, "-back"), _defineProperty({
    marginRight: token.marginMD,
    fontZize: token.fontSizeLG,
    lineHeight: 1
  }, "&-button", _extends(_extends({}, operationUnit(token)), {
    color: token.pageHeaderBackColor,
    cursor: 'pointer'
  }))), _defineProperty(_extends2, "".concat(antCls, "-divider-vertical"), {
    height: '14px',
    margin: "0 ".concat(token.marginSM),
    verticalAlign: 'middle'
  }), _defineProperty(_extends2, "".concat(antCls, "-breadcrumb + &-heading"), {
    marginTop: token.marginXS
  }), _defineProperty(_extends2, "".concat(componentCls, "-heading"), (_$concat2 = {
    display: 'flex',
    justifyContent: 'space-between'
  }, _defineProperty(_$concat2, "&-left", {
    display: 'flex',
    alignItems: 'center',
    margin: "".concat(token.marginXS / 2, "px 0"),
    overflow: 'hidden'
  }), _defineProperty(_$concat2, "&-title", _extends({
    marginRight: token.marginSM,
    marginBottom: 0,
    color: token.colorTextHeading,
    fontWeight: 600,
    fontSize: token.pageHeaderHeadingTitle,
    lineHeight: "".concat(token.controlHeight, "px")
  }, textEllipsis)), _defineProperty(_$concat2, "".concat(antCls, "-avatar"), {
    marginRight: token.marginSM
  }), _defineProperty(_$concat2, "&-sub-title", _extends({
    marginRight: token.marginSM,
    color: token.colorTextDescription,
    fontSize: token.pageHeaderHeadingSubTitle,
    lineHeight: token.lineHeight
  }, textEllipsis)), _defineProperty(_$concat2, "&-extra", (_extra = {
    margin: "".concat(token.marginXS / 2, "px 0"),
    whiteSpace: 'nowrap'
  }, _defineProperty(_extra, "> *", {
    marginLeft: token.marginSM,
    whiteSpace: 'unset'
  }), _defineProperty(_extra, "> *:first-child", {
    marginLeft: 0
  }), _extra)), _$concat2)), _defineProperty(_extends2, "".concat(componentCls, "-content"), {
    paddingTop: token.pageHeaderContentPaddingVertical
  }), _defineProperty(_extends2, "".concat(componentCls, "-footer"), _defineProperty({
    marginTop: token.marginMD
  }, "".concat(antCls, "-tabs"), (_$concat4 = {}, _defineProperty(_$concat4, "> ".concat(antCls, "-tabs-nav"), _defineProperty({
    margin: 0
  }, "&::before", {
    border: 'none'
  })), _defineProperty(_$concat4, "".concat(antCls, "-tabs-tab"), {
    paddingTop: token.paddingXS,
    paddingBottom: token.paddingXS,
    fontSize: token.pageHeaderTabFontSize
  }), _$concat4))), _defineProperty(_extends2, "".concat(componentCls, "-compact ").concat(componentCls, "-heading"), {
    flexWrap: 'wrap'
  }), _defineProperty(_extends2, "&".concat(token.componentCls, "-rtl"), {
    direction: 'rtl'
  }), _extends2)));
};
// ============================== Export ==============================
export default genComponentStyleHook('PageHeader', function (token) {
  var PageHeaderToken = mergeToken(token, {
    pageHeaderPadding: token.paddingLG,
    pageHeaderPaddingVertical: token.paddingMD,
    pageHeaderPaddingBreadcrumb: token.paddingSM,
    pageHeaderContentPaddingVertical: token.paddingSM,
    pageHeaderBackColor: token.colorTextBase,
    pageHeaderGhostBg: 'inherit',
    pageHeaderHeadingTitle: token.fontSizeHeading4,
    pageHeaderHeadingSubTitle: token.fontSize,
    pageHeaderTabFontSize: token.fontSizeLG
  });
  return [genPageHeaderStyle(PageHeaderToken)];
});