import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { computed, ref, toRef, defineComponent } from 'vue';
import Popover from '../popover';
import abstractTooltipProps from '../tooltip/abstractTooltipProps';
import { initDefaultProps } from '../_util/props-util';
import { convertLegacyProps } from '../button/buttonTypes';
import ExclamationCircleFilled from "@ant-design/icons-vue/es/icons/ExclamationCircleFilled";
import Button from '../button';
import { useLocaleReceiver } from '../locale-provider/LocaleReceiver';
import defaultLocale from '../locale/en_US';
import { anyType, objectType, stringType, withInstall } from '../_util/type';
import useMergedState from '../_util/hooks/useMergedState';
import KeyCode from '../_util/KeyCode';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import classNames from '../_util/classNames';
import { getTransitionName } from '../_util/transition';
import { cloneVNodes } from '../_util/vnode';
import omit from '../_util/omit';
import { tooltipDefaultProps } from '../tooltip/Tooltip';
import ActionButton from '../_util/ActionButton';
import usePopconfirmStyle from './style';
import warning from '../_util/warning';
export var popconfirmProps = function popconfirmProps() {
  return _extends(_extends({}, abstractTooltipProps()), {
    prefixCls: String,
    content: anyType(),
    title: anyType(),
    description: anyType(),
    okType: stringType('primary'),
    disabled: {
      type: Boolean,
      default: false
    },
    okText: anyType(),
    cancelText: anyType(),
    icon: anyType(),
    okButtonProps: objectType(),
    cancelButtonProps: objectType(),
    showCancel: {
      type: Boolean,
      default: true
    },
    onConfirm: Function,
    onCancel: Function
  });
};
var Popconfirm = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'APopconfirm',
  inheritAttrs: false,
  props: initDefaultProps(popconfirmProps(), _extends(_extends({}, tooltipDefaultProps()), {
    trigger: 'click',
    placement: 'top',
    mouseEnterDelay: 0.1,
    mouseLeaveDelay: 0.1,
    arrowPointAtCenter: false,
    autoAdjustOverflow: true,
    okType: 'primary',
    disabled: false
  })),
  slots: ['title', 'content', 'okText', 'icon', 'cancelText', 'cancelButton', 'okButton'],
  // emits: ['update:open', 'visibleChange'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      expose = _ref.expose,
      attrs = _ref.attrs;
    var rootRef = ref();
    warning(props.visible === undefined, 'Popconfirm', "`visible` will be removed in next major version, please use `open` instead.");
    expose({
      getPopupDomNode: function getPopupDomNode() {
        var _a, _b;
        return (_b = (_a = rootRef.value) === null || _a === void 0 ? void 0 : _a.getPopupDomNode) === null || _b === void 0 ? void 0 : _b.call(_a);
      }
    });
    var _useMergedState = useMergedState(false, {
        value: toRef(props, 'open')
      }),
      _useMergedState2 = _slicedToArray(_useMergedState, 2),
      open = _useMergedState2[0],
      setOpen = _useMergedState2[1];
    var settingOpen = function settingOpen(value, e) {
      if (props.open === undefined) {
        setOpen(value);
      }
      emit('update:open', value);
      emit('openChange', value, e);
    };
    var close = function close(e) {
      settingOpen(false, e);
    };
    var onConfirm = function onConfirm(e) {
      var _a;
      return (_a = props.onConfirm) === null || _a === void 0 ? void 0 : _a.call(props, e);
    };
    var onCancel = function onCancel(e) {
      var _a;
      settingOpen(false, e);
      (_a = props.onCancel) === null || _a === void 0 ? void 0 : _a.call(props, e);
    };
    var onKeyDown = function onKeyDown(e) {
      if (e.keyCode === KeyCode.ESC && open) {
        settingOpen(false, e);
      }
    };
    var onOpenChange = function onOpenChange(value) {
      var disabled = props.disabled;
      if (disabled) {
        return;
      }
      settingOpen(value);
    };
    var _useConfigInject = useConfigInject('popconfirm', props),
      prefixClsConfirm = _useConfigInject.prefixCls,
      getPrefixCls = _useConfigInject.getPrefixCls;
    var rootPrefixCls = computed(function () {
      return getPrefixCls();
    });
    var btnPrefixCls = computed(function () {
      return getPrefixCls('btn');
    });
    var _usePopconfirmStyle = usePopconfirmStyle(prefixClsConfirm),
      _usePopconfirmStyle2 = _slicedToArray(_usePopconfirmStyle, 1),
      wrapSSR = _usePopconfirmStyle2[0];
    var _useLocaleReceiver = useLocaleReceiver('Popconfirm', defaultLocale.Popconfirm),
      _useLocaleReceiver2 = _slicedToArray(_useLocaleReceiver, 1),
      popconfirmLocale = _useLocaleReceiver2[0];
    var renderOverlay = function renderOverlay() {
      var _a, _b, _c, _d, _e;
      var okButtonProps = props.okButtonProps,
        cancelButtonProps = props.cancelButtonProps,
        _props$title = props.title,
        title = _props$title === void 0 ? (_a = slots.title) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$title,
        _props$description = props.description,
        description = _props$description === void 0 ? (_b = slots.description) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$description,
        _props$cancelText = props.cancelText,
        cancelText = _props$cancelText === void 0 ? (_c = slots.cancel) === null || _c === void 0 ? void 0 : _c.call(slots) : _props$cancelText,
        _props$okText = props.okText,
        okText = _props$okText === void 0 ? (_d = slots.okText) === null || _d === void 0 ? void 0 : _d.call(slots) : _props$okText,
        okType = props.okType,
        _props$icon = props.icon,
        icon = _props$icon === void 0 ? ((_e = slots.icon) === null || _e === void 0 ? void 0 : _e.call(slots)) || _createVNode(ExclamationCircleFilled, null, null) : _props$icon,
        _props$showCancel = props.showCancel,
        showCancel = _props$showCancel === void 0 ? true : _props$showCancel;
      var cancelButton = slots.cancelButton,
        okButton = slots.okButton;
      var cancelProps = _extends({
        onClick: onCancel,
        size: 'small'
      }, cancelButtonProps);
      var okProps = _extends(_extends(_extends({
        onClick: onConfirm
      }, convertLegacyProps(okType)), {
        size: 'small'
      }), okButtonProps);
      return _createVNode("div", {
        "class": "".concat(prefixClsConfirm.value, "-inner-content")
      }, [_createVNode("div", {
        "class": "".concat(prefixClsConfirm.value, "-message")
      }, [icon && _createVNode("span", {
        "class": "".concat(prefixClsConfirm.value, "-message-icon")
      }, [icon]), _createVNode("div", {
        "class": ["".concat(prefixClsConfirm.value, "-message-title"), _defineProperty({}, "".concat(prefixClsConfirm.value, "-message-title-only"), !!description)]
      }, [title])]), description && _createVNode("div", {
        "class": "".concat(prefixClsConfirm.value, "-description")
      }, [description]), _createVNode("div", {
        "class": "".concat(prefixClsConfirm.value, "-buttons")
      }, [showCancel ? cancelButton ? cancelButton(cancelProps) : _createVNode(Button, cancelProps, {
        default: function _default() {
          return [cancelText || popconfirmLocale.value.cancelText];
        }
      }) : null, okButton ? okButton(okProps) : _createVNode(ActionButton, {
        "buttonProps": _extends(_extends({
          size: 'small'
        }, convertLegacyProps(okType)), okButtonProps),
        "actionFn": onConfirm,
        "close": close,
        "prefixCls": btnPrefixCls.value,
        "quitOnNullishReturnValue": true,
        "emitEvent": true
      }, {
        default: function _default() {
          return [okText || popconfirmLocale.value.okText];
        }
      })])]);
    };
    return function () {
      var _a;
      var placement = props.placement,
        overlayClassName = props.overlayClassName,
        _props$trigger = props.trigger,
        trigger = _props$trigger === void 0 ? 'click' : _props$trigger,
        restProps = __rest(props, ["placement", "overlayClassName", "trigger"]);
      var otherProps = omit(restProps, ['title', 'content', 'cancelText', 'okText', 'onUpdate:open', 'onConfirm', 'onCancel', 'prefixCls']);
      var overlayClassNames = classNames(prefixClsConfirm.value, overlayClassName);
      return wrapSSR(_createVNode(Popover, _objectSpread(_objectSpread(_objectSpread({}, otherProps), attrs), {}, {
        "trigger": trigger,
        "placement": placement,
        "onOpenChange": onOpenChange,
        "open": open.value,
        "overlayClassName": overlayClassNames,
        "transitionName": getTransitionName(rootPrefixCls.value, 'zoom-big', props.transitionName),
        "ref": rootRef,
        "data-popover-inject": true
      }), {
        default: function _default() {
          return [cloneVNodes(((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) || [], {
            onKeydown: function onKeydown(e) {
              onKeyDown(e);
            }
          }, false)];
        },
        content: renderOverlay
      }));
    };
  }
});
export default withInstall(Popconfirm);