import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, createVNode as _createVNode, Fragment as _Fragment } from "vue";
import { computed, defineComponent, ref } from 'vue';
import Tooltip from '../tooltip';
import abstractTooltipProps from '../tooltip/abstractTooltipProps';
import { filterEmpty, initDefaultProps } from '../_util/props-util';
import { anyType, withInstall } from '../_util/type';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import omit from '../_util/omit';
import { getTransitionName } from '../_util/transition';
import { tooltipDefaultProps } from '../tooltip/Tooltip';
import useStyle from './style';
import classNames from '../_util/classNames';
import warning from '../_util/warning';
export var popoverProps = function popoverProps() {
  return _extends(_extends({}, abstractTooltipProps()), {
    content: anyType(),
    title: anyType()
  });
};
var Popover = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'APopover',
  inheritAttrs: false,
  props: initDefaultProps(popoverProps(), _extends(_extends({}, tooltipDefaultProps()), {
    trigger: 'hover',
    placement: 'top',
    mouseEnterDelay: 0.1,
    mouseLeaveDelay: 0.1
  })),
  setup: function setup(props, _ref) {
    var expose = _ref.expose,
      slots = _ref.slots,
      attrs = _ref.attrs;
    var tooltipRef = ref();
    warning(props.visible === undefined, 'popover', "`visible` will be removed in next major version, please use `open` instead.");
    expose({
      getPopupDomNode: function getPopupDomNode() {
        var _a, _b;
        return (_b = (_a = tooltipRef.value) === null || _a === void 0 ? void 0 : _a.getPopupDomNode) === null || _b === void 0 ? void 0 : _b.call(_a);
      }
    });
    var _useConfigInject = useConfigInject('popover', props),
      prefixCls = _useConfigInject.prefixCls,
      configProvider = _useConfigInject.configProvider;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var rootPrefixCls = computed(function () {
      return configProvider.getPrefixCls();
    });
    var getOverlay = function getOverlay() {
      var _a, _b;
      var _props$title = props.title,
        title = _props$title === void 0 ? filterEmpty((_a = slots.title) === null || _a === void 0 ? void 0 : _a.call(slots)) : _props$title,
        _props$content = props.content,
        content = _props$content === void 0 ? filterEmpty((_b = slots.content) === null || _b === void 0 ? void 0 : _b.call(slots)) : _props$content;
      var hasTitle = !!(Array.isArray(title) ? title.length : title);
      var hasContent = !!(Array.isArray(content) ? content.length : title);
      if (!hasTitle && !hasContent) return null;
      return _createVNode(_Fragment, null, [hasTitle && _createVNode("div", {
        "class": "".concat(prefixCls.value, "-title")
      }, [title]), _createVNode("div", {
        "class": "".concat(prefixCls.value, "-inner-content")
      }, [content])]);
    };
    return function () {
      var overlayCls = classNames(props.overlayClassName, hashId.value);
      return wrapSSR(_createVNode(Tooltip, _objectSpread(_objectSpread(_objectSpread({}, omit(props, ['title', 'content'])), attrs), {}, {
        "prefixCls": prefixCls.value,
        "ref": tooltipRef,
        "overlayClassName": overlayCls,
        "transitionName": getTransitionName(rootPrefixCls.value, 'zoom-big', props.transitionName),
        "data-popover-inject": true
      }), {
        title: getOverlay,
        default: slots.default
      }));
    };
  }
});
export default withInstall(Popover);