import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { computed, defineComponent } from 'vue';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import CloseOutlined from "@ant-design/icons-vue/es/icons/CloseOutlined";
import CheckOutlined from "@ant-design/icons-vue/es/icons/CheckOutlined";
import CheckCircleFilled from "@ant-design/icons-vue/es/icons/CheckCircleFilled";
import CloseCircleFilled from "@ant-design/icons-vue/es/icons/CloseCircleFilled";
import Line from './Line';
import Circle from './Circle';
import Steps from './Steps';
import { getSize, getSuccessPercent, validProgress } from './utils';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import devWarning from '../vc-util/devWarning';
import { progressProps, progressStatuses } from './props';
import useStyle from './style';
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AProgress',
  inheritAttrs: false,
  props: initDefaultProps(progressProps(), {
    type: 'line',
    percent: 0,
    showInfo: true,
    // null for different theme definition
    trailColor: null,
    size: 'default',
    strokeLinecap: 'round'
  }),
  slots: ['format'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('progress', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    if (process.env.NODE_ENV !== 'production') {
      devWarning('successPercent' in props, 'Progress', '`successPercent` is deprecated. Please use `success.percent` instead.');
      devWarning('width' in props, 'Progress', '`width` is deprecated. Please use `size` instead.');
    }
    var strokeColorNotArray = computed(function () {
      return Array.isArray(props.strokeColor) ? props.strokeColor[0] : props.strokeColor;
    });
    var percentNumber = computed(function () {
      var _props$percent = props.percent,
        percent = _props$percent === void 0 ? 0 : _props$percent;
      var successPercent = getSuccessPercent(props);
      return parseInt(successPercent !== undefined ? successPercent.toString() : percent.toString(), 10);
    });
    var progressStatus = computed(function () {
      var status = props.status;
      if (!progressStatuses.includes(status) && percentNumber.value >= 100) {
        return 'success';
      }
      return status || 'normal';
    });
    var classString = computed(function () {
      var _ref2;
      var type = props.type,
        showInfo = props.showInfo,
        size = props.size;
      var pre = prefixCls.value;
      return _ref2 = {}, _defineProperty(_ref2, pre, true), _defineProperty(_ref2, "".concat(pre, "-inline-circle"), type === 'circle' && getSize(size, 'circle').width <= 20), _defineProperty(_ref2, "".concat(pre, "-").concat(type === 'dashboard' && 'circle' || type), true), _defineProperty(_ref2, "".concat(pre, "-status-").concat(progressStatus.value), true), _defineProperty(_ref2, "".concat(pre, "-show-info"), showInfo), _defineProperty(_ref2, "".concat(pre, "-").concat(size), size), _defineProperty(_ref2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _defineProperty(_ref2, hashId.value, true), _ref2;
    });
    var strokeColorNotGradient = computed(function () {
      return typeof props.strokeColor === 'string' || Array.isArray(props.strokeColor) ? props.strokeColor : undefined;
    });
    var renderProcessInfo = function renderProcessInfo() {
      var showInfo = props.showInfo,
        format = props.format,
        type = props.type,
        percent = props.percent,
        title = props.title;
      var successPercent = getSuccessPercent(props);
      if (!showInfo) return null;
      var text;
      var textFormatter = format || (slots === null || slots === void 0 ? void 0 : slots.format) || function (val) {
        return "".concat(val, "%");
      };
      var isLineType = type === 'line';
      if (format || (slots === null || slots === void 0 ? void 0 : slots.format) || progressStatus.value !== 'exception' && progressStatus.value !== 'success') {
        text = textFormatter(validProgress(percent), validProgress(successPercent));
      } else if (progressStatus.value === 'exception') {
        text = isLineType ? _createVNode(CloseCircleFilled, null, null) : _createVNode(CloseOutlined, null, null);
      } else if (progressStatus.value === 'success') {
        text = isLineType ? _createVNode(CheckCircleFilled, null, null) : _createVNode(CheckOutlined, null, null);
      }
      return _createVNode("span", {
        "class": "".concat(prefixCls.value, "-text"),
        "title": title === undefined && typeof text === 'string' ? text : undefined
      }, [text]);
    };
    return function () {
      var type = props.type,
        steps = props.steps,
        title = props.title;
      var cls = attrs.class,
        restAttrs = __rest(attrs, ["class"]);
      var progressInfo = renderProcessInfo();
      var progress;
      // Render progress shape
      if (type === 'line') {
        progress = steps ? _createVNode(Steps, _objectSpread(_objectSpread({}, props), {}, {
          "strokeColor": strokeColorNotGradient.value,
          "prefixCls": prefixCls.value,
          "steps": steps
        }), {
          default: function _default() {
            return [progressInfo];
          }
        }) : _createVNode(Line, _objectSpread(_objectSpread({}, props), {}, {
          "strokeColor": strokeColorNotArray.value,
          "prefixCls": prefixCls.value,
          "direction": direction.value
        }), {
          default: function _default() {
            return [progressInfo];
          }
        });
      } else if (type === 'circle' || type === 'dashboard') {
        progress = _createVNode(Circle, _objectSpread(_objectSpread({}, props), {}, {
          "prefixCls": prefixCls.value,
          "strokeColor": strokeColorNotArray.value,
          "progressStatus": progressStatus.value
        }), {
          default: function _default() {
            return [progressInfo];
          }
        });
      }
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({
        "role": "progressbar"
      }, restAttrs), {}, {
        "class": [classString.value, cls],
        "title": title
      }), [progress]));
    };
  }
});