import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { presetPrimaryColors } from '@ant-design/colors';
import devWarning from '../vc-util/devWarning';
export function validProgress(progress) {
  if (!progress || progress < 0) {
    return 0;
  }
  if (progress > 100) {
    return 100;
  }
  return progress;
}
export function getSuccessPercent(_ref) {
  var success = _ref.success,
    successPercent = _ref.successPercent;
  var percent = successPercent;
  /** @deprecated Use `percent` instead */
  if (success && 'progress' in success) {
    devWarning(false, 'Progress', '`success.progress` is deprecated. Please use `success.percent` instead.');
    percent = success.progress;
  }
  if (success && 'percent' in success) {
    percent = success.percent;
  }
  return percent;
}
export function getPercentage(_ref2) {
  var percent = _ref2.percent,
    success = _ref2.success,
    successPercent = _ref2.successPercent;
  var realSuccessPercent = validProgress(getSuccessPercent({
    success: success,
    successPercent: successPercent
  }));
  return [realSuccessPercent, validProgress(validProgress(percent) - realSuccessPercent)];
}
export function getStrokeColor(_ref3) {
  var _ref3$success = _ref3.success,
    success = _ref3$success === void 0 ? {} : _ref3$success,
    strokeColor = _ref3.strokeColor;
  var successColor = success.strokeColor;
  return [successColor || presetPrimaryColors.green, strokeColor || null];
}
export var getSize = function getSize(size, type, extra) {
  var _a, _b, _c, _d;
  var width = -1;
  var height = -1;
  if (type === 'step') {
    var steps = extra.steps;
    var strokeWidth = extra.strokeWidth;
    if (typeof size === 'string' || typeof size === 'undefined') {
      width = size === 'small' ? 2 : 14;
      height = strokeWidth !== null && strokeWidth !== void 0 ? strokeWidth : 8;
    } else if (typeof size === 'number') {
      width = size;
      height = size;
    } else {
      var _size = _slicedToArray(size, 2);
      var _size$ = _size[0];
      width = _size$ === void 0 ? 14 : _size$;
      var _size$2 = _size[1];
      height = _size$2 === void 0 ? 8 : _size$2;
    }
    width *= steps;
  } else if (type === 'line') {
    var _strokeWidth = extra === null || extra === void 0 ? void 0 : extra.strokeWidth;
    if (typeof size === 'string' || typeof size === 'undefined') {
      height = _strokeWidth || (size === 'small' ? 6 : 8);
    } else if (typeof size === 'number') {
      width = size;
      height = size;
    } else {
      var _size2 = _slicedToArray(size, 2);
      var _size2$ = _size2[0];
      width = _size2$ === void 0 ? -1 : _size2$;
      var _size2$2 = _size2[1];
      height = _size2$2 === void 0 ? 8 : _size2$2;
    }
  } else if (type === 'circle' || type === 'dashboard') {
    if (typeof size === 'string' || typeof size === 'undefined') {
      var _ref4 = size === 'small' ? [60, 60] : [120, 120];
      var _ref5 = _slicedToArray(_ref4, 2);
      width = _ref5[0];
      height = _ref5[1];
    } else if (typeof size === 'number') {
      width = size;
      height = size;
    } else {
      if (process.env.NODE_ENV !== 'production') {
        devWarning(false, 'Progress', 'Type "circle" and "dashboard" do not accept array as `size`, please use number or preset size instead.');
      }
      width = (_b = (_a = size[0]) !== null && _a !== void 0 ? _a : size[1]) !== null && _b !== void 0 ? _b : 120;
      height = (_d = (_c = size[0]) !== null && _c !== void 0 ? _c : size[1]) !== null && _d !== void 0 ? _d : 120;
    }
  }
  return {
    width: width,
    height: height
  };
};