import _extends from "@babel/runtime/helpers/esm/extends";
import { objectType, stringType } from '../_util/type';
export var qrProps = function qrProps() {
  return {
    size: {
      type: Number,
      default: 160
    },
    value: {
      type: String,
      required: true
    },
    color: String,
    includeMargin: Boolean,
    imageSettings: objectType()
  };
};
export var qrcodeProps = function qrcodeProps() {
  return _extends(_extends({}, qrProps()), {
    errorLevel: stringType('M'),
    icon: String,
    iconSize: {
      type: Number,
      default: 40
    },
    status: stringType('active'),
    bordered: {
      type: Boolean,
      default: true
    }
  });
};