import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { mergeToken, genComponentStyleHook } from '../../theme/internal';
import { resetComponent } from '../../style';
var genQRCodeStyle = function genQRCodeStyle(token) {
  var _extends2, _ref;
  var componentCls = token.componentCls;
  return _ref = {}, _defineProperty(_ref, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    padding: token.paddingSM,
    backgroundColor: token.colorWhite,
    borderRadius: token.borderRadiusLG,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit),
    position: 'relative',
    width: '100%',
    height: '100%',
    overflow: 'hidden'
  }, _defineProperty(_extends2, "& > ".concat(componentCls, "-mask"), _defineProperty({
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    zIndex: 10,
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    width: '100%',
    height: '100%',
    color: token.colorText,
    lineHeight: token.lineHeight,
    background: token.QRCodeMaskBackgroundColor,
    textAlign: 'center'
  }, "& > ".concat(componentCls, "-expired"), {
    color: token.QRCodeExpiredTextColor
  })), _defineProperty(_extends2, '&-icon', {
    marginBlockEnd: token.marginXS,
    fontSize: token.controlHeight
  }), _extends2))), _defineProperty(_ref, "".concat(componentCls, "-borderless"), {
    borderColor: 'transparent'
  }), _ref;
};
export default genComponentStyleHook('QRCode', function (token) {
  return genQRCodeStyle(mergeToken(token, {
    QRCodeExpiredTextColor: 'rgba(0, 0, 0, 0.88)',
    QRCodeMaskBackgroundColor: 'rgba(255, 255, 255, 0.96)'
  }));
});