import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { nextTick, defineComponent, ref, watch, computed } from 'vue';
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import Radio from './Radio';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { booleanType, stringType, arrayType, functionType } from '../_util/type';
import { useInjectFormItemContext } from '../form/FormItemContext';
import { useProvideRadioGroupContext } from './context';
// CSSINJS
import useStyle from './style';
var RadioGroupSizeTypes = ['large', 'default', 'small'];
export var radioGroupProps = function radioGroupProps() {
  return {
    prefixCls: String,
    value: PropTypes.any,
    size: stringType(),
    options: arrayType(),
    disabled: booleanType(),
    name: String,
    buttonStyle: stringType('outline'),
    id: String,
    optionType: stringType('default'),
    onChange: functionType(),
    'onUpdate:value': functionType()
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ARadioGroup',
  inheritAttrs: false,
  props: radioGroupProps(),
  // emits: ['update:value', 'change'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var formItemContext = useInjectFormItemContext();
    var _useConfigInject = useConfigInject('radio', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    // Style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var stateValue = ref(props.value);
    var updatingValue = ref(false);
    watch(function () {
      return props.value;
    }, function (val) {
      stateValue.value = val;
      updatingValue.value = false;
    });
    var onRadioChange = function onRadioChange(ev) {
      var lastValue = stateValue.value;
      var value = ev.target.value;
      if (!('value' in props)) {
        stateValue.value = value;
      }
      // nextTick for https://github.com/vueComponent/ant-design-vue/issues/1280
      if (!updatingValue.value && value !== lastValue) {
        updatingValue.value = true;
        emit('update:value', value);
        emit('change', ev);
        formItemContext.onFieldChange();
      }
      nextTick(function () {
        updatingValue.value = false;
      });
    };
    useProvideRadioGroupContext({
      onChange: onRadioChange,
      value: stateValue,
      disabled: computed(function () {
        return props.disabled;
      }),
      name: computed(function () {
        return props.name;
      }),
      optionType: computed(function () {
        return props.optionType;
      })
    });
    return function () {
      var _classNames;
      var _a;
      var options = props.options,
        buttonStyle = props.buttonStyle,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id;
      var groupPrefixCls = "".concat(prefixCls.value, "-group");
      var classString = classNames(groupPrefixCls, "".concat(groupPrefixCls, "-").concat(buttonStyle), (_classNames = {}, _defineProperty(_classNames, "".concat(groupPrefixCls, "-").concat(size.value), size.value), _defineProperty(_classNames, "".concat(groupPrefixCls, "-rtl"), direction.value === 'rtl'), _classNames), attrs.class, hashId.value);
      var children = null;
      if (options && options.length > 0) {
        children = options.map(function (option) {
          if (typeof option === 'string' || typeof option === 'number') {
            return _createVNode(Radio, {
              "key": option,
              "prefixCls": prefixCls.value,
              "disabled": props.disabled,
              "value": option,
              "checked": stateValue.value === option
            }, {
              default: function _default() {
                return [option];
              }
            });
          }
          var value = option.value,
            disabled = option.disabled,
            label = option.label;
          return _createVNode(Radio, {
            "key": "radio-group-value-options-".concat(value),
            "prefixCls": prefixCls.value,
            "disabled": disabled || props.disabled,
            "value": value,
            "checked": stateValue.value === value
          }, {
            default: function _default() {
              return [label];
            }
          });
        });
      } else {
        children = (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
      }
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": classString,
        "id": id
      }), [children]));
    };
  }
});