import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { mergeToken } from '../../theme/internal';
import { resetIcon } from '../../style';
var FIXED_ITEM_MARGIN = 2;
function getSelectItemStyle(_ref) {
  var controlHeightSM = _ref.controlHeightSM,
    controlHeight = _ref.controlHeight,
    borderWidth = _ref.lineWidth;
  var selectItemDist = (controlHeight - controlHeightSM) / 2 - borderWidth;
  var selectItemMargin = Math.ceil(selectItemDist / 2);
  return [selectItemDist, selectItemMargin];
}
function genSizeStyle(token, suffix) {
  var _$concat, _extends2, _$concat2, _$concat3, _$concat$concat2;
  var componentCls = token.componentCls,
    iconCls = token.iconCls;
  var selectOverflowPrefixCls = "".concat(componentCls, "-selection-overflow");
  var selectItemHeight = token.controlHeightSM;
  var _getSelectItemStyle = getSelectItemStyle(token),
    _getSelectItemStyle2 = _slicedToArray(_getSelectItemStyle, 1),
    selectItemDist = _getSelectItemStyle2[0];
  var suffixCls = suffix ? "".concat(componentCls, "-").concat(suffix) : '';
  return _defineProperty({}, "".concat(componentCls, "-multiple").concat(suffixCls), (_$concat$concat2 = {
    fontSize: token.fontSize
  }, _defineProperty(_$concat$concat2, selectOverflowPrefixCls, {
    position: 'relative',
    display: 'flex',
    flex: 'auto',
    flexWrap: 'wrap',
    maxWidth: '100%',
    '&-item': {
      flex: 'none',
      alignSelf: 'center',
      maxWidth: '100%',
      display: 'inline-flex'
    }
  }), _defineProperty(_$concat$concat2, "".concat(componentCls, "-selector"), (_$concat = {
    display: 'flex',
    flexWrap: 'wrap',
    alignItems: 'center',
    // Multiple is little different that horizontal is follow the vertical
    padding: "".concat(selectItemDist - FIXED_ITEM_MARGIN, "px ").concat(FIXED_ITEM_MARGIN * 2, "px"),
    borderRadius: token.borderRadius
  }, _defineProperty(_$concat, "".concat(componentCls, "-show-search&"), {
    cursor: 'text'
  }), _defineProperty(_$concat, "".concat(componentCls, "-disabled&"), {
    background: token.colorBgContainerDisabled,
    cursor: 'not-allowed'
  }), _defineProperty(_$concat, '&:after', {
    display: 'inline-block',
    width: 0,
    margin: "".concat(FIXED_ITEM_MARGIN, "px 0"),
    lineHeight: "".concat(selectItemHeight, "px"),
    content: '"\\a0"'
  }), _$concat)), _defineProperty(_$concat$concat2, "\n        &".concat(componentCls, "-show-arrow ").concat(componentCls, "-selector,\n        &").concat(componentCls, "-allow-clear ").concat(componentCls, "-selector\n      "), {
    paddingInlineEnd: token.fontSizeIcon + token.controlPaddingHorizontal
  }), _defineProperty(_$concat$concat2, "".concat(componentCls, "-selection-item"), (_$concat2 = {
    position: 'relative',
    display: 'flex',
    flex: 'none',
    boxSizing: 'border-box',
    maxWidth: '100%',
    height: selectItemHeight,
    marginTop: FIXED_ITEM_MARGIN,
    marginBottom: FIXED_ITEM_MARGIN,
    lineHeight: "".concat(selectItemHeight - token.lineWidth * 2, "px"),
    background: token.colorFillSecondary,
    border: "".concat(token.lineWidth, "px solid ").concat(token.colorSplit),
    borderRadius: token.borderRadiusSM,
    cursor: 'default',
    transition: "font-size ".concat(token.motionDurationSlow, ", line-height ").concat(token.motionDurationSlow, ", height ").concat(token.motionDurationSlow),
    userSelect: 'none',
    marginInlineEnd: FIXED_ITEM_MARGIN * 2,
    paddingInlineStart: token.paddingXS,
    paddingInlineEnd: token.paddingXS / 2
  }, _defineProperty(_$concat2, "".concat(componentCls, "-disabled&"), {
    color: token.colorTextDisabled,
    borderColor: token.colorBorder,
    cursor: 'not-allowed'
  }), _defineProperty(_$concat2, '&-content', {
    display: 'inline-block',
    marginInlineEnd: token.paddingXS / 2,
    overflow: 'hidden',
    whiteSpace: 'pre',
    textOverflow: 'ellipsis'
  }), _defineProperty(_$concat2, '&-remove', _extends(_extends({}, resetIcon()), (_extends2 = {
    display: 'inline-block',
    color: token.colorIcon,
    fontWeight: 'bold',
    fontSize: 10,
    lineHeight: 'inherit',
    cursor: 'pointer'
  }, _defineProperty(_extends2, "> ".concat(iconCls), {
    verticalAlign: '-0.2em'
  }), _defineProperty(_extends2, '&:hover', {
    color: token.colorIconHover
  }), _extends2))), _$concat2)), _defineProperty(_$concat$concat2, "".concat(selectOverflowPrefixCls, "-item + ").concat(selectOverflowPrefixCls, "-item"), _defineProperty({}, "".concat(componentCls, "-selection-search"), {
    marginInlineStart: 0
  })), _defineProperty(_$concat$concat2, "".concat(componentCls, "-selection-search"), (_$concat3 = {
    display: 'inline-flex',
    position: 'relative',
    maxWidth: '100%',
    marginInlineStart: token.inputPaddingHorizontalBase - selectItemDist
  }, _defineProperty(_$concat3, "\n          &-input,\n          &-mirror\n        ", {
    height: selectItemHeight,
    fontFamily: token.fontFamily,
    lineHeight: "".concat(selectItemHeight, "px"),
    transition: "all ".concat(token.motionDurationSlow)
  }), _defineProperty(_$concat3, '&-input', {
    width: '100%',
    minWidth: 4.1 // fix search cursor missing
  }), _defineProperty(_$concat3, '&-mirror', {
    position: 'absolute',
    top: 0,
    insetInlineStart: 0,
    insetInlineEnd: 'auto',
    zIndex: 999,
    whiteSpace: 'pre',
    visibility: 'hidden'
  }), _$concat3)), _defineProperty(_$concat$concat2, "".concat(componentCls, "-selection-placeholder "), {
    position: 'absolute',
    top: '50%',
    insetInlineStart: token.inputPaddingHorizontalBase,
    insetInlineEnd: token.inputPaddingHorizontalBase,
    transform: 'translateY(-50%)',
    transition: "all ".concat(token.motionDurationSlow)
  }), _$concat$concat2));
}
export default function genMultipleStyle(token) {
  var _$concat$concat3;
  var componentCls = token.componentCls;
  var smallToken = mergeToken(token, {
    controlHeight: token.controlHeightSM,
    controlHeightSM: token.controlHeightXS,
    borderRadius: token.borderRadiusSM,
    borderRadiusSM: token.borderRadiusXS
  });
  var _getSelectItemStyle3 = getSelectItemStyle(token),
    _getSelectItemStyle4 = _slicedToArray(_getSelectItemStyle3, 2),
    smSelectItemMargin = _getSelectItemStyle4[1];
  return [genSizeStyle(token),
  // ======================== Small ========================
  // Shared
  genSizeStyle(smallToken, 'sm'), // Padding
  _defineProperty({}, "".concat(componentCls, "-multiple").concat(componentCls, "-sm"), (_$concat$concat3 = {}, _defineProperty(_$concat$concat3, "".concat(componentCls, "-selection-placeholder"), {
    insetInlineStart: token.controlPaddingHorizontalSM - token.lineWidth,
    insetInlineEnd: 'auto'
  }), _defineProperty(_$concat$concat3, "".concat(componentCls, "-selection-search"), {
    marginInlineStart: smSelectItemMargin
  }), _$concat$concat3)),
  // ======================== Large ========================
  // Shared
  genSizeStyle(mergeToken(token, {
    fontSize: token.fontSizeLG,
    controlHeight: token.controlHeightLG,
    controlHeightSM: token.controlHeight,
    borderRadius: token.borderRadiusLG,
    borderRadiusSM: token.borderRadius
  }), 'lg')];
}