import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode } from "vue";
import { computed, defineComponent } from 'vue';
import classNames from '../_util/classNames';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { initDefaultProps } from '../_util/props-util';
import Element, { skeletonElementProps } from './Element';
import useStyle from './style';
export var skeletonButtonProps = function skeletonButtonProps() {
  return _extends(_extends({}, skeletonElementProps()), {
    size: String,
    block: Boolean
  });
};
var SkeletonButton = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ASkeletonButton',
  props: initDefaultProps(skeletonButtonProps(), {
    size: 'default'
  }),
  setup: function setup(props) {
    var _useConfigInject = useConfigInject('skeleton', props),
      prefixCls = _useConfigInject.prefixCls;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var cls = computed(function () {
      var _classNames;
      return classNames(prefixCls.value, "".concat(prefixCls.value, "-element"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-active"), props.active), _defineProperty(_classNames, "".concat(prefixCls.value, "-block"), props.block), _classNames), hashId.value);
    });
    return function () {
      return wrapSSR(_createVNode("div", {
        "class": cls.value
      }, [_createVNode(Element, _objectSpread(_objectSpread({}, props), {}, {
        "prefixCls": "".concat(prefixCls.value, "-button")
      }), null)]));
    };
  }
});
export default SkeletonButton;