import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { Keyframes } from '../../_util/cssinjs';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
var skeletonClsLoading = new Keyframes("ant-skeleton-loading", {
  '0%': {
    transform: 'translateX(-37.5%)'
  },
  '100%': {
    transform: 'translateX(37.5%)'
  }
});
var genSkeletonElementCommonSize = function genSkeletonElementCommonSize(size) {
  return {
    height: size,
    lineHeight: "".concat(size, "px")
  };
};
var genSkeletonElementAvatarSize = function genSkeletonElementAvatarSize(size) {
  return _extends({
    width: size
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonColor = function genSkeletonColor(token) {
  return {
    position: 'relative',
    // fix https://github.com/ant-design/ant-design/issues/36444
    // https://monshin.github.io/202109/css/safari-border-radius-overflow-hidden/
    /* stylelint-disable-next-line property-no-vendor-prefix,value-no-vendor-prefix */
    zIndex: 0,
    overflow: 'hidden',
    background: 'transparent',
    '&::after': {
      position: 'absolute',
      top: 0,
      insetInlineEnd: '-150%',
      bottom: 0,
      insetInlineStart: '-150%',
      background: token.skeletonLoadingBackground,
      animationName: skeletonClsLoading,
      animationDuration: token.skeletonLoadingMotionDuration,
      animationTimingFunction: 'ease',
      animationIterationCount: 'infinite',
      content: '""'
    }
  };
};
var genSkeletonElementInputSize = function genSkeletonElementInputSize(size) {
  return _extends({
    width: size * 5,
    minWidth: size * 5
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonElementAvatar = function genSkeletonElementAvatar(token) {
  var _ref;
  var skeletonAvatarCls = token.skeletonAvatarCls,
    color = token.color,
    controlHeight = token.controlHeight,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM;
  return _ref = {}, _defineProperty(_ref, "".concat(skeletonAvatarCls), _extends({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color
  }, genSkeletonElementAvatarSize(controlHeight))), _defineProperty(_ref, "".concat(skeletonAvatarCls).concat(skeletonAvatarCls, "-circle"), {
    borderRadius: '50%'
  }), _defineProperty(_ref, "".concat(skeletonAvatarCls).concat(skeletonAvatarCls, "-lg"), _extends({}, genSkeletonElementAvatarSize(controlHeightLG))), _defineProperty(_ref, "".concat(skeletonAvatarCls).concat(skeletonAvatarCls, "-sm"), _extends({}, genSkeletonElementAvatarSize(controlHeightSM))), _ref;
};
var genSkeletonElementInput = function genSkeletonElementInput(token) {
  var _ref2;
  var controlHeight = token.controlHeight,
    borderRadiusSM = token.borderRadiusSM,
    skeletonInputCls = token.skeletonInputCls,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM,
    color = token.color;
  return _ref2 = {}, _defineProperty(_ref2, "".concat(skeletonInputCls), _extends({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color,
    borderRadius: borderRadiusSM
  }, genSkeletonElementInputSize(controlHeight))), _defineProperty(_ref2, "".concat(skeletonInputCls, "-lg"), _extends({}, genSkeletonElementInputSize(controlHeightLG))), _defineProperty(_ref2, "".concat(skeletonInputCls, "-sm"), _extends({}, genSkeletonElementInputSize(controlHeightSM))), _ref2;
};
var genSkeletonElementImageSize = function genSkeletonElementImageSize(size) {
  return _extends({
    width: size
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonElementImage = function genSkeletonElementImage(token) {
  var _extends2, _ref3;
  var skeletonImageCls = token.skeletonImageCls,
    imageSizeBase = token.imageSizeBase,
    color = token.color,
    borderRadiusSM = token.borderRadiusSM;
  return _ref3 = {}, _defineProperty(_ref3, "".concat(skeletonImageCls), _extends(_extends({
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    verticalAlign: 'top',
    background: color,
    borderRadius: borderRadiusSM
  }, genSkeletonElementImageSize(imageSizeBase * 2)), (_extends2 = {}, _defineProperty(_extends2, "".concat(skeletonImageCls, "-path"), {
    fill: '#bfbfbf'
  }), _defineProperty(_extends2, "".concat(skeletonImageCls, "-svg"), _extends(_extends({}, genSkeletonElementImageSize(imageSizeBase)), {
    maxWidth: imageSizeBase * 4,
    maxHeight: imageSizeBase * 4
  })), _defineProperty(_extends2, "".concat(skeletonImageCls, "-svg").concat(skeletonImageCls, "-svg-circle"), {
    borderRadius: '50%'
  }), _extends2))), _defineProperty(_ref3, "".concat(skeletonImageCls).concat(skeletonImageCls, "-circle"), {
    borderRadius: '50%'
  }), _ref3;
};
var genSkeletonElementButtonShape = function genSkeletonElementButtonShape(token, size, buttonCls) {
  var _ref4;
  var skeletonButtonCls = token.skeletonButtonCls;
  return _ref4 = {}, _defineProperty(_ref4, "".concat(buttonCls).concat(skeletonButtonCls, "-circle"), {
    width: size,
    minWidth: size,
    borderRadius: '50%'
  }), _defineProperty(_ref4, "".concat(buttonCls).concat(skeletonButtonCls, "-round"), {
    borderRadius: size
  }), _ref4;
};
var genSkeletonElementButtonSize = function genSkeletonElementButtonSize(size) {
  return _extends({
    width: size * 2,
    minWidth: size * 2
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonElementButton = function genSkeletonElementButton(token) {
  var borderRadiusSM = token.borderRadiusSM,
    skeletonButtonCls = token.skeletonButtonCls,
    controlHeight = token.controlHeight,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM,
    color = token.color;
  return _extends(_extends(_extends(_extends(_extends(_defineProperty({}, "".concat(skeletonButtonCls), _extends({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color,
    borderRadius: borderRadiusSM,
    width: controlHeight * 2,
    minWidth: controlHeight * 2
  }, genSkeletonElementButtonSize(controlHeight))), genSkeletonElementButtonShape(token, controlHeight, skeletonButtonCls)), _defineProperty({}, "".concat(skeletonButtonCls, "-lg"), _extends({}, genSkeletonElementButtonSize(controlHeightLG)))), genSkeletonElementButtonShape(token, controlHeightLG, "".concat(skeletonButtonCls, "-lg"))), _defineProperty({}, "".concat(skeletonButtonCls, "-sm"), _extends({}, genSkeletonElementButtonSize(controlHeightSM)))), genSkeletonElementButtonShape(token, controlHeightSM, "".concat(skeletonButtonCls, "-sm")));
};
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _$concat, _$concat3, _$concat4, _$concat$concat2, _ref5;
  var componentCls = token.componentCls,
    skeletonAvatarCls = token.skeletonAvatarCls,
    skeletonTitleCls = token.skeletonTitleCls,
    skeletonParagraphCls = token.skeletonParagraphCls,
    skeletonButtonCls = token.skeletonButtonCls,
    skeletonInputCls = token.skeletonInputCls,
    skeletonImageCls = token.skeletonImageCls,
    controlHeight = token.controlHeight,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM,
    color = token.color,
    padding = token.padding,
    marginSM = token.marginSM,
    borderRadius = token.borderRadius,
    skeletonTitleHeight = token.skeletonTitleHeight,
    skeletonBlockRadius = token.skeletonBlockRadius,
    skeletonParagraphLineHeight = token.skeletonParagraphLineHeight,
    controlHeightXS = token.controlHeightXS,
    skeletonParagraphMarginTop = token.skeletonParagraphMarginTop;
  return _ref5 = {}, _defineProperty(_ref5, "".concat(componentCls), (_$concat4 = {
    display: 'table',
    width: '100%'
  }, _defineProperty(_$concat4, "".concat(componentCls, "-header"), (_$concat = {
    display: 'table-cell',
    paddingInlineEnd: padding,
    verticalAlign: 'top'
  }, _defineProperty(_$concat, "".concat(skeletonAvatarCls), _extends({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color
  }, genSkeletonElementAvatarSize(controlHeight))), _defineProperty(_$concat, "".concat(skeletonAvatarCls, "-circle"), {
    borderRadius: '50%'
  }), _defineProperty(_$concat, "".concat(skeletonAvatarCls, "-lg"), _extends({}, genSkeletonElementAvatarSize(controlHeightLG))), _defineProperty(_$concat, "".concat(skeletonAvatarCls, "-sm"), _extends({}, genSkeletonElementAvatarSize(controlHeightSM))), _$concat)), _defineProperty(_$concat4, "".concat(componentCls, "-content"), (_$concat3 = {
    display: 'table-cell',
    width: '100%',
    verticalAlign: 'top'
  }, _defineProperty(_$concat3, "".concat(skeletonTitleCls), _defineProperty({
    width: '100%',
    height: skeletonTitleHeight,
    background: color,
    borderRadius: skeletonBlockRadius
  }, "+ ".concat(skeletonParagraphCls), {
    marginBlockStart: controlHeightSM
  })), _defineProperty(_$concat3, "".concat(skeletonParagraphCls), {
    padding: 0,
    '> li': {
      width: '100%',
      height: skeletonParagraphLineHeight,
      listStyle: 'none',
      background: color,
      borderRadius: skeletonBlockRadius,
      '+ li': {
        marginBlockStart: controlHeightXS
      }
    }
  }), _defineProperty(_$concat3, "".concat(skeletonParagraphCls, "> li:last-child:not(:first-child):not(:nth-child(2))"), {
    width: '61%'
  }), _$concat3)), _defineProperty(_$concat4, "&-round ".concat(componentCls, "-content"), _defineProperty({}, "".concat(skeletonTitleCls, ", ").concat(skeletonParagraphCls, " > li"), {
    borderRadius: borderRadius
  })), _$concat4)), _defineProperty(_ref5, "".concat(componentCls, "-with-avatar ").concat(componentCls, "-content"), _defineProperty({}, "".concat(skeletonTitleCls), _defineProperty({
    marginBlockStart: marginSM
  }, "+ ".concat(skeletonParagraphCls), {
    marginBlockStart: skeletonParagraphMarginTop
  }))), _defineProperty(_ref5, "".concat(componentCls).concat(componentCls, "-element"), _extends(_extends(_extends(_extends({
    display: 'inline-block',
    width: 'auto'
  }, genSkeletonElementButton(token)), genSkeletonElementAvatar(token)), genSkeletonElementInput(token)), genSkeletonElementImage(token))), _defineProperty(_ref5, "".concat(componentCls).concat(componentCls, "-block"), (_$concat$concat2 = {
    width: '100%'
  }, _defineProperty(_$concat$concat2, "".concat(skeletonButtonCls), {
    width: '100%'
  }), _defineProperty(_$concat$concat2, "".concat(skeletonInputCls), {
    width: '100%'
  }), _$concat$concat2)), _defineProperty(_ref5, "".concat(componentCls).concat(componentCls, "-active"), _defineProperty({}, "\n        ".concat(skeletonTitleCls, ",\n        ").concat(skeletonParagraphCls, " > li,\n        ").concat(skeletonAvatarCls, ",\n        ").concat(skeletonButtonCls, ",\n        ").concat(skeletonInputCls, ",\n        ").concat(skeletonImageCls, "\n      "), _extends({}, genSkeletonColor(token)))), _ref5;
};
// ============================== Export ==============================
export default genComponentStyleHook('Skeleton', function (token) {
  var componentCls = token.componentCls;
  var skeletonToken = mergeToken(token, {
    skeletonAvatarCls: "".concat(componentCls, "-avatar"),
    skeletonTitleCls: "".concat(componentCls, "-title"),
    skeletonParagraphCls: "".concat(componentCls, "-paragraph"),
    skeletonButtonCls: "".concat(componentCls, "-button"),
    skeletonInputCls: "".concat(componentCls, "-input"),
    skeletonImageCls: "".concat(componentCls, "-image"),
    imageSizeBase: token.controlHeight * 1.5,
    skeletonTitleHeight: token.controlHeight / 2,
    skeletonBlockRadius: token.borderRadiusSM,
    skeletonParagraphLineHeight: token.controlHeight / 2,
    skeletonParagraphMarginTop: token.marginLG + token.marginXXS,
    borderRadius: 100,
    skeletonLoadingBackground: "linear-gradient(90deg, ".concat(token.color, " 25%, ").concat(token.colorGradientEnd, " 37%, ").concat(token.color, " 63%)"),
    skeletonLoadingMotionDuration: '1.4s'
  });
  return [genBaseStyle(skeletonToken)];
}, function (token) {
  var colorFillContent = token.colorFillContent,
    colorFill = token.colorFill;
  return {
    color: colorFillContent,
    colorGradientEnd: colorFill
  };
});