import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { createVNode as _createVNode } from "vue";
import classNames from '../_util/classNames';
import createContext from '../_util/createContext';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useStyle from './style';
import { computed, defineComponent } from 'vue';
import PropTypes from '../_util/vue-types';
import { booleanType, tuple } from '../_util/type';
import { isEmpty } from 'lodash-es';
import { flattenChildren } from '../_util/props-util';
export var spaceCompactItemProps = function spaceCompactItemProps() {
  return {
    compactSize: String,
    compactDirection: PropTypes.oneOf(tuple('horizontal', 'vertical')).def('horizontal'),
    isFirstItem: booleanType(),
    isLastItem: booleanType()
  };
};
export var SpaceCompactItemContext = createContext(null);
export var useCompactItemContext = function useCompactItemContext(prefixCls, direction) {
  var compactItemContext = SpaceCompactItemContext.useInject();
  var compactItemClassnames = computed(function () {
    var _classNames;
    if (!compactItemContext || isEmpty(compactItemContext)) return '';
    var compactDirection = compactItemContext.compactDirection,
      isFirstItem = compactItemContext.isFirstItem,
      isLastItem = compactItemContext.isLastItem;
    var separator = compactDirection === 'vertical' ? '-vertical-' : '-';
    return classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "item"), true), _defineProperty(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "first-item"), isFirstItem), _defineProperty(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "last-item"), isLastItem), _defineProperty(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "item-rtl"), direction.value === 'rtl'), _classNames));
  });
  return {
    compactSize: computed(function () {
      return compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.compactSize;
    }),
    compactDirection: computed(function () {
      return compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.compactDirection;
    }),
    compactItemClassnames: compactItemClassnames
  };
};
export var NoCompactStyle = defineComponent({
  name: 'NoCompactStyle',
  setup: function setup(_, _ref) {
    var slots = _ref.slots;
    SpaceCompactItemContext.useProvide(null);
    return function () {
      var _a;
      return (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
    };
  }
});
export var spaceCompactProps = function spaceCompactProps() {
  return {
    prefixCls: String,
    size: {
      type: String
    },
    direction: PropTypes.oneOf(tuple('horizontal', 'vertical')).def('horizontal'),
    align: PropTypes.oneOf(tuple('start', 'end', 'center', 'baseline')),
    block: {
      type: Boolean,
      default: undefined
    }
  };
};
var CompactItem = defineComponent({
  name: 'CompactItem',
  props: spaceCompactItemProps(),
  setup: function setup(props, _ref2) {
    var slots = _ref2.slots;
    SpaceCompactItemContext.useProvide(props);
    return function () {
      var _a;
      return (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
    };
  }
});
var Compact = defineComponent({
  name: 'ASpaceCompact',
  inheritAttrs: false,
  props: spaceCompactProps(),
  setup: function setup(props, _ref3) {
    var attrs = _ref3.attrs,
      slots = _ref3.slots;
    var _useConfigInject = useConfigInject('space-compact', props),
      prefixCls = _useConfigInject.prefixCls,
      directionConfig = _useConfigInject.direction;
    var compactItemContext = SpaceCompactItemContext.useInject();
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var clx = computed(function () {
      var _classNames2;
      return classNames(prefixCls.value, hashId.value, (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls.value, "-rtl"), directionConfig.value === 'rtl'), _defineProperty(_classNames2, "".concat(prefixCls.value, "-block"), props.block), _defineProperty(_classNames2, "".concat(prefixCls.value, "-vertical"), props.direction === 'vertical'), _classNames2));
    });
    return function () {
      var _a;
      var childNodes = flattenChildren(((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) || []);
      // =========================== Render ===========================
      if (childNodes.length === 0) {
        return null;
      }
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": [clx.value, attrs.class]
      }), [childNodes.map(function (child, i) {
        var _a;
        var key = child && child.key || "".concat(prefixCls.value, "-item-").concat(i);
        var noCompactItemContext = !compactItemContext || isEmpty(compactItemContext);
        return _createVNode(CompactItem, {
          "key": key,
          "compactSize": (_a = props.size) !== null && _a !== void 0 ? _a : 'middle',
          "compactDirection": props.direction,
          "isFirstItem": i === 0 && (noCompactItemContext || (compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.isFirstItem)),
          "isLastItem": i === childNodes.length - 1 && (noCompactItemContext || (compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.isLastItem))
        }, {
          default: function _default() {
            return [child];
          }
        });
      })]));
    };
  }
});
export default Compact;