import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { computed, defineComponent } from 'vue';
import CloseOutlined from "@ant-design/icons-vue/es/icons/CloseOutlined";
import CheckOutlined from "@ant-design/icons-vue/es/icons/CheckOutlined";
import { anyType, booleanType, stringType, functionType, someType, arrayType } from '../_util/type';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import VcSteps, { Step as VcStep } from '../vc-steps';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useBreakpoint from '../_util/hooks/useBreakpoint';
import classNames from '../_util/classNames';
import Progress from '../progress';
import omit from '../_util/omit';
import Tooltip from '../tooltip';
import { VcStepProps } from '../vc-steps/Step';
// CSSINJS
import useStyle from './style';
export var stepsProps = function stepsProps() {
  return {
    prefixCls: String,
    iconPrefix: String,
    current: Number,
    initial: Number,
    percent: Number,
    responsive: booleanType(),
    items: arrayType(),
    labelPlacement: stringType(),
    status: stringType(),
    size: stringType(),
    direction: stringType(),
    progressDot: someType([Boolean, Function]),
    type: stringType(),
    onChange: functionType(),
    'onUpdate:current': functionType()
  };
};
export var stepProps = function stepProps() {
  return {
    description: anyType(),
    icon: anyType(),
    status: stringType(),
    disabled: booleanType(),
    title: anyType(),
    subTitle: anyType(),
    onClick: functionType()
  };
};
var Steps = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ASteps',
  inheritAttrs: false,
  props: initDefaultProps(stepsProps(), {
    current: 0,
    responsive: true,
    labelPlacement: 'horizontal'
  }),
  slots: ['progressDot'],
  // emits: ['update:current', 'change'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots,
      emit = _ref.emit;
    var _useConfigInject = useConfigInject('steps', props),
      prefixCls = _useConfigInject.prefixCls,
      rtlDirection = _useConfigInject.direction,
      configProvider = _useConfigInject.configProvider;
    // style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var screens = useBreakpoint();
    var direction = computed(function () {
      return props.responsive && screens.value.xs ? 'vertical' : props.direction;
    });
    var iconPrefix = computed(function () {
      return configProvider.getPrefixCls('', props.iconPrefix);
    });
    var handleChange = function handleChange(current) {
      emit('update:current', current);
      emit('change', current);
    };
    var isInline = computed(function () {
      return props.type === 'inline';
    });
    var mergedPercent = computed(function () {
      return isInline.value ? undefined : props.percent;
    });
    var stepIconRender = function stepIconRender(_ref2) {
      var node = _ref2.node,
        status = _ref2.status;
      if (status === 'process' && props.percent !== undefined) {
        // currently it's hard-coded, since we can't easily read the actually width of icon
        var progressWidth = props.size === 'small' ? 32 : 40;
        var iconWithProgress = _createVNode("div", {
          "class": "".concat(prefixCls.value, "-progress-icon")
        }, [_createVNode(Progress, {
          "type": "circle",
          "percent": mergedPercent.value,
          "size": progressWidth,
          "strokeWidth": 4,
          "format": function format() {
            return null;
          }
        }, null), node]);
        return iconWithProgress;
      }
      return node;
    };
    var icons = computed(function () {
      return {
        finish: _createVNode(CheckOutlined, {
          "class": "".concat(prefixCls.value, "-finish-icon")
        }, null),
        error: _createVNode(CloseOutlined, {
          "class": "".concat(prefixCls.value, "-error-icon")
        }, null)
      };
    });
    return function () {
      var _classNames;
      var stepsClassName = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-rtl"), rtlDirection.value === 'rtl'), _defineProperty(_classNames, "".concat(prefixCls.value, "-with-progress"), mergedPercent.value !== undefined), _classNames), attrs.class, hashId.value);
      var itemRender = function itemRender(item, stepItem) {
        return item.description ? _createVNode(Tooltip, {
          "title": item.description
        }, {
          default: function _default() {
            return [stepItem];
          }
        }) : stepItem;
      };
      return wrapSSR(_createVNode(VcSteps, _objectSpread(_objectSpread(_objectSpread({
        "icons": icons.value
      }, attrs), omit(props, ['percent', 'responsive'])), {}, {
        "items": props.items,
        "direction": direction.value,
        "prefixCls": prefixCls.value,
        "iconPrefix": iconPrefix.value,
        "class": stepsClassName,
        "onChange": handleChange,
        "isInline": isInline.value,
        "itemRender": isInline.value ? itemRender : undefined
      }), _extends({
        stepIcon: stepIconRender
      }, slots)));
    };
  }
});
/* istanbul ignore next */
export var Step = defineComponent(_extends(_extends({
  compatConfig: {
    MODE: 3
  }
}, VcStep), {
  name: 'AStep',
  props: VcStepProps()
}));
export default _extends(Steps, {
  Step: Step,
  install: function install(app) {
    app.component(Steps.name, Steps);
    app.component(Step.name, Step);
    return app;
  }
});