import _extends from "@babel/runtime/helpers/esm/extends";
import { PresetColors } from '../theme/internal';
export function genPresetColor(token, genCss) {
  return PresetColors.reduce(function (prev, colorKey) {
    var lightColor = token["".concat(colorKey, "-1")];
    var lightBorderColor = token["".concat(colorKey, "-3")];
    var darkColor = token["".concat(colorKey, "-6")];
    var textColor = token["".concat(colorKey, "-7")];
    return _extends(_extends({}, prev), genCss(colorKey, {
      lightColor: lightColor,
      lightBorderColor: lightBorderColor,
      darkColor: darkColor,
      textColor: textColor
    }));
  }, {});
}