import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { resetComponent } from '../../style';
var genFilterStyle = function genFilterStyle(token) {
  var _$concat, _$concat2, _extends2, _$concat$concat$conca;
  var componentCls = token.componentCls,
    antCls = token.antCls,
    iconCls = token.iconCls,
    tableFilterDropdownWidth = token.tableFilterDropdownWidth,
    tableFilterDropdownSearchWidth = token.tableFilterDropdownSearchWidth,
    paddingXXS = token.paddingXXS,
    paddingXS = token.paddingXS,
    colorText = token.colorText,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    tableBorderColor = token.tableBorderColor,
    tableHeaderIconColor = token.tableHeaderIconColor,
    fontSizeSM = token.fontSizeSM,
    tablePaddingHorizontal = token.tablePaddingHorizontal,
    borderRadius = token.borderRadius,
    motionDurationSlow = token.motionDurationSlow,
    colorTextDescription = token.colorTextDescription,
    colorPrimary = token.colorPrimary,
    tableHeaderFilterActiveBg = token.tableHeaderFilterActiveBg,
    colorTextDisabled = token.colorTextDisabled,
    tableFilterDropdownBg = token.tableFilterDropdownBg,
    tableFilterDropdownHeight = token.tableFilterDropdownHeight,
    controlItemBgHover = token.controlItemBgHover,
    controlItemBgActive = token.controlItemBgActive,
    boxShadowSecondary = token.boxShadowSecondary;
  var dropdownPrefixCls = "".concat(antCls, "-dropdown");
  var tableFilterDropdownPrefixCls = "".concat(componentCls, "-filter-dropdown");
  var treePrefixCls = "".concat(antCls, "-tree");
  var tableBorder = "".concat(lineWidth, "px ").concat(lineType, " ").concat(tableBorderColor);
  return [_defineProperty({}, "".concat(componentCls, "-wrapper"), (_$concat = {}, _defineProperty(_$concat, "".concat(componentCls, "-filter-column"), {
    display: 'flex',
    justifyContent: 'space-between'
  }), _defineProperty(_$concat, "".concat(componentCls, "-filter-trigger"), {
    position: 'relative',
    display: 'flex',
    alignItems: 'center',
    marginBlock: -paddingXXS,
    marginInline: "".concat(paddingXXS, "px ").concat(-tablePaddingHorizontal / 2, "px"),
    padding: "0 ".concat(paddingXXS, "px"),
    color: tableHeaderIconColor,
    fontSize: fontSizeSM,
    borderRadius: borderRadius,
    cursor: 'pointer',
    transition: "all ".concat(motionDurationSlow),
    '&:hover': {
      color: colorTextDescription,
      background: tableHeaderFilterActiveBg
    },
    '&.active': {
      color: colorPrimary
    }
  }), _$concat)), _defineProperty({}, "".concat(antCls, "-dropdown"), _defineProperty({}, tableFilterDropdownPrefixCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    minWidth: tableFilterDropdownWidth,
    backgroundColor: tableFilterDropdownBg,
    borderRadius: borderRadius,
    boxShadow: boxShadowSecondary
  }, _defineProperty(_extends2, "".concat(dropdownPrefixCls, "-menu"), {
    // https://github.com/ant-design/ant-design/issues/4916
    // https://github.com/ant-design/ant-design/issues/19542
    maxHeight: tableFilterDropdownHeight,
    overflowX: 'hidden',
    border: 0,
    boxShadow: 'none',
    '&:empty::after': {
      display: 'block',
      padding: "".concat(paddingXS, "px 0"),
      color: colorTextDisabled,
      fontSize: fontSizeSM,
      textAlign: 'center',
      content: '"Not Found"'
    }
  }), _defineProperty(_extends2, "".concat(tableFilterDropdownPrefixCls, "-tree"), (_$concat2 = {
    paddingBlock: "".concat(paddingXS, "px 0"),
    paddingInline: paddingXS
  }, _defineProperty(_$concat2, treePrefixCls, {
    padding: 0
  }), _defineProperty(_$concat2, "".concat(treePrefixCls, "-treenode ").concat(treePrefixCls, "-node-content-wrapper:hover"), {
    backgroundColor: controlItemBgHover
  }), _defineProperty(_$concat2, "".concat(treePrefixCls, "-treenode-checkbox-checked ").concat(treePrefixCls, "-node-content-wrapper"), {
    '&, &:hover': {
      backgroundColor: controlItemBgActive
    }
  }), _$concat2)), _defineProperty(_extends2, "".concat(tableFilterDropdownPrefixCls, "-search"), {
    padding: paddingXS,
    borderBottom: tableBorder,
    '&-input': _defineProperty({
      input: {
        minWidth: tableFilterDropdownSearchWidth
      }
    }, iconCls, {
      color: colorTextDisabled
    })
  }), _defineProperty(_extends2, "".concat(tableFilterDropdownPrefixCls, "-checkall"), {
    width: '100%',
    marginBottom: paddingXXS,
    marginInlineStart: paddingXXS
  }), _defineProperty(_extends2, "".concat(tableFilterDropdownPrefixCls, "-btns"), {
    display: 'flex',
    justifyContent: 'space-between',
    padding: "".concat(paddingXS - lineWidth, "px ").concat(paddingXS, "px"),
    overflow: 'hidden',
    backgroundColor: 'inherit',
    borderTop: tableBorder
  }), _extends2)))), // Dropdown Menu & SubMenu
  _defineProperty({}, "".concat(antCls, "-dropdown ").concat(tableFilterDropdownPrefixCls, ", ").concat(tableFilterDropdownPrefixCls, "-submenu"), (_$concat$concat$conca = {}, _defineProperty(_$concat$concat$conca, "".concat(antCls, "-checkbox-wrapper + span"), {
    paddingInlineStart: paddingXS,
    color: colorText
  }), _defineProperty(_$concat$concat$conca, "> ul", {
    maxHeight: 'calc(100vh - 130px)',
    overflowX: 'hidden',
    overflowY: 'auto'
  }), _$concat$concat$conca))];
};
export default genFilterStyle;