import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { Fragment as _Fragment, createVNode as _createVNode } from "vue";
import { shallowRef, defineComponent, watchEffect, computed } from 'vue';
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import CloseOutlined from "@ant-design/icons-vue/es/icons/CloseOutlined";
import Wave from '../_util/wave';
import { isPresetColor, isPresetStatusColor } from '../_util/colors';
import { eventType } from '../_util/type';
import CheckableTag from './CheckableTag';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import warning from '../_util/warning';
import useStyle from './style';
export var tagProps = function tagProps() {
  return {
    prefixCls: String,
    color: {
      type: String
    },
    closable: {
      type: Boolean,
      default: false
    },
    closeIcon: PropTypes.any,
    /** @deprecated `visible` will be removed in next major version. */
    visible: {
      type: Boolean,
      default: undefined
    },
    onClose: {
      type: Function
    },
    onClick: eventType(),
    'onUpdate:visible': Function,
    icon: PropTypes.any
  };
};
var Tag = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ATag',
  inheritAttrs: false,
  props: tagProps(),
  // emits: ['update:visible', 'close'],
  slots: ['closeIcon', 'icon'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('tag', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var visible = shallowRef(true);
    // Warning for deprecated usage
    if (process.env.NODE_ENV !== 'production') {
      warning(props.visible === undefined, 'Tag', '`visible` is deprecated, please use `<Tag v-show="visible" />` instead.');
    }
    watchEffect(function () {
      if (props.visible !== undefined) {
        visible.value = props.visible;
      }
    });
    var handleCloseClick = function handleCloseClick(e) {
      e.stopPropagation();
      emit('update:visible', false);
      emit('close', e);
      if (e.defaultPrevented) {
        return;
      }
      if (props.visible === undefined) {
        visible.value = false;
      }
    };
    // const isPresetColor = computed(() => {
    //   const { color } = props;
    //   if (!color) {
    //     return false;
    //   }
    //   return PresetColorRegex.test(color) || PresetStatusColorRegex.test(color);
    // });
    var isInternalColor = computed(function () {
      return isPresetColor(props.color) || isPresetStatusColor(props.color);
    });
    var tagClassName = computed(function () {
      var _classNames;
      return classNames(prefixCls.value, hashId.value, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-").concat(props.color), isInternalColor.value), _defineProperty(_classNames, "".concat(prefixCls.value, "-has-color"), props.color && !isInternalColor.value), _defineProperty(_classNames, "".concat(prefixCls.value, "-hidden"), !visible.value), _defineProperty(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _classNames));
    });
    var handleClick = function handleClick(e) {
      emit('click', e);
    };
    return function () {
      var _a, _b, _c;
      var _props$icon = props.icon,
        icon = _props$icon === void 0 ? (_a = slots.icon) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$icon,
        color = props.color,
        _props$closeIcon = props.closeIcon,
        closeIcon = _props$closeIcon === void 0 ? (_b = slots.closeIcon) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$closeIcon,
        _props$closable = props.closable,
        closable = _props$closable === void 0 ? false : _props$closable;
      var renderCloseIcon = function renderCloseIcon() {
        if (closable) {
          return closeIcon ? _createVNode("span", {
            "class": "".concat(prefixCls.value, "-close-icon"),
            "onClick": handleCloseClick
          }, [closeIcon]) : _createVNode(CloseOutlined, {
            "class": "".concat(prefixCls.value, "-close-icon"),
            "onClick": handleCloseClick
          }, null);
        }
        return null;
      };
      var tagStyle = {
        backgroundColor: color && !isInternalColor.value ? color : undefined
      };
      var iconNode = icon || null;
      var children = (_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots);
      var kids = iconNode ? _createVNode(_Fragment, null, [iconNode, _createVNode("span", null, [children])]) : children;
      var isNeedWave = props.onClick !== undefined;
      var tagNode = _createVNode("span", _objectSpread(_objectSpread({}, attrs), {}, {
        "onClick": handleClick,
        "class": [tagClassName.value, attrs.class],
        "style": [tagStyle, attrs.style]
      }), [kids, renderCloseIcon()]);
      return wrapSSR(isNeedWave ? _createVNode(Wave, null, {
        default: function _default() {
          return [tagNode];
        }
      }) : tagNode);
    };
  }
});
Tag.CheckableTag = CheckableTag;
Tag.install = function (app) {
  app.component(Tag.name, Tag);
  app.component(CheckableTag.name, CheckableTag);
  return app;
};
export { CheckableTag };
export default Tag;