import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { genPresetColor, resetComponent } from '../../style';
import { capitalize } from '../../_util/util';
var genTagStatusStyle = function genTagStatusStyle(token, status, cssVariableType) {
  var capitalizedCssVariableType = capitalize(cssVariableType);
  return _defineProperty({}, "".concat(token.componentCls, "-").concat(status), {
    color: token["color".concat(cssVariableType)],
    background: token["color".concat(capitalizedCssVariableType, "Bg")],
    borderColor: token["color".concat(capitalizedCssVariableType, "Border")]
  });
};
var genPresetStyle = function genPresetStyle(token) {
  return genPresetColor(token, function (colorKey, _ref2) {
    var textColor = _ref2.textColor,
      lightBorderColor = _ref2.lightBorderColor,
      lightColor = _ref2.lightColor,
      darkColor = _ref2.darkColor;
    return _defineProperty({}, "".concat(token.componentCls, "-").concat(colorKey), {
      color: textColor,
      background: lightColor,
      borderColor: lightBorderColor,
      // Inverse color
      '&-inverse': {
        color: token.colorTextLightSolid,
        background: darkColor,
        borderColor: darkColor
      }
    });
  });
};
var genBaseStyle = function genBaseStyle(token) {
  var _checkable, _extends2;
  var paddingXXS = token.paddingXXS,
    lineWidth = token.lineWidth,
    tagPaddingHorizontal = token.tagPaddingHorizontal,
    componentCls = token.componentCls;
  var paddingInline = tagPaddingHorizontal - lineWidth;
  var iconMarginInline = paddingXXS - lineWidth;
  return _defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    display: 'inline-block',
    height: 'auto',
    marginInlineEnd: token.marginXS,
    paddingInline: paddingInline,
    fontSize: token.tagFontSize,
    lineHeight: "".concat(token.tagLineHeight, "px"),
    whiteSpace: 'nowrap',
    background: token.tagDefaultBg,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    borderRadius: token.borderRadiusSM,
    opacity: 1,
    transition: "all ".concat(token.motionDurationMid),
    textAlign: 'start'
  }, _defineProperty(_extends2, "&".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }), _defineProperty(_extends2, '&, a, a:hover', {
    color: token.tagDefaultColor
  }), _defineProperty(_extends2, "".concat(componentCls, "-close-icon"), {
    marginInlineStart: iconMarginInline,
    color: token.colorTextDescription,
    fontSize: token.tagIconSize,
    cursor: 'pointer',
    transition: "all ".concat(token.motionDurationMid),
    '&:hover': {
      color: token.colorTextHeading
    }
  }), _defineProperty(_extends2, "&".concat(componentCls, "-has-color"), _defineProperty({
    borderColor: 'transparent'
  }, "&, a, a:hover, ".concat(token.iconCls, "-close, ").concat(token.iconCls, "-close:hover"), {
    color: token.colorTextLightSolid
  })), _defineProperty(_extends2, "&-checkable", (_checkable = {
    backgroundColor: 'transparent',
    borderColor: 'transparent',
    cursor: 'pointer'
  }, _defineProperty(_checkable, "&:not(".concat(componentCls, "-checkable-checked):hover"), {
    color: token.colorPrimary,
    backgroundColor: token.colorFillSecondary
  }), _defineProperty(_checkable, '&:active, &-checked', {
    color: token.colorTextLightSolid
  }), _defineProperty(_checkable, '&-checked', {
    backgroundColor: token.colorPrimary,
    '&:hover': {
      backgroundColor: token.colorPrimaryHover
    }
  }), _defineProperty(_checkable, '&:active', {
    backgroundColor: token.colorPrimaryActive
  }), _checkable)), _defineProperty(_extends2, "&-hidden", {
    display: 'none'
  }), _defineProperty(_extends2, "> ".concat(token.iconCls, " + span, > span + ").concat(token.iconCls), {
    marginInlineStart: paddingInline
  }), _extends2)));
};
// ============================== Export ==============================
export default genComponentStyleHook('Tag', function (token) {
  var fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    lineWidth = token.lineWidth,
    fontSizeIcon = token.fontSizeIcon;
  var tagHeight = Math.round(fontSize * lineHeight);
  var tagFontSize = token.fontSizeSM;
  var tagLineHeight = tagHeight - lineWidth * 2;
  var tagDefaultBg = token.colorFillAlter;
  var tagDefaultColor = token.colorText;
  var tagToken = mergeToken(token, {
    tagFontSize: tagFontSize,
    tagLineHeight: tagLineHeight,
    tagDefaultBg: tagDefaultBg,
    tagDefaultColor: tagDefaultColor,
    tagIconSize: fontSizeIcon - 2 * lineWidth,
    tagPaddingHorizontal: 8 // Fixed padding.
  });

  return [genBaseStyle(tagToken), genPresetStyle(tagToken), genTagStatusStyle(tagToken, 'success', 'Success'), genTagStatusStyle(tagToken, 'processing', 'Info'), genTagStatusStyle(tagToken, 'error', 'Error'), genTagStatusStyle(tagToken, 'warning', 'Warning')];
});