import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { createVNode as _createVNode } from "vue";
import { computed, defineComponent } from 'vue';
import PropTypes from '../_util/vue-types';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import { tuple, booleanType } from '../_util/type';
import useConfigInject from '../config-provider/hooks/useConfigInject';
export var timelineItemProps = function timelineItemProps() {
  return {
    prefixCls: String,
    color: String,
    dot: PropTypes.any,
    pending: booleanType(),
    position: PropTypes.oneOf(tuple('left', 'right', '')).def(''),
    label: PropTypes.any
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ATimelineItem',
  props: initDefaultProps(timelineItemProps(), {
    color: 'blue',
    pending: false
  }),
  slots: ['dot', 'label'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var _useConfigInject = useConfigInject('timeline', props),
      prefixCls = _useConfigInject.prefixCls;
    var itemClassName = computed(function () {
      var _ref2;
      return _ref2 = {}, _defineProperty(_ref2, "".concat(prefixCls.value, "-item"), true), _defineProperty(_ref2, "".concat(prefixCls.value, "-item-pending"), props.pending), _ref2;
    });
    var customColor = computed(function () {
      return /blue|red|green|gray/.test(props.color || '') ? undefined : props.color || 'blue';
    });
    var dotClassName = computed(function () {
      var _ref3;
      return _ref3 = {}, _defineProperty(_ref3, "".concat(prefixCls.value, "-item-head"), true), _defineProperty(_ref3, "".concat(prefixCls.value, "-item-head-").concat(props.color || 'blue'), !customColor.value), _ref3;
    });
    return function () {
      var _a, _b, _c;
      var _props$label = props.label,
        label = _props$label === void 0 ? (_a = slots.label) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$label,
        _props$dot = props.dot,
        dot = _props$dot === void 0 ? (_b = slots.dot) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$dot;
      return _createVNode("li", {
        "class": itemClassName.value
      }, [label && _createVNode("div", {
        "class": "".concat(prefixCls.value, "-item-label")
      }, [label]), _createVNode("div", {
        "class": "".concat(prefixCls.value, "-item-tail")
      }, null), _createVNode("div", {
        "class": [dotClassName.value, !!dot && "".concat(prefixCls.value, "-item-head-custom")],
        "style": {
          borderColor: customColor.value,
          color: customColor.value
        }
      }, [dot]), _createVNode("div", {
        "class": "".concat(prefixCls.value, "-item-content")
      }, [(_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots)])]);
    };
  }
});