import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { initZoomMotion } from '../../style/motion';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { genPresetColor, resetComponent } from '../../style';
import getArrowStyle, { MAX_VERTICAL_CONTENT_RADIUS } from '../../style/placementArrow';
import 'vue';
var genTooltipStyle = function genTooltipStyle(token) {
  var _extends2;
  var componentCls = token.componentCls,
    tooltipMaxWidth = token.tooltipMaxWidth,
    tooltipColor = token.tooltipColor,
    tooltipBg = token.tooltipBg,
    tooltipBorderRadius = token.tooltipBorderRadius,
    zIndexPopup = token.zIndexPopup,
    controlHeight = token.controlHeight,
    boxShadowSecondary = token.boxShadowSecondary,
    paddingSM = token.paddingSM,
    paddingXS = token.paddingXS,
    tooltipRadiusOuter = token.tooltipRadiusOuter;
  return [_defineProperty({}, componentCls, _extends(_extends(_extends(_extends({}, resetComponent(token)), (_extends2 = {
    position: 'absolute',
    zIndex: zIndexPopup,
    display: 'block',
    '&': [{
      width: 'max-content'
    }, {
      width: 'intrinsic'
    }],
    maxWidth: tooltipMaxWidth,
    visibility: 'visible',
    '&-hidden': {
      display: 'none'
    },
    '--antd-arrow-background-color': tooltipBg
  }, _defineProperty(_extends2, "".concat(componentCls, "-inner"), {
    minWidth: controlHeight,
    minHeight: controlHeight,
    padding: "".concat(paddingSM / 2, "px ").concat(paddingXS, "px"),
    color: tooltipColor,
    textAlign: 'start',
    textDecoration: 'none',
    wordWrap: 'break-word',
    backgroundColor: tooltipBg,
    borderRadius: tooltipBorderRadius,
    boxShadow: boxShadowSecondary
  }), _defineProperty(_extends2, ["&-placement-left", "&-placement-leftTop", "&-placement-leftBottom", "&-placement-right", "&-placement-rightTop", "&-placement-rightBottom"].join(','), _defineProperty({}, "".concat(componentCls, "-inner"), {
    borderRadius: Math.min(tooltipBorderRadius, MAX_VERTICAL_CONTENT_RADIUS)
  })), _defineProperty(_extends2, "".concat(componentCls, "-content"), {
    position: 'relative'
  }), _extends2)), genPresetColor(token, function (colorKey, _ref) {
    var _$concat$concat;
    var darkColor = _ref.darkColor;
    return _defineProperty({}, "&".concat(componentCls, "-").concat(colorKey), (_$concat$concat = {}, _defineProperty(_$concat$concat, "".concat(componentCls, "-inner"), {
      backgroundColor: darkColor
    }), _defineProperty(_$concat$concat, "".concat(componentCls, "-arrow"), {
      '--antd-arrow-background-color': darkColor
    }), _$concat$concat));
  })), {
    // RTL
    '&-rtl': {
      direction: 'rtl'
    }
  })),
  // Arrow Style
  getArrowStyle(mergeToken(token, {
    borderRadiusOuter: tooltipRadiusOuter
  }), {
    colorBg: 'var(--antd-arrow-background-color)',
    showArrowCls: '',
    contentRadius: tooltipBorderRadius,
    limitVerticalRadius: true
  }), // Pure Render
  _defineProperty({}, "".concat(componentCls, "-pure"), {
    position: 'relative',
    maxWidth: 'none'
  })];
};
// ============================== Export ==============================
export default (function (prefixCls, injectStyle) {
  var useOriginHook = genComponentStyleHook('Tooltip', function (token) {
    // Popover use Tooltip as internal component. We do not need to handle this.
    if ((injectStyle === null || injectStyle === void 0 ? void 0 : injectStyle.value) === false) {
      return [];
    }
    var borderRadius = token.borderRadius,
      colorTextLightSolid = token.colorTextLightSolid,
      colorBgDefault = token.colorBgDefault,
      borderRadiusOuter = token.borderRadiusOuter;
    var TooltipToken = mergeToken(token, {
      // default variables
      tooltipMaxWidth: 250,
      tooltipColor: colorTextLightSolid,
      tooltipBorderRadius: borderRadius,
      tooltipBg: colorBgDefault,
      tooltipRadiusOuter: borderRadiusOuter > 4 ? 4 : borderRadiusOuter
    });
    return [genTooltipStyle(TooltipToken), initZoomMotion(token, 'zoom-big-fast')];
  }, function (_ref5) {
    var zIndexPopupBase = _ref5.zIndexPopupBase,
      colorBgSpotlight = _ref5.colorBgSpotlight;
    return {
      zIndexPopup: zIndexPopupBase + 70,
      colorBgDefault: colorBgSpotlight
    };
  });
  return useOriginHook(prefixCls);
});