import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { computed, ref, defineComponent } from 'vue';
import VcTreeSelect, { TreeNode, SHOW_ALL, SHOW_PARENT, SHOW_CHILD, treeSelectProps as vcTreeSelectProps } from '../vc-tree-select';
import classNames from '../_util/classNames';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import omit from '../_util/omit';
import PropTypes from '../_util/vue-types';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import devWarning from '../vc-util/devWarning';
import getIcons from '../select/utils/iconUtil';
import renderSwitcherIcon from '../tree/utils/iconUtil';
import { warning } from '../vc-util/warning';
import { flattenChildren } from '../_util/props-util';
import { FormItemInputContext, useInjectFormItemContext } from '../form/FormItemContext';
import { getTransitionDirection } from '../_util/transition';
import { getStatusClassNames, getMergedStatus } from '../_util/statusUtils';
import { booleanType, stringType, objectType, someType, functionType } from '../_util/type';
// CSSINJS
import useSelectStyle from '../select/style';
import useStyle from './style';
import { useCompactItemContext } from '../space/Compact';
import { useInjectDisabled } from '../config-provider/DisabledContext';
var getTransitionName = function getTransitionName(rootPrefixCls, motion, transitionName) {
  if (transitionName !== undefined) {
    return transitionName;
  }
  return "".concat(rootPrefixCls, "-").concat(motion);
};
export function treeSelectProps() {
  return _extends(_extends({}, omit(vcTreeSelectProps(), ['showTreeIcon', 'treeMotion', 'inputIcon', 'getInputElement', 'treeLine', 'customSlots'])), {
    suffixIcon: PropTypes.any,
    size: stringType(),
    bordered: booleanType(),
    treeLine: someType([Boolean, Object]),
    replaceFields: objectType(),
    placement: stringType(),
    status: stringType(),
    popupClassName: String,
    /** @deprecated Please use `popupClassName` instead */
    dropdownClassName: String,
    'onUpdate:value': functionType(),
    'onUpdate:treeExpandedKeys': functionType(),
    'onUpdate:searchValue': functionType()
  });
}
var TreeSelect = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ATreeSelect',
  inheritAttrs: false,
  props: initDefaultProps(treeSelectProps(), {
    choiceTransitionName: '',
    listHeight: 256,
    treeIcon: false,
    listItemHeight: 26,
    bordered: true
  }),
  slots: ['title', 'titleRender', 'placeholder', 'maxTagPlaceholder', 'treeIcon', 'switcherIcon', 'notFoundContent'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots,
      expose = _ref.expose,
      emit = _ref.emit;
    warning(!(props.treeData === undefined && slots.default), '`children` of TreeSelect is deprecated. Please use `treeData` instead.');
    devWarning(props.multiple !== false || !props.treeCheckable, 'TreeSelect', '`multiple` will always be `true` when `treeCheckable` is true');
    devWarning(props.replaceFields === undefined, 'TreeSelect', '`replaceFields` is deprecated, please use fieldNames instead');
    devWarning(!props.dropdownClassName, 'TreeSelect', '`dropdownClassName` is deprecated. Please use `popupClassName` instead.');
    var formItemContext = useInjectFormItemContext();
    var formItemInputContext = FormItemInputContext.useInject();
    var mergedStatus = computed(function () {
      return getMergedStatus(formItemInputContext.status, props.status);
    });
    var _useConfigInject = useConfigInject('select', props),
      prefixCls = _useConfigInject.prefixCls,
      renderEmpty = _useConfigInject.renderEmpty,
      direction = _useConfigInject.direction,
      virtual = _useConfigInject.virtual,
      dropdownMatchSelectWidth = _useConfigInject.dropdownMatchSelectWidth,
      contextSize = _useConfigInject.size,
      getPopupContainer = _useConfigInject.getPopupContainer,
      getPrefixCls = _useConfigInject.getPrefixCls,
      disabled = _useConfigInject.disabled;
    var _useCompactItemContex = useCompactItemContext(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    var mergedSize = computed(function () {
      return compactSize.value || contextSize.value;
    });
    var contextDisabled = useInjectDisabled();
    var mergedDisabled = computed(function () {
      var _a;
      return (_a = disabled.value) !== null && _a !== void 0 ? _a : contextDisabled.value;
    });
    var rootPrefixCls = computed(function () {
      return getPrefixCls();
    });
    // ===================== Placement =====================
    var placement = computed(function () {
      if (props.placement !== undefined) {
        return props.placement;
      }
      return direction.value === 'rtl' ? 'bottomRight' : 'bottomLeft';
    });
    var transitionName = computed(function () {
      return getTransitionName(rootPrefixCls.value, getTransitionDirection(placement.value), props.transitionName);
    });
    var choiceTransitionName = computed(function () {
      return getTransitionName(rootPrefixCls.value, '', props.choiceTransitionName);
    });
    var treePrefixCls = computed(function () {
      return getPrefixCls('select-tree', props.prefixCls);
    });
    var treeSelectPrefixCls = computed(function () {
      return getPrefixCls('tree-select', props.prefixCls);
    });
    // style
    var _useSelectStyle = useSelectStyle(prefixCls),
      _useSelectStyle2 = _slicedToArray(_useSelectStyle, 2),
      wrapSelectSSR = _useSelectStyle2[0],
      hashId = _useSelectStyle2[1];
    var _useStyle = useStyle(treeSelectPrefixCls, treePrefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 1),
      wrapTreeSelectSSR = _useStyle2[0];
    var mergedDropdownClassName = computed(function () {
      return classNames(props.popupClassName || props.dropdownClassName, "".concat(treeSelectPrefixCls.value, "-dropdown"), _defineProperty({}, "".concat(treeSelectPrefixCls.value, "-dropdown-rtl"), direction.value === 'rtl'), hashId.value);
    });
    var isMultiple = computed(function () {
      return !!(props.treeCheckable || props.multiple);
    });
    var mergedShowArrow = computed(function () {
      return props.showArrow !== undefined ? props.showArrow : props.loading || !isMultiple.value;
    });
    var treeSelectRef = ref();
    expose({
      focus: function focus() {
        var _a, _b;
        (_b = (_a = treeSelectRef.value).focus) === null || _b === void 0 ? void 0 : _b.call(_a);
      },
      blur: function blur() {
        var _a, _b;
        (_b = (_a = treeSelectRef.value).blur) === null || _b === void 0 ? void 0 : _b.call(_a);
      }
    });
    var handleChange = function handleChange() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      emit('update:value', args[0]);
      emit.apply(void 0, ['change'].concat(args));
      formItemContext.onFieldChange();
    };
    var handleTreeExpand = function handleTreeExpand(keys) {
      emit('update:treeExpandedKeys', keys);
      emit('treeExpand', keys);
    };
    var handleSearch = function handleSearch(value) {
      emit('update:searchValue', value);
      emit('search', value);
    };
    var handleBlur = function handleBlur(e) {
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    return function () {
      var _classNames2;
      var _a, _b;
      var _props$notFoundConten = props.notFoundContent,
        notFoundContent = _props$notFoundConten === void 0 ? (_a = slots.notFoundContent) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$notFoundConten,
        customizePrefixCls = props.prefixCls,
        bordered = props.bordered,
        listHeight = props.listHeight,
        listItemHeight = props.listItemHeight,
        multiple = props.multiple,
        treeIcon = props.treeIcon,
        treeLine = props.treeLine,
        showArrow = props.showArrow,
        _props$switcherIcon = props.switcherIcon,
        _switcherIcon = _props$switcherIcon === void 0 ? (_b = slots.switcherIcon) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$switcherIcon,
        _props$fieldNames = props.fieldNames,
        fieldNames = _props$fieldNames === void 0 ? props.replaceFields : _props$fieldNames,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id;
      var isFormItemInput = formItemInputContext.isFormItemInput,
        hasFeedback = formItemInputContext.hasFeedback,
        feedbackIcon = formItemInputContext.feedbackIcon;
      // ===================== Icons =====================
      var _getIcons = getIcons(_extends(_extends({}, props), {
          multiple: isMultiple.value,
          showArrow: mergedShowArrow.value,
          hasFeedback: hasFeedback,
          feedbackIcon: feedbackIcon,
          prefixCls: prefixCls.value
        }), slots),
        suffixIcon = _getIcons.suffixIcon,
        removeIcon = _getIcons.removeIcon,
        clearIcon = _getIcons.clearIcon;
      // ===================== Empty =====================
      var mergedNotFound;
      if (notFoundContent !== undefined) {
        mergedNotFound = notFoundContent;
      } else {
        mergedNotFound = renderEmpty('Select');
      }
      // ==================== Render =====================
      var selectProps = omit(props, ['suffixIcon', 'itemIcon', 'removeIcon', 'clearIcon', 'switcherIcon', 'bordered', 'status', 'onUpdate:value', 'onUpdate:treeExpandedKeys', 'onUpdate:searchValue']);
      var mergedClassName = classNames(!customizePrefixCls && treeSelectPrefixCls.value, (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls.value, "-lg"), mergedSize.value === 'large'), _defineProperty(_classNames2, "".concat(prefixCls.value, "-sm"), mergedSize.value === 'small'), _defineProperty(_classNames2, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _defineProperty(_classNames2, "".concat(prefixCls.value, "-borderless"), !bordered), _defineProperty(_classNames2, "".concat(prefixCls.value, "-in-form-item"), isFormItemInput), _classNames2), getStatusClassNames(prefixCls.value, mergedStatus.value, hasFeedback), compactItemClassnames.value, attrs.class, hashId.value);
      var otherProps = {};
      if (props.treeData === undefined && slots.default) {
        otherProps.children = flattenChildren(slots.default());
      }
      return wrapSelectSSR(wrapTreeSelectSSR(_createVNode(VcTreeSelect, _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, attrs), selectProps), {}, {
        "disabled": mergedDisabled.value,
        "virtual": virtual.value,
        "dropdownMatchSelectWidth": dropdownMatchSelectWidth.value,
        "id": id,
        "fieldNames": fieldNames,
        "ref": treeSelectRef,
        "prefixCls": prefixCls.value,
        "class": mergedClassName,
        "listHeight": listHeight,
        "listItemHeight": listItemHeight,
        "treeLine": !!treeLine,
        "inputIcon": suffixIcon,
        "multiple": multiple,
        "removeIcon": removeIcon,
        "clearIcon": clearIcon,
        "switcherIcon": function switcherIcon(nodeProps) {
          return renderSwitcherIcon(treePrefixCls.value, _switcherIcon, nodeProps, slots.leafIcon, treeLine);
        },
        "showTreeIcon": treeIcon,
        "notFoundContent": mergedNotFound,
        "getPopupContainer": getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value,
        "treeMotion": null,
        "dropdownClassName": mergedDropdownClassName.value,
        "choiceTransitionName": choiceTransitionName.value,
        "onChange": handleChange,
        "onBlur": handleBlur,
        "onSearch": handleSearch,
        "onTreeExpand": handleTreeExpand
      }, otherProps), {}, {
        "transitionName": transitionName.value,
        "customSlots": _extends(_extends({}, slots), {
          treeCheckable: function treeCheckable() {
            return _createVNode("span", {
              "class": "".concat(prefixCls.value, "-tree-checkbox-inner")
            }, null);
          }
        }),
        "maxTagPlaceholder": props.maxTagPlaceholder || slots.maxTagPlaceholder,
        "placement": placement.value,
        "showArrow": hasFeedback || showArrow
      }), _extends(_extends({}, slots), {
        treeCheckable: function treeCheckable() {
          return _createVNode("span", {
            "class": "".concat(prefixCls.value, "-tree-checkbox-inner")
          }, null);
        }
      }))));
    };
  }
});
/* istanbul ignore next */
export var TreeSelectNode = TreeNode;
export default _extends(TreeSelect, {
  TreeNode: TreeNode,
  SHOW_ALL: SHOW_ALL,
  SHOW_PARENT: SHOW_PARENT,
  SHOW_CHILD: SHOW_CHILD,
  install: function install(app) {
    app.component(TreeSelect.name, TreeSelect);
    app.component(TreeSelectNode.displayName, TreeSelectNode);
    return app;
  }
});