import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { genComponentStyleHook } from '../../theme/internal';
import { getCopiableStyles, getEditableStyles, getEllipsisStyles, getLinkStyles, getResetStyles, getTitleStyles } from './mixins';
import { operationUnit } from '../../style';
var genTypographyStyle = function genTypographyStyle(token) {
  var _extends2, _extends3;
  var componentCls = token.componentCls,
    sizeMarginHeadingVerticalStart = token.sizeMarginHeadingVerticalStart;
  return _defineProperty({}, componentCls, _extends(_extends(_extends(_extends(_extends(_extends(_extends(_extends(_extends((_extends2 = {
    color: token.colorText,
    wordBreak: 'break-word',
    lineHeight: token.lineHeight
  }, _defineProperty(_extends2, "&".concat(componentCls, "-secondary"), {
    color: token.colorTextDescription
  }), _defineProperty(_extends2, "&".concat(componentCls, "-success"), {
    color: token.colorSuccess
  }), _defineProperty(_extends2, "&".concat(componentCls, "-warning"), {
    color: token.colorWarning
  }), _defineProperty(_extends2, "&".concat(componentCls, "-danger"), {
    color: token.colorError,
    'a&:active, a&:focus': {
      color: token.colorErrorActive
    },
    'a&:hover': {
      color: token.colorErrorHover
    }
  }), _defineProperty(_extends2, "&".concat(componentCls, "-disabled"), {
    color: token.colorTextDisabled,
    cursor: 'not-allowed',
    userSelect: 'none'
  }), _defineProperty(_extends2, "\n        div&,\n        p\n      ", {
    marginBottom: '1em'
  }), _extends2), getTitleStyles(token)), (_extends3 = {}, _defineProperty(_extends3, "\n      & + h1".concat(componentCls, ",\n      & + h2").concat(componentCls, ",\n      & + h3").concat(componentCls, ",\n      & + h4").concat(componentCls, ",\n      & + h5").concat(componentCls, "\n      "), {
    marginTop: sizeMarginHeadingVerticalStart
  }), _defineProperty(_extends3, "\n      div,\n      ul,\n      li,\n      p,\n      h1,\n      h2,\n      h3,\n      h4,\n      h5", _defineProperty({}, "\n        + h1,\n        + h2,\n        + h3,\n        + h4,\n        + h5\n        ", {
    marginTop: sizeMarginHeadingVerticalStart
  })), _extends3)), getResetStyles()), getLinkStyles(token)), _defineProperty({}, "\n        ".concat(componentCls, "-expand,\n        ").concat(componentCls, "-edit,\n        ").concat(componentCls, "-copy\n      "), _extends(_extends({}, operationUnit(token)), {
    marginInlineStart: token.marginXXS
  }))), getEditableStyles(token)), getCopiableStyles(token)), getEllipsisStyles()), {
    '&-rtl': {
      direction: 'rtl'
    }
  }));
};
// ============================== Export ==============================
export default genComponentStyleHook('Typography', function (token) {
  return [genTypographyStyle(token)];
}, {
  sizeMarginHeadingVerticalStart: '1.2em',
  sizeMarginHeadingVerticalEnd: '0.5em'
});