import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { withDirectives as _withDirectives, vShow as _vShow, createVNode as _createVNode } from "vue";
import { computed, defineComponent, onBeforeUnmount, onMounted, shallowRef, watch } from 'vue';
import EyeOutlined from "@ant-design/icons-vue/es/icons/EyeOutlined";
import DeleteOutlined from "@ant-design/icons-vue/es/icons/DeleteOutlined";
import DownloadOutlined from "@ant-design/icons-vue/es/icons/DownloadOutlined";
import Tooltip from '../../tooltip';
import Progress from '../../progress';
import useConfigInject from '../../config-provider/hooks/useConfigInject';
import Transition, { getTransitionProps } from '../../_util/transition';
import { booleanType, stringType, functionType, arrayType, objectType } from '../../_util/type';
export var listItemProps = function listItemProps() {
  return {
    prefixCls: String,
    locale: objectType(undefined),
    file: objectType(),
    items: arrayType(),
    listType: stringType(),
    isImgUrl: functionType(),
    showRemoveIcon: booleanType(),
    showDownloadIcon: booleanType(),
    showPreviewIcon: booleanType(),
    removeIcon: functionType(),
    downloadIcon: functionType(),
    previewIcon: functionType(),
    iconRender: functionType(),
    actionIconRender: functionType(),
    itemRender: functionType(),
    onPreview: functionType(),
    onClose: functionType(),
    onDownload: functionType(),
    progress: objectType()
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ListItem',
  inheritAttrs: false,
  props: listItemProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _a;
    var showProgress = shallowRef(false);
    var progressRafRef = shallowRef();
    onMounted(function () {
      progressRafRef.value = setTimeout(function () {
        showProgress.value = true;
      }, 300);
    });
    onBeforeUnmount(function () {
      clearTimeout(progressRafRef.value);
    });
    var mergedStatus = shallowRef((_a = props.file) === null || _a === void 0 ? void 0 : _a.status);
    watch(function () {
      var _a;
      return (_a = props.file) === null || _a === void 0 ? void 0 : _a.status;
    }, function (status) {
      if (status !== 'removed') {
        mergedStatus.value = status;
      }
    });
    var _useConfigInject = useConfigInject('upload', props),
      rootPrefixCls = _useConfigInject.rootPrefixCls;
    var transitionProps = computed(function () {
      return getTransitionProps("".concat(rootPrefixCls.value, "-fade"));
    });
    return function () {
      var _infoUploadingClass, _listContainerNameCla;
      var _a, _b;
      var prefixCls = props.prefixCls,
        locale = props.locale,
        listType = props.listType,
        file = props.file,
        items = props.items,
        progressProps = props.progress,
        _props$iconRender = props.iconRender,
        iconRender = _props$iconRender === void 0 ? slots.iconRender : _props$iconRender,
        _props$actionIconRend = props.actionIconRender,
        actionIconRender = _props$actionIconRend === void 0 ? slots.actionIconRender : _props$actionIconRend,
        _props$itemRender = props.itemRender,
        itemRender = _props$itemRender === void 0 ? slots.itemRender : _props$itemRender,
        isImgUrl = props.isImgUrl,
        showPreviewIcon = props.showPreviewIcon,
        showRemoveIcon = props.showRemoveIcon,
        showDownloadIcon = props.showDownloadIcon,
        _props$previewIcon = props.previewIcon,
        customPreviewIcon = _props$previewIcon === void 0 ? slots.previewIcon : _props$previewIcon,
        _props$removeIcon = props.removeIcon,
        customRemoveIcon = _props$removeIcon === void 0 ? slots.removeIcon : _props$removeIcon,
        _props$downloadIcon = props.downloadIcon,
        customDownloadIcon = _props$downloadIcon === void 0 ? slots.downloadIcon : _props$downloadIcon,
        onPreview = props.onPreview,
        onDownload = props.onDownload,
        onClose = props.onClose;
      var className = attrs.class,
        style = attrs.style;
      // This is used for legacy span make scrollHeight the wrong value.
      // We will force these to be `display: block` with non `picture-card`
      var iconNode = iconRender({
        file: file
      });
      var icon = _createVNode("div", {
        "class": "".concat(prefixCls, "-text-icon")
      }, [iconNode]);
      if (listType === 'picture' || listType === 'picture-card') {
        if (mergedStatus.value === 'uploading' || !file.thumbUrl && !file.url) {
          var _uploadingClassName;
          var uploadingClassName = (_uploadingClassName = {}, _defineProperty(_uploadingClassName, "".concat(prefixCls, "-list-item-thumbnail"), true), _defineProperty(_uploadingClassName, "".concat(prefixCls, "-list-item-file"), mergedStatus.value !== 'uploading'), _uploadingClassName);
          icon = _createVNode("div", {
            "class": uploadingClassName
          }, [iconNode]);
        } else {
          var _aClassName;
          var thumbnail = (isImgUrl === null || isImgUrl === void 0 ? void 0 : isImgUrl(file)) ? _createVNode("img", {
            "src": file.thumbUrl || file.url,
            "alt": file.name,
            "class": "".concat(prefixCls, "-list-item-image"),
            "crossorigin": file.crossOrigin
          }, null) : iconNode;
          var aClassName = (_aClassName = {}, _defineProperty(_aClassName, "".concat(prefixCls, "-list-item-thumbnail"), true), _defineProperty(_aClassName, "".concat(prefixCls, "-list-item-file"), isImgUrl && !isImgUrl(file)), _aClassName);
          icon = _createVNode("a", {
            "class": aClassName,
            "onClick": function onClick(e) {
              return onPreview(file, e);
            },
            "href": file.url || file.thumbUrl,
            "target": "_blank",
            "rel": "noopener noreferrer"
          }, [thumbnail]);
        }
      }
      var infoUploadingClass = (_infoUploadingClass = {}, _defineProperty(_infoUploadingClass, "".concat(prefixCls, "-list-item"), true), _defineProperty(_infoUploadingClass, "".concat(prefixCls, "-list-item-").concat(mergedStatus.value), true), _infoUploadingClass);
      var linkProps = typeof file.linkProps === 'string' ? JSON.parse(file.linkProps) : file.linkProps;
      var removeIcon = showRemoveIcon ? actionIconRender({
        customIcon: customRemoveIcon ? customRemoveIcon({
          file: file
        }) : _createVNode(DeleteOutlined, null, null),
        callback: function callback() {
          return onClose(file);
        },
        prefixCls: prefixCls,
        title: locale.removeFile
      }) : null;
      var downloadIcon = showDownloadIcon && mergedStatus.value === 'done' ? actionIconRender({
        customIcon: customDownloadIcon ? customDownloadIcon({
          file: file
        }) : _createVNode(DownloadOutlined, null, null),
        callback: function callback() {
          return onDownload(file);
        },
        prefixCls: prefixCls,
        title: locale.downloadFile
      }) : null;
      var downloadOrDelete = listType !== 'picture-card' && _createVNode("span", {
        "key": "download-delete",
        "class": ["".concat(prefixCls, "-list-item-actions"), {
          picture: listType === 'picture'
        }]
      }, [downloadIcon, removeIcon]);
      var listItemNameClass = "".concat(prefixCls, "-list-item-name");
      var fileName = file.url ? [_createVNode("a", _objectSpread(_objectSpread({
        "key": "view",
        "target": "_blank",
        "rel": "noopener noreferrer",
        "class": listItemNameClass,
        "title": file.name
      }, linkProps), {}, {
        "href": file.url,
        "onClick": function onClick(e) {
          return onPreview(file, e);
        }
      }), [file.name]), downloadOrDelete] : [_createVNode("span", {
        "key": "view",
        "class": listItemNameClass,
        "onClick": function onClick(e) {
          return onPreview(file, e);
        },
        "title": file.name
      }, [file.name]), downloadOrDelete];
      var previewStyle = {
        pointerEvents: 'none',
        opacity: 0.5
      };
      var previewIcon = showPreviewIcon ? _createVNode("a", {
        "href": file.url || file.thumbUrl,
        "target": "_blank",
        "rel": "noopener noreferrer",
        "style": file.url || file.thumbUrl ? undefined : previewStyle,
        "onClick": function onClick(e) {
          return onPreview(file, e);
        },
        "title": locale.previewFile
      }, [customPreviewIcon ? customPreviewIcon({
        file: file
      }) : _createVNode(EyeOutlined, null, null)]) : null;
      var pictureCardActions = listType === 'picture-card' && mergedStatus.value !== 'uploading' && _createVNode("span", {
        "class": "".concat(prefixCls, "-list-item-actions")
      }, [previewIcon, mergedStatus.value === 'done' && downloadIcon, removeIcon]);
      var dom = _createVNode("div", {
        "class": infoUploadingClass
      }, [icon, fileName, pictureCardActions, showProgress.value && _createVNode(Transition, transitionProps.value, {
        default: function _default() {
          return [_withDirectives(_createVNode("div", {
            "class": "".concat(prefixCls, "-list-item-progress")
          }, ['percent' in file ? _createVNode(Progress, _objectSpread(_objectSpread({}, progressProps), {}, {
            "type": "line",
            "percent": file.percent
          }), null) : null]), [[_vShow, mergedStatus.value === 'uploading']])];
        }
      })]);
      var listContainerNameClass = (_listContainerNameCla = {}, _defineProperty(_listContainerNameCla, "".concat(prefixCls, "-list-item-container"), true), _defineProperty(_listContainerNameCla, "".concat(className), !!className), _listContainerNameCla);
      var message = file.response && typeof file.response === 'string' ? file.response : ((_a = file.error) === null || _a === void 0 ? void 0 : _a.statusText) || ((_b = file.error) === null || _b === void 0 ? void 0 : _b.message) || locale.uploadError;
      var item = mergedStatus.value === 'error' ? _createVNode(Tooltip, {
        "title": message,
        "getPopupContainer": function getPopupContainer(node) {
          return node.parentNode;
        }
      }, {
        default: function _default() {
          return [dom];
        }
      }) : dom;
      return _createVNode("div", {
        "class": listContainerNameClass,
        "style": style
      }, [itemRender ? itemRender({
        originNode: item,
        file: file,
        fileList: items,
        actions: {
          download: onDownload.bind(null, file),
          preview: onPreview.bind(null, file),
          remove: onClose.bind(null, file)
        }
      }) : item]);
    };
  }
});