import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { clearFix, textEllipsis } from '../../style';
var genListStyle = function genListStyle(token) {
  var _actionsCls, _itemCls, _actionsCls2, _$concat, _extends2;
  var componentCls = token.componentCls,
    antCls = token.antCls,
    iconCls = token.iconCls,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight;
  var itemCls = "".concat(componentCls, "-list-item");
  var actionsCls = "".concat(itemCls, "-actions");
  var actionCls = "".concat(itemCls, "-action");
  var listItemHeightSM = Math.round(fontSize * lineHeight);
  return _defineProperty({}, "".concat(componentCls, "-wrapper"), _defineProperty({}, "".concat(componentCls, "-list"), _extends(_extends({}, clearFix()), (_extends2 = {
    lineHeight: token.lineHeight
  }, _defineProperty(_extends2, itemCls, (_itemCls = {
    position: 'relative',
    height: token.lineHeight * fontSize,
    marginTop: token.marginXS,
    fontSize: fontSize,
    display: 'flex',
    alignItems: 'center',
    transition: "background-color ".concat(token.motionDurationSlow),
    '&:hover': {
      backgroundColor: token.controlItemBgHover
    }
  }, _defineProperty(_itemCls, "".concat(itemCls, "-name"), _extends(_extends({}, textEllipsis), {
    padding: "0 ".concat(token.paddingXS, "px"),
    lineHeight: lineHeight,
    flex: 'auto',
    transition: "all ".concat(token.motionDurationSlow)
  })), _defineProperty(_itemCls, actionsCls, (_actionsCls = {}, _defineProperty(_actionsCls, actionCls, {
    opacity: 0
  }), _defineProperty(_actionsCls, "".concat(actionCls).concat(antCls, "-btn-sm"), {
    height: listItemHeightSM,
    border: 0,
    lineHeight: 1,
    // FIXME: should not override small button
    '> span': {
      transform: 'scale(1)'
    }
  }), _defineProperty(_actionsCls, "\n              ".concat(actionCls, ":focus,\n              &.picture ").concat(actionCls, "\n            "), {
    opacity: 1
  }), _defineProperty(_actionsCls, iconCls, {
    color: token.colorTextDescription,
    transition: "all ".concat(token.motionDurationSlow)
  }), _defineProperty(_actionsCls, "&:hover ".concat(iconCls), {
    color: token.colorText
  }), _actionsCls)), _defineProperty(_itemCls, "".concat(componentCls, "-icon ").concat(iconCls), {
    color: token.colorTextDescription,
    fontSize: fontSize
  }), _defineProperty(_itemCls, "".concat(itemCls, "-progress"), {
    position: 'absolute',
    bottom: -token.uploadProgressOffset,
    width: '100%',
    paddingInlineStart: fontSize + token.paddingXS,
    fontSize: fontSize,
    lineHeight: 0,
    pointerEvents: 'none',
    '> div': {
      margin: 0
    }
  }), _itemCls)), _defineProperty(_extends2, "".concat(itemCls, ":hover ").concat(actionCls), {
    opacity: 1,
    color: token.colorText
  }), _defineProperty(_extends2, "".concat(itemCls, "-error"), (_$concat = {
    color: token.colorError
  }, _defineProperty(_$concat, "".concat(itemCls, "-name, ").concat(componentCls, "-icon ").concat(iconCls), {
    color: token.colorError
  }), _defineProperty(_$concat, actionsCls, (_actionsCls2 = {}, _defineProperty(_actionsCls2, "".concat(iconCls, ", ").concat(iconCls, ":hover"), {
    color: token.colorError
  }), _defineProperty(_actionsCls2, actionCls, {
    opacity: 1
  }), _actionsCls2)), _$concat)), _defineProperty(_extends2, "".concat(componentCls, "-list-item-container"), {
    transition: "opacity ".concat(token.motionDurationSlow, ", height ").concat(token.motionDurationSlow),
    // For smooth removing animation
    '&::before': {
      display: 'table',
      width: 0,
      height: 0,
      content: '""'
    }
  }), _extends2))));
};
export default genListStyle;