import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { TinyColor } from '@ctrl/tinycolor';
import { clearFix, textEllipsis } from '../../style';
var genPictureStyle = function genPictureStyle(token) {
  var _extends2, _itemCls, _$concat$concat, _$concat$concat$conca;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    uploadThumbnailSize = token.uploadThumbnailSize,
    uploadProgressOffset = token.uploadProgressOffset;
  var listCls = "".concat(componentCls, "-list");
  var itemCls = "".concat(listCls, "-item");
  return _defineProperty({}, "".concat(componentCls, "-wrapper"), _defineProperty({}, "".concat(listCls).concat(listCls, "-picture, ").concat(listCls).concat(listCls, "-picture-card"), (_$concat$concat$conca = {}, _defineProperty(_$concat$concat$conca, itemCls, (_itemCls = {
    position: 'relative',
    height: uploadThumbnailSize + token.lineWidth * 2 + token.paddingXS * 2,
    padding: token.paddingXS,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    borderRadius: token.borderRadiusLG,
    '&:hover': {
      background: 'transparent'
    }
  }, _defineProperty(_itemCls, "".concat(itemCls, "-thumbnail"), _extends(_extends({}, textEllipsis), (_extends2 = {
    width: uploadThumbnailSize,
    height: uploadThumbnailSize,
    lineHeight: "".concat(uploadThumbnailSize + token.paddingSM, "px"),
    textAlign: 'center',
    flex: 'none'
  }, _defineProperty(_extends2, iconCls, {
    fontSize: token.fontSizeHeading2,
    color: token.colorPrimary
  }), _defineProperty(_extends2, "img", {
    display: 'block',
    width: '100%',
    height: '100%',
    overflow: 'hidden'
  }), _extends2))), _defineProperty(_itemCls, "".concat(itemCls, "-progress"), {
    bottom: uploadProgressOffset,
    width: "calc(100% - ".concat(token.paddingSM * 2, "px)"),
    marginTop: 0,
    paddingInlineStart: uploadThumbnailSize + token.paddingXS
  }), _itemCls)), _defineProperty(_$concat$concat$conca, "".concat(itemCls, "-error"), _defineProperty({
    borderColor: token.colorError
  }, "".concat(itemCls, "-thumbnail ").concat(iconCls), (_$concat$concat = {}, _defineProperty(_$concat$concat, "svg path[fill='#e6f7ff']", {
    fill: token.colorErrorBg
  }), _defineProperty(_$concat$concat, "svg path[fill='#1890ff']", {
    fill: token.colorError
  }), _$concat$concat))), _defineProperty(_$concat$concat$conca, "".concat(itemCls, "-uploading"), _defineProperty({
    borderStyle: 'dashed'
  }, "".concat(itemCls, "-name"), {
    marginBottom: uploadProgressOffset
  })), _$concat$concat$conca)));
};
var genPictureCardStyle = function genPictureCardStyle(token) {
  var _$concat$concat2, _$concat6, _$concat$concat4, _extends3;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    fontSizeLG = token.fontSizeLG,
    colorTextLightSolid = token.colorTextLightSolid;
  var listCls = "".concat(componentCls, "-list");
  var itemCls = "".concat(listCls, "-item");
  var uploadPictureCardSize = token.uploadPicCardSize;
  return _defineProperty({}, "".concat(componentCls, "-wrapper").concat(componentCls, "-picture-card-wrapper"), _extends(_extends({}, clearFix()), (_extends3 = {
    display: 'inline-block',
    width: '100%'
  }, _defineProperty(_extends3, "".concat(componentCls).concat(componentCls, "-select"), (_$concat$concat2 = {
    width: uploadPictureCardSize,
    height: uploadPictureCardSize,
    marginInlineEnd: token.marginXS,
    marginBottom: token.marginXS,
    textAlign: 'center',
    verticalAlign: 'top',
    backgroundColor: token.colorFillAlter,
    border: "".concat(token.lineWidth, "px dashed ").concat(token.colorBorder),
    borderRadius: token.borderRadiusLG,
    cursor: 'pointer',
    transition: "border-color ".concat(token.motionDurationSlow)
  }, _defineProperty(_$concat$concat2, "> ".concat(componentCls), {
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: '100%',
    textAlign: 'center'
  }), _defineProperty(_$concat$concat2, "&:not(".concat(componentCls, "-disabled):hover"), {
    borderColor: token.colorPrimary
  }), _$concat$concat2)), _defineProperty(_extends3, "".concat(listCls).concat(listCls, "-picture-card"), (_$concat$concat4 = {}, _defineProperty(_$concat$concat4, "".concat(listCls, "-item-container"), {
    display: 'inline-block',
    width: uploadPictureCardSize,
    height: uploadPictureCardSize,
    marginBlock: "0 ".concat(token.marginXS, "px"),
    marginInline: "0 ".concat(token.marginXS, "px"),
    verticalAlign: 'top'
  }), _defineProperty(_$concat$concat4, '&::after', {
    display: 'none'
  }), _defineProperty(_$concat$concat4, itemCls, {
    height: '100%',
    margin: 0,
    '&::before': {
      position: 'absolute',
      zIndex: 1,
      width: "calc(100% - ".concat(token.paddingXS * 2, "px)"),
      height: "calc(100% - ".concat(token.paddingXS * 2, "px)"),
      backgroundColor: token.colorBgMask,
      opacity: 0,
      transition: "all ".concat(token.motionDurationSlow),
      content: '" "'
    }
  }), _defineProperty(_$concat$concat4, "".concat(itemCls, ":hover"), _defineProperty({}, "&::before, ".concat(itemCls, "-actions"), {
    opacity: 1
  })), _defineProperty(_$concat$concat4, "".concat(itemCls, "-actions"), _defineProperty({
    position: 'absolute',
    insetInlineStart: 0,
    zIndex: 10,
    width: '100%',
    whiteSpace: 'nowrap',
    textAlign: 'center',
    opacity: 0,
    transition: "all ".concat(token.motionDurationSlow)
  }, "".concat(iconCls, "-eye, ").concat(iconCls, "-download, ").concat(iconCls, "-delete"), {
    zIndex: 10,
    width: fontSizeLG,
    margin: "0 ".concat(token.marginXXS, "px"),
    fontSize: fontSizeLG,
    cursor: 'pointer',
    transition: "all ".concat(token.motionDurationSlow)
  })), _defineProperty(_$concat$concat4, "".concat(itemCls, "-actions, ").concat(itemCls, "-actions:hover"), _defineProperty({}, "".concat(iconCls, "-eye, ").concat(iconCls, "-download, ").concat(iconCls, "-delete"), {
    color: new TinyColor(colorTextLightSolid).setAlpha(0.65).toRgbString(),
    '&:hover': {
      color: colorTextLightSolid
    }
  })), _defineProperty(_$concat$concat4, "".concat(itemCls, "-thumbnail, ").concat(itemCls, "-thumbnail img"), {
    position: 'static',
    display: 'block',
    width: '100%',
    height: '100%',
    objectFit: 'contain'
  }), _defineProperty(_$concat$concat4, "".concat(itemCls, "-name"), {
    display: 'none',
    textAlign: 'center'
  }), _defineProperty(_$concat$concat4, "".concat(itemCls, "-file + ").concat(itemCls, "-name"), {
    position: 'absolute',
    bottom: token.margin,
    display: 'block',
    width: "calc(100% - ".concat(token.paddingXS * 2, "px)")
  }), _defineProperty(_$concat$concat4, "".concat(itemCls, "-uploading"), (_$concat6 = {}, _defineProperty(_$concat6, "&".concat(itemCls), {
    backgroundColor: token.colorFillAlter
  }), _defineProperty(_$concat6, "&::before, ".concat(iconCls, "-eye, ").concat(iconCls, "-download, ").concat(iconCls, "-delete"), {
    display: 'none'
  }), _$concat6)), _defineProperty(_$concat$concat4, "".concat(itemCls, "-progress"), {
    bottom: token.marginXL,
    width: "calc(100% - ".concat(token.paddingXS * 2, "px)"),
    paddingInlineStart: 0
  }), _$concat$concat4)), _extends3)));
};
export { genPictureStyle, genPictureCardStyle };