import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { createVNode as _createVNode } from "vue";
import { defineComponent, ref } from 'vue';
import classNames from '../_util/classNames';
import { cloneElement } from '../_util/vnode';
import { baseInputProps } from './inputProps';
import { hasAddon, hasPrefixSuffix } from './utils/commonUtils';
export default defineComponent({
  name: 'BaseInput',
  inheritAttrs: false,
  props: baseInputProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var containerRef = ref();
    var onInputMouseDown = function onInputMouseDown(e) {
      var _a;
      if ((_a = containerRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.target)) {
        var triggerFocus = props.triggerFocus;
        triggerFocus === null || triggerFocus === void 0 ? void 0 : triggerFocus();
      }
    };
    var getClearIcon = function getClearIcon() {
      var _classNames;
      var _a;
      var allowClear = props.allowClear,
        value = props.value,
        disabled = props.disabled,
        readonly = props.readonly,
        handleReset = props.handleReset,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? slots.suffix : _props$suffix,
        prefixCls = props.prefixCls;
      if (!allowClear) {
        return null;
      }
      var needClear = !disabled && !readonly && value;
      var className = "".concat(prefixCls, "-clear-icon");
      var iconNode = ((_a = slots.clearIcon) === null || _a === void 0 ? void 0 : _a.call(slots)) || '*';
      return _createVNode("span", {
        "onClick": handleReset,
        "onMousedown": function onMousedown(e) {
          return e.preventDefault();
        },
        "class": classNames((_classNames = {}, _defineProperty(_classNames, "".concat(className, "-hidden"), !needClear), _defineProperty(_classNames, "".concat(className, "-has-suffix"), !!suffix), _classNames), className),
        "role": "button",
        "tabindex": -1
      }, [iconNode]);
    };
    return function () {
      var _a, _b;
      var focused = props.focused,
        value = props.value,
        disabled = props.disabled,
        allowClear = props.allowClear,
        readonly = props.readonly,
        hidden = props.hidden,
        prefixCls = props.prefixCls,
        _props$prefix = props.prefix,
        prefix = _props$prefix === void 0 ? (_a = slots.prefix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$prefix,
        _props$suffix2 = props.suffix,
        suffix = _props$suffix2 === void 0 ? (_b = slots.suffix) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$suffix2,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? slots.addonAfter : _props$addonAfter,
        _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? slots.addonBefore : _props$addonBefore,
        inputElement = props.inputElement,
        affixWrapperClassName = props.affixWrapperClassName,
        wrapperClassName = props.wrapperClassName,
        groupClassName = props.groupClassName;
      var element = cloneElement(inputElement, {
        value: value,
        hidden: hidden
      });
      // ================== Prefix & Suffix ================== //
      if (hasPrefixSuffix({
        prefix: prefix,
        suffix: suffix,
        allowClear: allowClear
      })) {
        var _classNames2;
        var affixWrapperPrefixCls = "".concat(prefixCls, "-affix-wrapper");
        var affixWrapperCls = classNames(affixWrapperPrefixCls, (_classNames2 = {}, _defineProperty(_classNames2, "".concat(affixWrapperPrefixCls, "-disabled"), disabled), _defineProperty(_classNames2, "".concat(affixWrapperPrefixCls, "-focused"), focused), _defineProperty(_classNames2, "".concat(affixWrapperPrefixCls, "-readonly"), readonly), _defineProperty(_classNames2, "".concat(affixWrapperPrefixCls, "-input-with-clear-btn"), suffix && allowClear && value), _classNames2), !hasAddon({
          addonAfter: addonAfter,
          addonBefore: addonBefore
        }) && attrs.class, affixWrapperClassName);
        var suffixNode = (suffix || allowClear) && _createVNode("span", {
          "class": "".concat(prefixCls, "-suffix")
        }, [getClearIcon(), suffix]);
        element = _createVNode("span", {
          "class": affixWrapperCls,
          "style": attrs.style,
          "hidden": !hasAddon({
            addonAfter: addonAfter,
            addonBefore: addonBefore
          }) && hidden,
          "onMousedown": onInputMouseDown,
          "ref": containerRef
        }, [prefix && _createVNode("span", {
          "class": "".concat(prefixCls, "-prefix")
        }, [prefix]), cloneElement(inputElement, {
          style: null,
          value: value,
          hidden: null
        }), suffixNode]);
      }
      // ================== Addon ================== //
      if (hasAddon({
        addonAfter: addonAfter,
        addonBefore: addonBefore
      })) {
        var wrapperCls = "".concat(prefixCls, "-group");
        var addonCls = "".concat(wrapperCls, "-addon");
        var mergedWrapperClassName = classNames("".concat(prefixCls, "-wrapper"), wrapperCls, wrapperClassName);
        var mergedGroupClassName = classNames("".concat(prefixCls, "-group-wrapper"), attrs.class, groupClassName);
        // Need another wrapper for changing display:table to display:inline-block
        // and put style prop in wrapper
        return _createVNode("span", {
          "class": mergedGroupClassName,
          "style": attrs.style,
          "hidden": hidden
        }, [_createVNode("span", {
          "class": mergedWrapperClassName
        }, [addonBefore && _createVNode("span", {
          "class": addonCls
        }, [addonBefore]), cloneElement(element, {
          style: null,
          hidden: null
        }), addonAfter && _createVNode("span", {
          "class": addonCls
        }, [addonAfter])])]);
      }
      return element;
    };
  }
});