import { createVNode as _createVNode } from "vue";
import { defineComponent } from 'vue';
export default defineComponent({
  name: 'PresetPanel',
  props: {
    prefixCls: String,
    presets: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    onClick: Function,
    onHover: Function
  },
  setup: function setup(props) {
    return function () {
      if (!props.presets.length) {
        return null;
      }
      return _createVNode("div", {
        "class": "".concat(props.prefixCls, "-presets")
      }, [_createVNode("ul", null, [props.presets.map(function (_ref, index) {
        var label = _ref.label,
          value = _ref.value;
        return _createVNode("li", {
          "key": index,
          "onClick": function onClick() {
            props.onClick(value);
          },
          "onMouseenter": function onMouseenter() {
            var _a;
            (_a = props.onHover) === null || _a === void 0 ? void 0 : _a.call(props, value);
          },
          "onMouseleave": function onMouseleave() {
            var _a;
            (_a = props.onHover) === null || _a === void 0 ? void 0 : _a.call(props, null);
          }
        }, [label]);
      })])]);
    };
  }
});