import { createVNode as _createVNode } from "vue";
export default function getRanges(_ref) {
  var prefixCls = _ref.prefixCls,
    _ref$components = _ref.components,
    components = _ref$components === void 0 ? {} : _ref$components,
    needConfirmButton = _ref.needConfirmButton,
    onNow = _ref.onNow,
    onOk = _ref.onOk,
    okDisabled = _ref.okDisabled,
    showNow = _ref.showNow,
    locale = _ref.locale;
  var presetNode;
  var okNode;
  if (needConfirmButton) {
    var Button = components.button || 'button';
    if (onNow && showNow !== false) {
      presetNode = _createVNode("li", {
        "class": "".concat(prefixCls, "-now")
      }, [_createVNode("a", {
        "class": "".concat(prefixCls, "-now-btn"),
        "onClick": onNow
      }, [locale.now])]);
    }
    okNode = needConfirmButton && _createVNode("li", {
      "class": "".concat(prefixCls, "-ok")
    }, [_createVNode(Button, {
      "disabled": okDisabled,
      "onClick": onOk
    }, {
      default: function _default() {
        return [locale.ok];
      }
    })]);
  }
  if (!presetNode && !okNode) {
    return null;
  }
  return _createVNode("ul", {
    "class": "".concat(prefixCls, "-ranges")
  }, [presetNode, okNode]);
}