import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import PropTypes from '../_util/vue-types';
import { defineComponent } from 'vue';
import classNames from '../_util/classNames';
import Step from './Step';
import { functionType, stringType } from '../_util/type';
import { filterEmpty } from '../_util/props-util';
import { cloneElement } from '../_util/vnode';
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'Steps',
  props: {
    type: PropTypes.string.def('default'),
    prefixCls: PropTypes.string.def('vc-steps'),
    iconPrefix: PropTypes.string.def('vc'),
    direction: PropTypes.string.def('horizontal'),
    labelPlacement: PropTypes.string.def('horizontal'),
    status: stringType('process'),
    size: PropTypes.string.def(''),
    progressDot: PropTypes.oneOfType([PropTypes.looseBool, PropTypes.func]).def(undefined),
    initial: PropTypes.number.def(0),
    current: PropTypes.number.def(0),
    items: PropTypes.array.def(function () {
      return [];
    }),
    icons: PropTypes.shape({
      finish: PropTypes.any,
      error: PropTypes.any
    }).loose,
    stepIcon: functionType(),
    isInline: PropTypes.looseBool,
    itemRender: functionType()
  },
  slots: ['stepIcon', 'progressDot'],
  emits: ['change'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit;
    var onStepClick = function onStepClick(next) {
      var current = props.current;
      if (current !== next) {
        emit('change', next);
      }
    };
    var renderStep = function renderStep(item, index, legacyRender) {
      var prefixCls = props.prefixCls,
        iconPrefix = props.iconPrefix,
        status = props.status,
        current = props.current,
        initial = props.initial,
        icons = props.icons,
        _props$stepIcon = props.stepIcon,
        stepIcon = _props$stepIcon === void 0 ? slots.stepIcon : _props$stepIcon,
        isInline = props.isInline,
        itemRender = props.itemRender,
        _props$progressDot = props.progressDot,
        progressDot = _props$progressDot === void 0 ? slots.progressDot : _props$progressDot;
      var mergedProgressDot = isInline || progressDot;
      var mergedItem = _extends(_extends({}, item), {
        class: ''
      });
      var stepNumber = initial + index;
      var commonProps = {
        active: stepNumber === current,
        stepNumber: stepNumber + 1,
        stepIndex: stepNumber,
        key: stepNumber,
        prefixCls: prefixCls,
        iconPrefix: iconPrefix,
        progressDot: mergedProgressDot,
        stepIcon: stepIcon,
        icons: icons,
        onStepClick: onStepClick
      };
      // fix tail color
      if (status === 'error' && index === current - 1) {
        mergedItem.class = "".concat(prefixCls, "-next-error");
      }
      if (!mergedItem.status) {
        if (stepNumber === current) {
          mergedItem.status = status;
        } else if (stepNumber < current) {
          mergedItem.status = 'finish';
        } else {
          mergedItem.status = 'wait';
        }
      }
      if (isInline) {
        mergedItem.icon = undefined;
        mergedItem.subTitle = undefined;
      }
      if (legacyRender) {
        return legacyRender(_extends(_extends({}, mergedItem), commonProps));
      }
      if (itemRender) {
        mergedItem.itemRender = function (stepItem) {
          return itemRender(mergedItem, stepItem);
        };
      }
      return _createVNode(Step, _objectSpread(_objectSpread(_objectSpread({}, mergedItem), commonProps), {}, {
        "__legacy": false
      }), null);
    };
    var renderStepWithNode = function renderStepWithNode(node, index) {
      return renderStep(_extends({}, node.props), index, function (stepProps) {
        var stepNode = cloneElement(node, stepProps);
        return stepNode;
      });
    };
    return function () {
      var _classNames;
      var _a;
      var prefixCls = props.prefixCls,
        direction = props.direction,
        type = props.type,
        labelPlacement = props.labelPlacement,
        iconPrefix = props.iconPrefix,
        status = props.status,
        size = props.size,
        current = props.current,
        _props$progressDot2 = props.progressDot,
        progressDot = _props$progressDot2 === void 0 ? slots.progressDot : _props$progressDot2,
        initial = props.initial,
        icons = props.icons,
        items = props.items,
        isInline = props.isInline,
        itemRender = props.itemRender,
        restProps = __rest(props, ["prefixCls", "direction", "type", "labelPlacement", "iconPrefix", "status", "size", "current", "progressDot", "initial", "icons", "items", "isInline", "itemRender"]);
      var isNav = type === 'navigation';
      var mergedProgressDot = isInline || progressDot;
      var mergedDirection = isInline ? 'horizontal' : direction;
      var mergedSize = isInline ? undefined : size;
      var adjustedLabelPlacement = mergedProgressDot ? 'vertical' : labelPlacement;
      var classString = classNames(prefixCls, "".concat(prefixCls, "-").concat(direction), (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-").concat(mergedSize), mergedSize), _defineProperty(_classNames, "".concat(prefixCls, "-label-").concat(adjustedLabelPlacement), mergedDirection === 'horizontal'), _defineProperty(_classNames, "".concat(prefixCls, "-dot"), !!mergedProgressDot), _defineProperty(_classNames, "".concat(prefixCls, "-navigation"), isNav), _defineProperty(_classNames, "".concat(prefixCls, "-inline"), isInline), _classNames));
      return _createVNode("div", _objectSpread({
        "class": classString
      }, restProps), [items.filter(function (item) {
        return item;
      }).map(function (item, index) {
        return renderStep(item, index);
      }), filterEmpty((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)).map(renderStepWithNode)]);
    };
  }
});