"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useClientCache;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _StyleContext = require("../StyleContext");
var _useHMR = _interopRequireDefault(require("./useHMR"));
var _vue = require("vue");
function useClientCache(prefix, keyPath, cacheFn, onCacheRemove) {
  var styleContext = (0, _StyleContext.useStyleInject)();
  var fullPathStr = (0, _vue.shallowRef)('');
  var res = (0, _vue.shallowRef)();
  (0, _vue.watchEffect)(function () {
    fullPathStr.value = [prefix].concat((0, _toConsumableArray2.default)(keyPath.value)).join('%');
  });
  var HMRUpdate = (0, _useHMR.default)();
  var clearCache = function clearCache(pathStr) {
    styleContext.value.cache.update(pathStr, function (prevCache) {
      var _ref = prevCache || [],
        _ref2 = (0, _slicedToArray2.default)(_ref, 2),
        _ref2$ = _ref2[0],
        times = _ref2$ === void 0 ? 0 : _ref2$,
        cache = _ref2[1];
      var nextCount = times - 1;
      if (nextCount === 0) {
        onCacheRemove === null || onCacheRemove === void 0 ? void 0 : onCacheRemove(cache, false);
        return null;
      }
      return [times - 1, cache];
    });
  };
  (0, _vue.watch)(fullPathStr, function (newStr, oldStr) {
    if (oldStr) clearCache(oldStr);
    // Create cache
    styleContext.value.cache.update(newStr, function (prevCache) {
      var _ref3 = prevCache || [],
        _ref4 = (0, _slicedToArray2.default)(_ref3, 2),
        _ref4$ = _ref4[0],
        times = _ref4$ === void 0 ? 0 : _ref4$,
        cache = _ref4[1];
      // HMR should always ignore cache since developer may change it
      var tmpCache = cache;
      if (process.env.NODE_ENV !== 'production' && cache && HMRUpdate) {
        onCacheRemove === null || onCacheRemove === void 0 ? void 0 : onCacheRemove(tmpCache, HMRUpdate);
        tmpCache = null;
      }
      var mergedCache = tmpCache || cacheFn();
      return [times + 1, mergedCache];
    });
    res.value = styleContext.value.cache.get(fullPathStr.value)[1];
  }, {
    immediate: true
  });
  (0, _vue.onBeforeUnmount)(function () {
    clearCache(fullPathStr.value);
  });
  return res;
}