"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._cf = void 0;
exports.default = useStyleRegister;
exports.extractStyle = extractStyle;
exports.normalizeStyle = normalizeStyle;
exports.parseStyle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _hash = _interopRequireDefault(require("@emotion/hash"));
var _unitless = _interopRequireDefault(require("@emotion/unitless"));
var _stylis = require("stylis");
var _linters = require("../linters");
var _StyleContext = require("../StyleContext");
var _util = require("../util");
var _useGlobalCache = _interopRequireDefault(require("./useGlobalCache"));
var _canUseDom = _interopRequireDefault(require("../../canUseDom"));
var _dynamicCSS = require("../../../vc-util/Dom/dynamicCSS");
var _vue = require("vue");
// @ts-ignore

var isClientSide = (0, _canUseDom.default)();
var SKIP_CHECK = '_skip_check_';
// ============================================================================
// ==                                 Parser                                 ==
// ============================================================================
// Preprocessor style content to browser support one
function normalizeStyle(styleStr) {
  var serialized = (0, _stylis.serialize)((0, _stylis.compile)(styleStr), _stylis.stringify);
  return serialized.replace(/\{%%%\:[^;];}/g, ';');
}
function isCompoundCSSProperty(value) {
  return (0, _typeof2.default)(value) === 'object' && value && SKIP_CHECK in value;
}
// 注入 hash 值
function injectSelectorHash(key, hashId, hashPriority) {
  if (!hashId) {
    return key;
  }
  var hashClassName = ".".concat(hashId);
  var hashSelector = hashPriority === 'low' ? ":where(".concat(hashClassName, ")") : hashClassName;
  // 注入 hashId
  var keys = key.split(',').map(function (k) {
    var _a;
    var fullPath = k.trim().split(/\s+/);
    // 如果 Selector 第一个是 HTML Element，那我们就插到它的后面。反之，就插到最前面。
    var firstPath = fullPath[0] || '';
    var htmlElement = ((_a = firstPath.match(/^\w+/)) === null || _a === void 0 ? void 0 : _a[0]) || '';
    firstPath = "".concat(htmlElement).concat(hashSelector).concat(firstPath.slice(htmlElement.length));
    return [firstPath].concat((0, _toConsumableArray2.default)(fullPath.slice(1))).join(' ');
  });
  return keys.join(',');
}
// Global effect style will mount once and not removed
// The effect will not save in SSR cache (e.g. keyframes)
var globalEffectStyleKeys = new Set();
/**
 * @private Test only. Clear the global effect style keys.
 */
var _cf = process.env.NODE_ENV !== 'production' ? function () {
  return globalEffectStyleKeys.clear();
} : undefined;
// Parse CSSObject to style content
exports._cf = _cf;
var parseStyle = function parseStyle(interpolation) {
  var config = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
      root: true,
      parentSelectors: []
    },
    root = _ref.root,
    injectHash = _ref.injectHash,
    parentSelectors = _ref.parentSelectors;
  var hashId = config.hashId,
    layer = config.layer,
    path = config.path,
    hashPriority = config.hashPriority,
    _config$transformers = config.transformers,
    transformers = _config$transformers === void 0 ? [] : _config$transformers,
    _config$linters = config.linters,
    linters = _config$linters === void 0 ? [] : _config$linters;
  var styleStr = '';
  var effectStyle = {};
  function parseKeyframes(keyframes) {
    var animationName = keyframes.getName(hashId);
    if (!effectStyle[animationName]) {
      var _parseStyle = parseStyle(keyframes.style, config, {
          root: false,
          parentSelectors: parentSelectors
        }),
        _parseStyle2 = (0, _slicedToArray2.default)(_parseStyle, 1),
        parsedStr = _parseStyle2[0];
      effectStyle[animationName] = "@keyframes ".concat(keyframes.getName(hashId)).concat(parsedStr);
    }
  }
  function flattenList(list) {
    var fullList = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    list.forEach(function (item) {
      if (Array.isArray(item)) {
        flattenList(item, fullList);
      } else if (item) {
        fullList.push(item);
      }
    });
    return fullList;
  }
  var flattenStyleList = flattenList(Array.isArray(interpolation) ? interpolation : [interpolation]);
  flattenStyleList.forEach(function (originStyle) {
    // Only root level can use raw string
    var style = typeof originStyle === 'string' && !root ? {} : originStyle;
    if (typeof style === 'string') {
      styleStr += "".concat(style, "\n");
    } else if (style._keyframe) {
      // Keyframe
      parseKeyframes(style);
    } else {
      var mergedStyle = transformers.reduce(function (prev, trans) {
        var _a;
        return ((_a = trans === null || trans === void 0 ? void 0 : trans.visit) === null || _a === void 0 ? void 0 : _a.call(trans, prev)) || prev;
      }, style);
      // Normal CSSObject
      Object.keys(mergedStyle).forEach(function (key) {
        var _a;
        var value = mergedStyle[key];
        if ((0, _typeof2.default)(value) === 'object' && value && (key !== 'animationName' || !value._keyframe) && !isCompoundCSSProperty(value)) {
          var subInjectHash = false;
          // 当成嵌套对象来处理
          var mergedKey = key.trim();
          // Whether treat child as root. In most case it is false.
          var nextRoot = false;
          // 拆分多个选择器
          if ((root || injectHash) && hashId) {
            if (mergedKey.startsWith('@')) {
              // 略过媒体查询，交给子节点继续插入 hashId
              subInjectHash = true;
            } else {
              // 注入 hashId
              mergedKey = injectSelectorHash(key, hashId, hashPriority);
            }
          } else if (root && !hashId && (mergedKey === '&' || mergedKey === '')) {
            // In case of `{ '&': { a: { color: 'red' } } }` or `{ '': { a: { color: 'red' } } }` without hashId,
            // we will get `&{a:{color:red;}}` or `{a:{color:red;}}` string for stylis to compile.
            // But it does not conform to stylis syntax,
            // and finally we will get `{color:red;}` as css, which is wrong.
            // So we need to remove key in root, and treat child `{ a: { color: 'red' } }` as root.
            mergedKey = '';
            nextRoot = true;
          }
          var _parseStyle3 = parseStyle(value, config, {
              root: nextRoot,
              injectHash: subInjectHash,
              parentSelectors: [].concat((0, _toConsumableArray2.default)(parentSelectors), [mergedKey])
            }),
            _parseStyle4 = (0, _slicedToArray2.default)(_parseStyle3, 2),
            parsedStr = _parseStyle4[0],
            childEffectStyle = _parseStyle4[1];
          effectStyle = (0, _extends2.default)((0, _extends2.default)({}, effectStyle), childEffectStyle);
          styleStr += "".concat(mergedKey).concat(parsedStr);
        } else {
          var actualValue = (_a = value === null || value === void 0 ? void 0 : value.value) !== null && _a !== void 0 ? _a : value;
          if (process.env.NODE_ENV !== 'production' && ((0, _typeof2.default)(value) !== 'object' || !(value === null || value === void 0 ? void 0 : value[SKIP_CHECK]))) {
            [_linters.contentQuotesLinter, _linters.hashedAnimationLinter].concat((0, _toConsumableArray2.default)(linters)).forEach(function (linter) {
              return linter(key, actualValue, {
                path: path,
                hashId: hashId,
                parentSelectors: parentSelectors
              });
            });
          }
          // 如果是样式则直接插入
          var styleName = key.replace(/[A-Z]/g, function (match) {
            return "-".concat(match.toLowerCase());
          });
          // Auto suffix with px
          var formatValue = actualValue;
          if (!_unitless.default[key] && typeof formatValue === 'number' && formatValue !== 0) {
            formatValue = "".concat(formatValue, "px");
          }
          // handle animationName & Keyframe value
          if (key === 'animationName' && (value === null || value === void 0 ? void 0 : value._keyframe)) {
            parseKeyframes(value);
            formatValue = value.getName(hashId);
          }
          styleStr += "".concat(styleName, ":").concat(formatValue, ";");
        }
      });
    }
  });
  if (!root) {
    styleStr = "{".concat(styleStr, "}");
  } else if (layer && (0, _util.supportLayer)()) {
    var layerCells = layer.split(',');
    var layerName = layerCells[layerCells.length - 1].trim();
    styleStr = "@layer ".concat(layerName, " {").concat(styleStr, "}");
    // Order of layer if needed
    if (layerCells.length > 1) {
      // zombieJ: stylis do not support layer order, so we need to handle it manually.
      styleStr = "@layer ".concat(layer, "{%%%:%}").concat(styleStr);
    }
  }
  return [styleStr, effectStyle];
};
// ============================================================================
// ==                                Register                                ==
// ============================================================================
exports.parseStyle = parseStyle;
function uniqueHash(path, styleStr) {
  return (0, _hash.default)("".concat(path.join('%')).concat(styleStr));
}
// function Empty() {
//   return null;
// }
/**
 * Register a style to the global style sheet.
 */
function useStyleRegister(info, styleFn) {
  var styleContext = (0, _StyleContext.useStyleInject)();
  var tokenKey = (0, _vue.computed)(function () {
    return info.value.token._tokenKey;
  });
  var fullPath = (0, _vue.computed)(function () {
    return [tokenKey.value].concat((0, _toConsumableArray2.default)(info.value.path));
  });
  // Check if need insert style
  var isMergedClientSide = isClientSide;
  if (process.env.NODE_ENV !== 'production' && styleContext.value.mock !== undefined) {
    isMergedClientSide = styleContext.value.mock === 'client';
  }
  // const [cacheStyle[0], cacheStyle[1], cacheStyle[2]]
  (0, _useGlobalCache.default)('style', fullPath,
  // Create cache if needed
  function () {
    var styleObj = styleFn();
    var _styleContext$value = styleContext.value,
      hashPriority = _styleContext$value.hashPriority,
      container = _styleContext$value.container,
      transformers = _styleContext$value.transformers,
      linters = _styleContext$value.linters;
    var _info$value = info.value,
      path = _info$value.path,
      hashId = _info$value.hashId,
      layer = _info$value.layer;
    var _parseStyle5 = parseStyle(styleObj, {
        hashId: hashId,
        hashPriority: hashPriority,
        layer: layer,
        path: path.join('-'),
        transformers: transformers,
        linters: linters
      }),
      _parseStyle6 = (0, _slicedToArray2.default)(_parseStyle5, 2),
      parsedStyle = _parseStyle6[0],
      effectStyle = _parseStyle6[1];
    var styleStr = normalizeStyle(parsedStyle);
    var styleId = uniqueHash(fullPath.value, styleStr);
    if (isMergedClientSide) {
      var style = (0, _dynamicCSS.updateCSS)(styleStr, styleId, {
        mark: _StyleContext.ATTR_MARK,
        prepend: 'queue',
        attachTo: container
      });
      style[_StyleContext.CSS_IN_JS_INSTANCE] = _StyleContext.CSS_IN_JS_INSTANCE_ID;
      // Used for `useCacheToken` to remove on batch when token removed
      style.setAttribute(_StyleContext.ATTR_TOKEN, tokenKey.value);
      // Dev usage to find which cache path made this easily
      if (process.env.NODE_ENV !== 'production') {
        style.setAttribute(_StyleContext.ATTR_DEV_CACHE_PATH, fullPath.value.join('|'));
      }
      // Inject client side effect style
      Object.keys(effectStyle).forEach(function (effectKey) {
        if (!globalEffectStyleKeys.has(effectKey)) {
          globalEffectStyleKeys.add(effectKey);
          // Inject
          (0, _dynamicCSS.updateCSS)(normalizeStyle(effectStyle[effectKey]), "_effect-".concat(effectKey), {
            mark: _StyleContext.ATTR_MARK,
            prepend: 'queue',
            attachTo: container
          });
        }
      });
    }
    return [styleStr, tokenKey.value, styleId];
  },
  // Remove cache if no need
  function (_ref2, fromHMR) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 3),
      styleId = _ref3[2];
    if ((fromHMR || styleContext.value.autoClear) && isClientSide) {
      (0, _dynamicCSS.removeCSS)(styleId, {
        mark: _StyleContext.ATTR_MARK
      });
    }
  });
  return function (node) {
    return node;
    // let styleNode: VueNode;
    // if (!styleContext.ssrInline || isMergedClientSide || !styleContext.defaultCache) {
    //   styleNode = <Empty />;
    // } else {
    //   styleNode = (
    //     <style
    //       {...{
    //         [ATTR_TOKEN]: cacheStyle.value[1],
    //         [ATTR_MARK]: cacheStyle.value[2],
    //       }}
    //       innerHTML={cacheStyle.value[0]}
    //     />
    //   );
    // }
    // return (
    //   <>
    //     {styleNode}
    //     {node}
    //   </>
    // );
  };
}
// ============================================================================
// ==                                  SSR                                   ==
// ============================================================================
function extractStyle(cache) {
  // prefix with `style` is used for `useStyleRegister` to cache style context
  var styleKeys = Array.from(cache.cache.keys()).filter(function (key) {
    return key.startsWith('style%');
  });
  // const tokenStyles: Record<string, string[]> = {};
  var styleText = '';
  styleKeys.forEach(function (key) {
    var _cache$cache$get$ = (0, _slicedToArray2.default)(cache.cache.get(key)[1], 3),
      styleStr = _cache$cache$get$[0],
      tokenKey = _cache$cache$get$[1],
      styleId = _cache$cache$get$[2];
    styleText += "<style ".concat(_StyleContext.ATTR_TOKEN, "=\"").concat(tokenKey, "\" ").concat(_StyleContext.ATTR_MARK, "=\"").concat(styleId, "\">").concat(styleStr, "</style>");
  });
  return styleText;
}