"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useResponsiveObserver;
exports.responsiveArray = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _vue = require("vue");
var _internal = require("../theme/internal");
var responsiveArray = ['xxxl', 'xxl', 'xl', 'lg', 'md', 'sm', 'xs'];
exports.responsiveArray = responsiveArray;
var getResponsiveMap = function getResponsiveMap(token) {
  return {
    xs: "(max-width: ".concat(token.screenXSMax, "px)"),
    sm: "(min-width: ".concat(token.screenSM, "px)"),
    md: "(min-width: ".concat(token.screenMD, "px)"),
    lg: "(min-width: ".concat(token.screenLG, "px)"),
    xl: "(min-width: ".concat(token.screenXL, "px)"),
    xxl: "(min-width: ".concat(token.screenXXL, "px)"),
    xxxl: "{min-width: ".concat(token.screenXXXL, "px}")
  };
};
function useResponsiveObserver() {
  var _useToken = (0, _internal.useToken)(),
    _useToken2 = (0, _slicedToArray2.default)(_useToken, 2),
    token = _useToken2[1];
  return (0, _vue.computed)(function () {
    var responsiveMap = getResponsiveMap(token.value);
    var subscribers = new Map();
    var subUid = -1;
    var screens = {};
    return {
      matchHandlers: {},
      dispatch: function dispatch(pointMap) {
        screens = pointMap;
        subscribers.forEach(function (func) {
          return func(screens);
        });
        return subscribers.size >= 1;
      },
      subscribe: function subscribe(func) {
        if (!subscribers.size) this.register();
        subUid += 1;
        subscribers.set(subUid, func);
        func(screens);
        return subUid;
      },
      unsubscribe: function unsubscribe(paramToken) {
        subscribers.delete(paramToken);
        if (!subscribers.size) this.unregister();
      },
      unregister: function unregister() {
        var _this = this;
        Object.keys(responsiveMap).forEach(function (screen) {
          var matchMediaQuery = responsiveMap[screen];
          var handler = _this.matchHandlers[matchMediaQuery];
          handler === null || handler === void 0 ? void 0 : handler.mql.removeListener(handler === null || handler === void 0 ? void 0 : handler.listener);
        });
        subscribers.clear();
      },
      register: function register() {
        var _this2 = this;
        Object.keys(responsiveMap).forEach(function (screen) {
          var matchMediaQuery = responsiveMap[screen];
          var listener = function listener(_ref) {
            var matches = _ref.matches;
            _this2.dispatch((0, _extends3.default)((0, _extends3.default)({}, screens), (0, _defineProperty2.default)({}, screen, matches)));
          };
          var mql = window.matchMedia(matchMediaQuery);
          mql.addListener(listener);
          _this2.matchHandlers[matchMediaQuery] = {
            mql: mql,
            listener: listener
          };
          listener(mql);
        });
      },
      responsiveMap: responsiveMap
    };
  });
}