"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _useState15 = _interopRequireDefault(require("../hooks/useState"));
var _type = require("../type");
var _util = require("./util");
var _raf = _interopRequireDefault(require("../raf"));
function validateNum(value) {
  return Number.isNaN(value) ? 0 : value;
}
var WaveEffect = (0, _vue.defineComponent)({
  props: {
    target: (0, _type.objectType)(),
    className: String
  },
  setup: function setup(props) {
    var divRef = (0, _vue.shallowRef)(null);
    var _useState = (0, _useState15.default)(null),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      color = _useState2[0],
      setWaveColor = _useState2[1];
    var _useState3 = (0, _useState15.default)([]),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      borderRadius = _useState4[0],
      setBorderRadius = _useState4[1];
    var _useState5 = (0, _useState15.default)(0),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      left = _useState6[0],
      setLeft = _useState6[1];
    var _useState7 = (0, _useState15.default)(0),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      top = _useState8[0],
      setTop = _useState8[1];
    var _useState9 = (0, _useState15.default)(0),
      _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
      width = _useState10[0],
      setWidth = _useState10[1];
    var _useState11 = (0, _useState15.default)(0),
      _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
      height = _useState12[0],
      setHeight = _useState12[1];
    var _useState13 = (0, _useState15.default)(false),
      _useState14 = (0, _slicedToArray2.default)(_useState13, 2),
      enabled = _useState14[0],
      setEnabled = _useState14[1];
    function syncPos() {
      var target = props.target;
      var nodeStyle = getComputedStyle(target);
      // Get wave color from target
      setWaveColor((0, _util.getTargetWaveColor)(target));
      var isStatic = nodeStyle.position === 'static';
      // Rect
      var borderLeftWidth = nodeStyle.borderLeftWidth,
        borderTopWidth = nodeStyle.borderTopWidth;
      setLeft(isStatic ? target.offsetLeft : validateNum(-parseFloat(borderLeftWidth)));
      setTop(isStatic ? target.offsetTop : validateNum(-parseFloat(borderTopWidth)));
      setWidth(target.offsetWidth);
      setHeight(target.offsetHeight);
      // Get border radius
      var borderTopLeftRadius = nodeStyle.borderTopLeftRadius,
        borderTopRightRadius = nodeStyle.borderTopRightRadius,
        borderBottomLeftRadius = nodeStyle.borderBottomLeftRadius,
        borderBottomRightRadius = nodeStyle.borderBottomRightRadius;
      setBorderRadius([borderTopLeftRadius, borderTopRightRadius, borderBottomRightRadius, borderBottomLeftRadius].map(function (radius) {
        return validateNum(parseFloat(radius));
      }));
    }
    // Add resize observer to follow size
    var resizeObserver;
    var rafId;
    var timeoutId;
    var clear = function clear() {
      clearTimeout(timeoutId);
      _raf.default.cancel(rafId);
      resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.disconnect();
    };
    var removeDom = function removeDom() {
      var _a;
      var holder = (_a = divRef.value) === null || _a === void 0 ? void 0 : _a.parentElement;
      if (holder) {
        (0, _vue.render)(null, holder);
        if (holder.parentElement) {
          holder.parentElement.removeChild(holder);
        }
      }
    };
    (0, _vue.onMounted)(function () {
      clear();
      timeoutId = setTimeout(function () {
        removeDom();
      }, 5000);
      var target = props.target;
      if (target) {
        // We need delay to check position here
        // since UI may change after click
        rafId = (0, _raf.default)(function () {
          syncPos();
          setEnabled(true);
        });
        if (typeof ResizeObserver !== 'undefined') {
          resizeObserver = new ResizeObserver(syncPos);
          resizeObserver.observe(target);
        }
      }
    });
    (0, _vue.onBeforeUnmount)(function () {
      clear();
    });
    var onTransitionend = function onTransitionend(e) {
      if (e.propertyName === 'opacity') {
        removeDom();
      }
    };
    return function () {
      if (!enabled.value) {
        return null;
      }
      var waveStyle = {
        left: "".concat(left.value, "px"),
        top: "".concat(top.value, "px"),
        width: "".concat(width.value, "px"),
        height: "".concat(height.value, "px"),
        borderRadius: borderRadius.value.map(function (radius) {
          return "".concat(radius, "px");
        }).join(' ')
      };
      if (color) {
        waveStyle['--wave-color'] = color.value;
      }
      return (0, _vue.createVNode)(_vue.Transition, {
        "appear": true,
        "name": "wave-motion",
        "appearFromClass": "wave-motion-appear",
        "appearActiveClass": "wave-motion-appear",
        "appearToClass": "wave-motion-appear wave-motion-appear-active"
      }, {
        default: function _default() {
          return [(0, _vue.createVNode)("div", {
            "ref": divRef,
            "class": props.className,
            "style": waveStyle,
            "onTransitionend": onTransitionend
          }, null)];
        }
      });
    };
  }
});
function showWaveEffect(node, className) {
  // Create holder
  var holder = document.createElement('div');
  holder.style.position = 'absolute';
  holder.style.left = "0px";
  holder.style.top = "0px";
  node === null || node === void 0 ? void 0 : node.insertBefore(holder, node === null || node === void 0 ? void 0 : node.firstChild);
  (0, _vue.render)((0, _vue.createVNode)(WaveEffect, {
    "target": node,
    "className": className
  }, null), holder);
}
var _default2 = showWaveEffect;
exports.default = _default2;