"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _vue = require("vue");
var _useConfigInject2 = _interopRequireDefault(require("../../config-provider/hooks/useConfigInject"));
var _isVisible = _interopRequireDefault(require("../../vc-util/Dom/isVisible"));
var _classNames = _interopRequireDefault(require("../classNames"));
var _propsUtil = require("../props-util");
var _style = _interopRequireDefault(require("./style"));
var _useWave = _interopRequireDefault(require("./useWave"));
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'Wave',
  props: {
    disabled: Boolean
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var instance = (0, _vue.getCurrentInstance)();
    var _useConfigInject = (0, _useConfigInject2.default)('wave', props),
      prefixCls = _useConfigInject.prefixCls;
    // ============================== Style ===============================
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      hashId = _useStyle2[1];
    // =============================== Wave ===============================
    var showWave = (0, _useWave.default)(instance, (0, _vue.computed)(function () {
      return (0, _classNames.default)(prefixCls.value, hashId.value);
    }));
    var onClick;
    var clear = function clear() {
      var node = (0, _propsUtil.findDOMNode)(instance);
      node.removeEventListener('click', onClick, true);
    };
    (0, _vue.onMounted)(function () {
      (0, _vue.watch)(function () {
        return props.disabled;
      }, function () {
        clear();
        (0, _vue.nextTick)(function () {
          var node = (0, _propsUtil.findDOMNode)(instance);
          if (!node || node.nodeType !== 1 || props.disabled) {
            return;
          }
          // Click handler
          var onClick = function onClick(e) {
            // Fix radio button click twice
            if (e.target.tagName === 'INPUT' || !(0, _isVisible.default)(e.target) ||
            // No need wave
            !node.getAttribute || node.getAttribute('disabled') || node.disabled || node.className.includes('disabled') || node.className.includes('-leave')) {
              return;
            }
            showWave();
          };
          // Bind events
          node.addEventListener('click', onClick, true);
        });
      }, {
        immediate: true,
        flush: 'post'
      });
    });
    (0, _vue.onBeforeUnmount)(function () {
      clear();
    });
    return function () {
      var _a;
      // ============================== Render ==============================
      var children = (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)[0];
      return children;
    };
  }
});
exports.default = _default;