"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.alertProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseOutlined"));
var _CheckCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CheckCircleOutlined"));
var _ExclamationCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/ExclamationCircleOutlined"));
var _InfoCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/InfoCircleOutlined"));
var _CloseCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseCircleOutlined"));
var _CheckCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CheckCircleFilled"));
var _ExclamationCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/ExclamationCircleFilled"));
var _InfoCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/InfoCircleFilled"));
var _CloseCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseCircleFilled"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _transition = require("../_util/transition");
var _propsUtil = require("../_util/props-util");
var _type = require("../_util/type");
var _vnode = require("../_util/vnode");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _style = _interopRequireDefault(require("./style"));
var iconMapFilled = {
  success: _CheckCircleFilled.default,
  info: _InfoCircleFilled.default,
  error: _CloseCircleFilled.default,
  warning: _ExclamationCircleFilled.default
};
var iconMapOutlined = {
  success: _CheckCircleOutlined.default,
  info: _InfoCircleOutlined.default,
  error: _CloseCircleOutlined.default,
  warning: _ExclamationCircleOutlined.default
};
var AlertTypes = (0, _type.tuple)('success', 'info', 'warning', 'error');
var alertProps = function alertProps() {
  return {
    /**
     * Type of Alert styles, options: `success`, `info`, `warning`, `error`
     */
    type: _vueTypes.default.oneOf(AlertTypes),
    /** Whether Alert can be closed */
    closable: {
      type: Boolean,
      default: undefined
    },
    /** Close text to show */
    closeText: _vueTypes.default.any,
    /** Content of Alert */
    message: _vueTypes.default.any,
    /** Additional content of Alert */
    description: _vueTypes.default.any,
    /** Trigger when animation ending of Alert */
    afterClose: Function,
    /** Whether to show icon */
    showIcon: {
      type: Boolean,
      default: undefined
    },
    prefixCls: String,
    banner: {
      type: Boolean,
      default: undefined
    },
    icon: _vueTypes.default.any,
    closeIcon: _vueTypes.default.any,
    onClose: Function
  };
};
exports.alertProps = alertProps;
var Alert = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AAlert',
  inheritAttrs: false,
  props: alertProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs,
      expose = _ref.expose;
    var _useConfigInject = (0, _useConfigInject2.default)('alert', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var closing = (0, _vue.shallowRef)(false);
    var closed = (0, _vue.shallowRef)(false);
    var alertNode = (0, _vue.shallowRef)();
    var handleClose = function handleClose(e) {
      e.preventDefault();
      var dom = alertNode.value;
      dom.style.height = "".concat(dom.offsetHeight, "px");
      // Magic code
      // 重复一次后才能正确设置 height
      dom.style.height = "".concat(dom.offsetHeight, "px");
      closing.value = true;
      emit('close', e);
    };
    var animationEnd = function animationEnd() {
      var _a;
      closing.value = false;
      closed.value = true;
      (_a = props.afterClose) === null || _a === void 0 ? void 0 : _a.call(props);
    };
    var mergedType = (0, _vue.computed)(function () {
      var type = props.type;
      if (type !== undefined) {
        return type;
      }
      // banner 模式默认为警告
      return props.banner ? 'warning' : 'info';
    });
    expose({
      animationEnd: animationEnd
    });
    var motionStyle = (0, _vue.shallowRef)({});
    return function () {
      var _classNames;
      var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
      var banner = props.banner,
        _props$closeIcon = props.closeIcon,
        customCloseIcon = _props$closeIcon === void 0 ? (_a = slots.closeIcon) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$closeIcon;
      var closable = props.closable,
        showIcon = props.showIcon;
      var closeText = (_b = props.closeText) !== null && _b !== void 0 ? _b : (_c = slots.closeText) === null || _c === void 0 ? void 0 : _c.call(slots);
      var description = (_d = props.description) !== null && _d !== void 0 ? _d : (_e = slots.description) === null || _e === void 0 ? void 0 : _e.call(slots);
      var message = (_f = props.message) !== null && _f !== void 0 ? _f : (_g = slots.message) === null || _g === void 0 ? void 0 : _g.call(slots);
      var icon = (_h = props.icon) !== null && _h !== void 0 ? _h : (_j = slots.icon) === null || _j === void 0 ? void 0 : _j.call(slots);
      var action = (_k = slots.action) === null || _k === void 0 ? void 0 : _k.call(slots);
      // banner模式默认有 Icon
      showIcon = banner && showIcon === undefined ? true : showIcon;
      var IconType = (description ? iconMapOutlined : iconMapFilled)[mergedType.value] || null;
      // closeable when closeText is assigned
      if (closeText) {
        closable = true;
      }
      var prefixClsValue = prefixCls.value;
      var alertCls = (0, _classNames2.default)(prefixClsValue, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-").concat(mergedType.value), true), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-closing"), closing.value), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-with-description"), !!description), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-no-icon"), !showIcon), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-banner"), !!banner), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-closable"), closable), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames, hashId.value, true), _classNames));
      var closeIcon = closable ? (0, _vue.createVNode)("button", {
        "type": "button",
        "onClick": handleClose,
        "class": "".concat(prefixClsValue, "-close-icon"),
        "tabindex": 0
      }, [closeText ? (0, _vue.createVNode)("span", {
        "class": "".concat(prefixClsValue, "-close-text")
      }, [closeText]) : customCloseIcon === undefined ? (0, _vue.createVNode)(_CloseOutlined.default, null, null) : customCloseIcon]) : null;
      var iconNode = icon && ((0, _propsUtil.isValidElement)(icon) ? (0, _vnode.cloneElement)(icon, {
        class: "".concat(prefixClsValue, "-icon")
      }) : (0, _vue.createVNode)("span", {
        "class": "".concat(prefixClsValue, "-icon")
      }, [icon])) || (0, _vue.createVNode)(IconType, {
        "class": "".concat(prefixClsValue, "-icon")
      }, null);
      var transitionProps = (0, _transition.getTransitionProps)("".concat(prefixClsValue, "-motion"), {
        appear: false,
        css: true,
        onAfterLeave: animationEnd,
        onBeforeLeave: function onBeforeLeave(node) {
          node.style.maxHeight = "".concat(node.offsetHeight, "px");
        },
        onLeave: function onLeave(node) {
          node.style.maxHeight = '0px';
        }
      });
      return wrapSSR(closed.value ? null : (0, _vue.createVNode)(_transition.Transition, transitionProps, {
        default: function _default() {
          return [(0, _vue.withDirectives)((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({
            "role": "alert"
          }, attrs), {}, {
            "style": [attrs.style, motionStyle.value],
            "class": [attrs.class, alertCls],
            "data-show": !closing.value,
            "ref": alertNode
          }), [showIcon ? iconNode : null, (0, _vue.createVNode)("div", {
            "class": "".concat(prefixClsValue, "-content")
          }, [message ? (0, _vue.createVNode)("div", {
            "class": "".concat(prefixClsValue, "-message")
          }, [message]) : null, description ? (0, _vue.createVNode)("div", {
            "class": "".concat(prefixClsValue, "-description")
          }, [description]) : null]), action ? (0, _vue.createVNode)("div", {
            "class": "".concat(prefixClsValue, "-action")
          }, [action]) : null, closeIcon]), [[_vue.vShow, !closing.value]])];
        }
      }));
    };
  }
});
var _default2 = (0, _type.withInstall)(Alert);
exports.default = _default2;