"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.anchorLinkProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propsUtil = require("../_util/props-util");
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _context = require("./context");
var _type = require("../_util/type");
var anchorLinkProps = function anchorLinkProps() {
  return {
    prefixCls: String,
    href: String,
    title: (0, _type.anyType)(),
    target: String,
    /* private use  */
    customTitleProps: (0, _type.objectType)()
  };
};
exports.anchorLinkProps = anchorLinkProps;
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AAnchorLink',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)(anchorLinkProps(), {
    href: '#'
  }),
  slots: ['title', 'customTitle'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var mergedTitle = null;
    var _useInjectAnchor = (0, _context.useInjectAnchor)(),
      contextHandleClick = _useInjectAnchor.handleClick,
      scrollTo = _useInjectAnchor.scrollTo,
      unregisterLink = _useInjectAnchor.unregisterLink,
      registerLink = _useInjectAnchor.registerLink,
      activeLink = _useInjectAnchor.activeLink;
    var _useConfigInject = (0, _useConfigInject2.default)('anchor', props),
      prefixCls = _useConfigInject.prefixCls;
    var handleClick = function handleClick(e) {
      var href = props.href;
      contextHandleClick(e, {
        title: mergedTitle,
        href: href
      });
      scrollTo(href);
    };
    (0, _vue.watch)(function () {
      return props.href;
    }, function (val, oldVal) {
      (0, _vue.nextTick)(function () {
        unregisterLink(oldVal);
        registerLink(val);
      });
    });
    (0, _vue.onMounted)(function () {
      registerLink(props.href);
    });
    (0, _vue.onBeforeUnmount)(function () {
      unregisterLink(props.href);
    });
    return function () {
      var _a;
      var href = props.href,
        target = props.target,
        _props$title = props.title,
        title = _props$title === void 0 ? slots.title : _props$title,
        _props$customTitlePro = props.customTitleProps,
        customTitleProps = _props$customTitlePro === void 0 ? {} : _props$customTitlePro;
      var pre = prefixCls.value;
      mergedTitle = typeof title === 'function' ? title(customTitleProps) : title;
      var active = activeLink.value === href;
      var wrapperClassName = (0, _classNames3.default)("".concat(pre, "-link"), (0, _defineProperty2.default)({}, "".concat(pre, "-link-active"), active), attrs.class);
      var titleClassName = (0, _classNames3.default)("".concat(pre, "-link-title"), (0, _defineProperty2.default)({}, "".concat(pre, "-link-title-active"), active));
      return (0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": wrapperClassName
      }), [(0, _vue.createVNode)("a", {
        "class": titleClassName,
        "href": href,
        "title": typeof mergedTitle === 'string' ? mergedTitle : '',
        "target": target,
        "onClick": handleClick
      }, [slots.customTitle ? slots.customTitle(customTitleProps) : mergedTitle]), (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]);
    };
  }
});
exports.default = _default;