"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _internal = require("../../theme/internal");
var _style = require("../../style");
// ============================== Shared ==============================
var genSharedAnchorStyle = function genSharedAnchorStyle(token) {
  var _$concat, _$concat3;
  var componentCls = token.componentCls,
    holderOffsetBlock = token.holderOffsetBlock,
    motionDurationSlow = token.motionDurationSlow,
    lineWidthBold = token.lineWidthBold,
    colorPrimary = token.colorPrimary,
    lineType = token.lineType,
    colorSplit = token.colorSplit;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-wrapper"), (_$concat3 = {
    marginBlockStart: -holderOffsetBlock,
    paddingBlockStart: holderOffsetBlock,
    // delete overflow: auto
    // overflow: 'auto',
    backgroundColor: 'transparent'
  }, (0, _defineProperty2.default)(_$concat3, componentCls, (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (0, _defineProperty2.default)({
    position: 'relative',
    paddingInlineStart: lineWidthBold
  }, "".concat(componentCls, "-link"), (_$concat = {
    paddingBlock: token.anchorPaddingBlock,
    paddingInline: "".concat(token.anchorPaddingInline, "px 0"),
    '&-title': (0, _extends3.default)((0, _extends3.default)({}, _style.textEllipsis), {
      position: 'relative',
      display: 'block',
      marginBlockEnd: token.anchorTitleBlock,
      color: token.colorText,
      transition: "all ".concat(token.motionDurationSlow),
      '&:only-child': {
        marginBlockEnd: 0
      }
    })
  }, (0, _defineProperty2.default)(_$concat, "&-active > ".concat(componentCls, "-link-title"), {
    color: token.colorPrimary
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-link"), {
    paddingBlock: token.anchorPaddingBlockSecondary
  }), _$concat)))), (0, _defineProperty2.default)(_$concat3, "&:not(".concat(componentCls, "-wrapper-horizontal)"), (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({
    '&::before': {
      position: 'absolute',
      left: {
        _skip_check_: true,
        value: 0
      },
      top: 0,
      height: '100%',
      borderInlineStart: "".concat(lineWidthBold, "px ").concat(lineType, " ").concat(colorSplit),
      content: '" "'
    }
  }, "".concat(componentCls, "-ink"), (0, _defineProperty2.default)({
    position: 'absolute',
    left: {
      _skip_check_: true,
      value: 0
    },
    display: 'none',
    transform: 'translateY(-50%)',
    transition: "top ".concat(motionDurationSlow, " ease-in-out"),
    width: lineWidthBold,
    backgroundColor: colorPrimary
  }, "&".concat(componentCls, "-ink-visible"), {
    display: 'inline-block'
  })))), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-fixed ").concat(componentCls, "-ink ").concat(componentCls, "-ink"), {
    display: 'none'
  }), _$concat3));
};
var genSharedAnchorHorizontalStyle = function genSharedAnchorHorizontalStyle(token) {
  var _componentCls2;
  var componentCls = token.componentCls,
    motionDurationSlow = token.motionDurationSlow,
    lineWidthBold = token.lineWidthBold,
    colorPrimary = token.colorPrimary;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-wrapper-horizontal"), (0, _defineProperty2.default)({
    position: 'relative',
    '&::before': {
      position: 'absolute',
      left: {
        _skip_check_: true,
        value: 0
      },
      right: {
        _skip_check_: true,
        value: 0
      },
      bottom: 0,
      borderBottom: "1px ".concat(token.lineType, " ").concat(token.colorSplit),
      content: '" "'
    }
  }, componentCls, (_componentCls2 = {
    overflowX: 'scroll',
    position: 'relative',
    display: 'flex',
    scrollbarWidth: 'none' /* Firefox */,
    '&::-webkit-scrollbar': {
      display: 'none' /* Safari and Chrome */
    }
  }, (0, _defineProperty2.default)(_componentCls2, "".concat(componentCls, "-link:first-of-type"), {
    paddingInline: 0
  }), (0, _defineProperty2.default)(_componentCls2, "".concat(componentCls, "-ink"), {
    position: 'absolute',
    bottom: 0,
    transition: "left ".concat(motionDurationSlow, " ease-in-out, width ").concat(motionDurationSlow, " ease-in-out"),
    height: lineWidthBold,
    backgroundColor: colorPrimary
  }), _componentCls2)));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Anchor', function (token) {
  var fontSize = token.fontSize,
    fontSizeLG = token.fontSizeLG,
    padding = token.padding,
    paddingXXS = token.paddingXXS;
  var anchorToken = (0, _internal.mergeToken)(token, {
    holderOffsetBlock: paddingXXS,
    anchorPaddingBlock: paddingXXS,
    anchorPaddingBlockSecondary: paddingXXS / 2,
    anchorPaddingInline: padding,
    anchorTitleBlock: fontSize / 14 * 3,
    anchorBallSize: fontSizeLG / 2
  });
  return [genSharedAnchorStyle(anchorToken), genSharedAnchorHorizontalStyle(anchorToken)];
});
exports.default = _default;